/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.http_libs.request.multi;

import com.abupdate.http_libs.request.multi.AbstractPart;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FilePart
extends AbstractPart {
    public File file;
    public static final String TAG = FilePart.class.getSimpleName();

    public FilePart(String string, File file) {
        this(string, file, "application/octet-stream");
    }

    public FilePart(String string, File file, String string2) {
        super(string, string2);
        this.file = file;
    }

    @Override
    protected byte[] createContentType() {
        return ("Content-Type: " + this.mimeType + "\r\n").getBytes(infoCharset);
    }

    @Override
    protected byte[] createContentDisposition() {
        String string = "Content-Disposition: form-data; name=\"" + this.key;
        return (string + "\"; filename=\"" + this.file.getName() + "\"\r\n").getBytes(infoCharset);
    }

    @Override
    public long getTotalLength() {
        long l = this.file.length();
        return (long)this.header.length + l + (long)CR_LF.length;
    }

    @Override
    public byte[] getTransferEncoding() {
        return TRANSFER_ENCODING_BINARY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outputStream) {
        try (FileInputStream fileInputStream = new FileInputStream(this.file);){
            int n;
            byte[] byArray = new byte[4096];
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
                this.updateProgress(n);
            }
            outputStream.write(CR_LF);
            this.updateProgress(CR_LF.length);
            outputStream.flush();
        }
    }
}

