/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.http_libs.inter;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.abupdate.http_libs.exception.HttpException;
import com.abupdate.http_libs.request.base.Request;
import com.abupdate.http_libs.response.Response;

public abstract class HttpListener {
    private static final String TAG = HttpListener.class.getSimpleName();
    private static final int M_START = 1;
    private static final int M_SUCCESS = 2;
    private static final int M_FAILURE = 3;
    private static final int M_RETRY = 4;
    private static final int M_REDIRECT = 5;
    private static final int M_END = 6;
    private HttpHandler handler;
    private boolean runOnUiThread = true;
    private HttpListener linkedListener;
    private long delayMillis;
    private boolean disableListener = false;

    public HttpListener() {
        this(true);
    }

    public HttpListener(long l) {
        this.delayMillis = l;
    }

    public HttpListener(boolean bl) {
        this.setRunOnUiThread(bl);
    }

    public final HttpListener getListener() {
        return this.linkedListener;
    }

    public final boolean isRunOnUiThread() {
        return this.runOnUiThread;
    }

    public final HttpListener setRunOnUiThread(boolean bl) {
        this.runOnUiThread = bl;
        this.handler = bl ? new HttpHandler(Looper.getMainLooper()) : null;
        return this;
    }

    public long getDelayMillis() {
        return this.delayMillis;
    }

    public HttpListener setDelayMillis(long l) {
        this.delayMillis = l;
        return this;
    }

    public final void notifyCallStart(Request request) {
        if (this.disableListener) {
            return;
        }
        if (this.runOnUiThread) {
            Message message = this.handler.obtainMessage(1);
            message.obj = request;
            this.handler.sendMessage(message);
        } else {
            this.onStart(request);
        }
        if (this.linkedListener != null) {
            this.linkedListener.notifyCallStart(request);
        }
    }

    public final void notifyCallSuccess(String string, Response response) {
        this.delayOrNot();
        if (this.disableListener) {
            return;
        }
        if (this.runOnUiThread) {
            Message message = this.handler.obtainMessage(2);
            message.obj = new Object[]{string, response};
            this.handler.sendMessage(message);
        } else {
            this.onSuccess(string, response);
        }
        if (this.linkedListener != null) {
            this.linkedListener.notifyCallSuccess(string, response);
        }
    }

    public final void notifyCallFailure(HttpException httpException, Response response) {
        this.delayOrNot();
        if (this.disableListener) {
            return;
        }
        if (this.runOnUiThread) {
            Message message = this.handler.obtainMessage(3);
            message.obj = new Object[]{httpException, response};
            this.handler.sendMessage(message);
        } else {
            this.onFailure(httpException, response);
        }
        if (this.linkedListener != null) {
            this.linkedListener.notifyCallFailure(httpException, response);
        }
    }

    public final void notifyCallRetry(Request request, int n, int n2) {
        if (this.disableListener) {
            return;
        }
        if (this.runOnUiThread) {
            Message message = this.handler.obtainMessage(4);
            message.obj = new Object[]{request, n, n2};
            this.handler.sendMessage(message);
        } else {
            this.onRetry(request, n, n2);
        }
        if (this.linkedListener != null) {
            this.linkedListener.notifyCallRetry(request, n, n2);
        }
    }

    public final void notifyCallRedirect(Request request, int n, int n2) {
        if (this.disableListener) {
            return;
        }
        if (this.runOnUiThread) {
            Message message = this.handler.obtainMessage(5);
            message.obj = new Object[]{request, n, n2};
            this.handler.sendMessage(message);
        } else {
            this.onRedirect(request, n, n2);
        }
        if (this.linkedListener != null) {
            this.linkedListener.notifyCallRedirect(request, n, n2);
        }
    }

    public final void notifyCallEnd(Response response) {
        if (this.disableListener) {
            return;
        }
        if (this.runOnUiThread) {
            Message message = this.handler.obtainMessage(6);
            message.obj = response;
            this.handler.sendMessage(message);
        } else {
            this.onEnd(response);
        }
        if (this.linkedListener != null) {
            this.linkedListener.notifyCallEnd(response);
        }
    }

    private boolean delayOrNot() {
        if (this.delayMillis > 0L) {
            try {
                Thread.sleep(this.delayMillis);
                return true;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return false;
    }

    public void disableListener(boolean bl) {
        this.disableListener = bl;
    }

    public void onStart(Request request) {
    }

    public void onSuccess(String string, Response response) {
    }

    public void onFailure(HttpException httpException, Response response) {
    }

    public void onRetry(Request request, int n, int n2) {
    }

    public void onRedirect(Request request, int n, int n2) {
    }

    public void onEnd(Response response) {
    }

    private class HttpHandler
    extends Handler {
        private HttpHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            if (HttpListener.this.disableListener) {
                return;
            }
            switch (message.what) {
                case 1: {
                    HttpListener.this.onStart((Request)message.obj);
                    break;
                }
                case 2: {
                    Object[] objectArray = (Object[])message.obj;
                    HttpListener.this.onSuccess((String)objectArray[0], (Response)objectArray[1]);
                    break;
                }
                case 3: {
                    Object[] objectArray = (Object[])message.obj;
                    HttpListener.this.onFailure((HttpException)objectArray[0], (Response)objectArray[1]);
                    break;
                }
                case 4: {
                    Object[] objectArray = (Object[])message.obj;
                    HttpListener.this.onRetry((Request)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2]);
                    break;
                }
                case 5: {
                    Object[] objectArray = (Object[])message.obj;
                    HttpListener.this.onRedirect((Request)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2]);
                    break;
                }
                case 6: {
                    HttpListener.this.onEnd((Response)message.obj);
                }
            }
        }
    }
}

