/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.http_libs.engine;

import android.content.Context;
import android.os.AsyncTask;
import com.abupdate.http_libs.data.HttpConfig;
import com.abupdate.http_libs.data.b;
import com.abupdate.http_libs.data.c;
import com.abupdate.http_libs.exception.HttpException;
import com.abupdate.http_libs.inter.HttpListener;
import com.abupdate.http_libs.request.base.Request;
import com.abupdate.http_libs.request.content.HttpBody;
import com.abupdate.http_libs.response.InternalResponse;
import com.abupdate.trace.Trace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class HttpManager {
    private static final String a = HttpManager.class.getSimpleName();
    private HttpConfig b;

    public static HttpConfig build(Context context) {
        return new HttpConfig(context);
    }

    public HttpManager(HttpConfig httpConfig) {
        this.a(httpConfig);
    }

    private void a(HttpConfig httpConfig) {
        this.b = httpConfig;
        Trace.d((String)a, (String)("initConfig() " + httpConfig.toString()));
    }

    public final HttpConfig getConfig() {
        return this.b;
    }

    public void enqueue(Request request) {
        a a2 = new a();
        a2.execute(new Request[]{request});
    }

    public InternalResponse execute(Request request) {
        InternalResponse internalResponse = this.a(request);
        if (request.getHttpListener() != null) {
            request.getHttpListener().disableListener(true);
        }
        this.a(request, internalResponse);
        return internalResponse;
    }

    private boolean a(Request request, InternalResponse internalResponse) {
        internalResponse.setRedirectTimes(0);
        internalResponse.setRetryTimes(0);
        for (int i = 1; i <= request.getMaxRetryTimes() + 1; ++i) {
            if (i > 1) {
                internalResponse.setRetryTimes(internalResponse.getRetryTimes() + 1);
                if (request.getHttpListener() != null) {
                    request.getHttpListener().notifyCallRetry(request, request.getMaxRetryTimes(), internalResponse.getRetryTimes());
                }
            }
            boolean bl = false;
            try {
                bl = this.b(request, internalResponse);
            }
            catch (HttpException httpException) {
                httpException.printStackTrace();
                internalResponse.setException(httpException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                HttpException httpException = new HttpException(exception);
                internalResponse.setException(httpException);
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean b(Request request, InternalResponse internalResponse) {
        String string = request.getUrl();
        URL uRL = null;
        try (InputStream inputStream = null;){
            Object object;
            HttpURLConnection httpURLConnection;
            uRL = new URL(string);
            if (string.startsWith("https")) {
                HttpURLConnection httpURLConnection2 = httpURLConnection = (HttpsURLConnection)uRL.openConnection();
                if (null != request.getHostnameVerifier()) {
                    ((HttpsURLConnection)httpURLConnection2).setHostnameVerifier(request.getHostnameVerifier());
                }
                if (null != request.getSslSocketFactory()) {
                    ((HttpsURLConnection)httpURLConnection2).setSSLSocketFactory(request.getSslSocketFactory());
                }
            } else {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            httpURLConnection.setConnectTimeout(request.getConnectTimeout());
            httpURLConnection.setReadTimeout(request.getSocketTimeout());
            httpURLConnection.setRequestMethod(request.getMethod().a());
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestProperty("Content-Type", request.getContentType());
            this.a(httpURLConnection, request);
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                Trace.d((String)a, (String)("connect() responseCode\uff1a" + n));
            }
            b b2 = new b(n, httpURLConnection.getResponseMessage());
            internalResponse.setHttpStatus(b2);
            inputStream = httpURLConnection.getInputStream();
            if (inputStream == null) {
                throw new HttpException(1);
            }
            ArrayList<c> arrayList = new ArrayList<c>();
            for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
                List<String> list;
                if (entry.getKey() == null || (list = entry.getValue()) == null) continue;
                for (String string2 : list) {
                    arrayList.add(new c(entry.getKey(), string2));
                }
            }
            internalResponse.setHeaders(arrayList);
            internalResponse.setContentLength(httpURLConnection.getContentLength());
            internalResponse.setContentEncoding(httpURLConnection.getContentEncoding());
            internalResponse.setContentType(httpURLConnection.getContentType());
            if (n <= 299 || n == 600) {
                Map.Entry<String, List<String>> entry;
                object = this.a(internalResponse.getContentType(), request.getCharset());
                internalResponse.setCharset((String)object);
                entry = HttpManager.a(inputStream, request.getCharset());
                internalResponse.setContent((String)((Object)entry));
                if (request.getHttpListener() != null) {
                    request.getHttpListener().notifyCallSuccess((String)((Object)entry), internalResponse);
                }
                boolean bl = true;
                return bl;
            }
            if (n <= 399) {
                if (internalResponse.getRedirectTimes() < request.getMaxRedirectTimes()) {
                    internalResponse.setRedirectTimes(internalResponse.getRedirectTimes() + 1);
                    if (request.getHttpListener() != null) {
                        request.getHttpListener().notifyCallRedirect(request, request.getMaxRedirectTimes(), internalResponse.getRedirectTimes());
                    }
                    object = httpURLConnection.getURL();
                    Trace.d((String)a, (String)("connect() \u91cd\u5b9a\u5411:" + ((URL)object).toString()));
                    request.setUrl(((URL)object).toString());
                    this.b(request, internalResponse);
                }
            } else {
                if (n <= 499) {
                    throw new HttpException(b2.a(), new Throwable(b2.d()));
                }
                if (n < 599) {
                    throw new HttpException(b2.a(), new Throwable(b2.d()));
                }
            }
        }
        return false;
    }

    private void a(HttpURLConnection httpURLConnection, Request request) {
        HttpBody httpBody = request.getHttpBody();
        if (httpBody != null && request.getMethod() == com.abupdate.http_libs.data.a.g) {
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestProperty("Content-Type", httpBody.getContentType());
            OutputStream outputStream = httpURLConnection.getOutputStream();
            httpBody.writeTo(outputStream);
            outputStream.close();
        }
    }

    protected InternalResponse a(Request request) {
        if (request.getConnectTimeout() <= 0) {
            request.setConnectTimeout(this.b.getConnectTimeout());
        }
        if (request.getSocketTimeout() <= 0) {
            request.setSocketTimeout(this.b.getSocketTimeout());
        }
        if (request.getMethod() == null) {
            request.setMethod(com.abupdate.http_libs.data.a.a);
        }
        if (request.getCharset() == null) {
            request.setCharset("UTF-8");
        }
        if (request.getMaxRetryTimes() <= 0) {
            request.setMaxRetryTimes(this.b.getRetryTimes());
        }
        if (request.getMaxRedirectTimes() <= 0) {
            request.setMaxRedirectTimes(this.b.getRedirectTimes());
        }
        if (request.getContentType() == null) {
            request.setHeaderContentType("application/x-www-form-urlencoded; charset=UTF-8");
        }
        return new InternalResponse(request);
    }

    private String a(String string, String string2) {
        if (string != null) {
            String[] stringArray;
            for (String string3 : stringArray = string.split(";")) {
                if (!(string3 = string3.trim()).toLowerCase().startsWith("charset=")) continue;
                return string3.substring("charset=".length());
            }
        }
        return string2 == null ? "UTF-8" : string2;
    }

    private static String a(InputStream inputStream, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        String string2 = "";
        if (inputStream != null) {
            try {
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                string2 = new String(byteArrayOutputStream.toByteArray(), string);
            }
            catch (IOException iOException) {
                Trace.d((String)a, (String)("getResultString() exception:" + iOException.toString()));
                iOException.printStackTrace();
            }
        }
        return string2;
    }

    private class a
    extends AsyncTask<Request, Integer, InternalResponse> {
        private a() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected InternalResponse a(Request[] requestArray) {
            boolean bl;
            Request request = requestArray[0];
            InternalResponse internalResponse = HttpManager.this.a(request);
            HttpListener httpListener = request.getHttpListener();
            if (httpListener != null) {
                httpListener.notifyCallStart(request);
            }
            if (!(bl = HttpManager.this.a(request, internalResponse)) && httpListener != null) {
                httpListener.notifyCallFailure(internalResponse.getException(), internalResponse);
            }
            return internalResponse;
        }

        protected void a(InternalResponse internalResponse) {
            HttpListener httpListener = internalResponse.getRequest().getHttpListener();
            httpListener.notifyCallEnd(internalResponse);
            super.onPostExecute((Object)internalResponse);
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((InternalResponse)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Request[])objectArray);
        }
    }
}

