/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.http_libs.request.multi;

import com.abupdate.http_libs.request.content.HttpBody;
import com.abupdate.http_libs.request.multi.AbstractPart;
import com.abupdate.http_libs.request.multi.BoundaryCreater;
import com.abupdate.http_libs.request.multi.BytesPart;
import com.abupdate.http_libs.request.multi.FilePart;
import com.abupdate.http_libs.request.multi.StringPart;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;

public class MultipartBody
extends HttpBody {
    private LinkedList<AbstractPart> httpParts = new LinkedList();
    private long totalSize;
    private long bytesWritten;
    BoundaryCreater boundaryCreater = new BoundaryCreater();

    public MultipartBody() {
        this.contentType = "multipart/form-data; boundary=" + this.boundaryCreater.getBoundary();
    }

    public LinkedList<AbstractPart> getHttpParts() {
        return this.httpParts;
    }

    public MultipartBody setHttpParts(LinkedList<AbstractPart> linkedList) {
        this.httpParts = linkedList;
        return this;
    }

    public MultipartBody addPart(String string, String string2, String string3, String string4) {
        return this.addPart(new StringPart(string, string2, string3, string4));
    }

    public MultipartBody addPart(String string, byte[] byArray, String string2) {
        return this.addPart(new BytesPart(string, byArray, string2));
    }

    public MultipartBody addPart(String string, File file, String string2) {
        return this.addPart(new FilePart(string, file, string2));
    }

    public MultipartBody addPart(AbstractPart abstractPart) {
        if (abstractPart == null) {
            return this;
        }
        MultipartBody multipartBody = this;
        abstractPart.setMultipartBody(this);
        abstractPart.createHeader(this.boundaryCreater.getBoundaryLine());
        multipartBody.httpParts.add(abstractPart);
        return multipartBody;
    }

    @Override
    public long getContentLength() {
        long l = -1L;
        Iterator iterator = this.httpParts.iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            long l2 = ((AbstractPart)iterator.next()).getTotalLength();
            if (l2 < 0L) {
                return -1L;
            }
            l += l2;
            continue;
            break;
        }
        try {
            l += (long)this.boundaryCreater.getBoundaryEnd().length;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return l;
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        MultipartBody multipartBody = this;
        multipartBody.bytesWritten = 0L;
        multipartBody.totalSize = (int)multipartBody.getContentLength();
        Iterator iterator = multipartBody.httpParts.iterator();
        while (iterator.hasNext()) {
            ((AbstractPart)iterator.next()).writeToServer(outputStream);
        }
        MultipartBody multipartBody2 = this;
        outputStream.write(this.boundaryCreater.getBoundaryEnd());
        multipartBody2.updateProgress(multipartBody2.boundaryCreater.getBoundaryEnd().length);
    }

    protected void updateProgress(long l) {
        this.bytesWritten += l;
    }

    public BoundaryCreater getBoundary() {
        return this.boundaryCreater;
    }
}

