/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.http_libs.data;

import android.content.Context;
import com.abupdate.http_libs.HttpIotUtils;
import com.abupdate.http_libs.engine.HttpManager;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;

public class HttpConfig {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_TIMEOUT = 20000;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final int DEFAULT_RETRYTIMES = 3;
    private static final int DEFAULT_REDIRECTTIMES = 3;
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded; charset=UTF-8";
    private Context context;
    private int socketTimeout = 20000;
    private int connectTimeout = 20000;
    private int retryTimes = 3;
    private int redirectTimes = 3;
    private HostnameVerifier defaultVerifier;

    public HttpConfig(Context context) {
        HostnameVerifier hostnameVerifier;
        HostnameVerifier hostnameVerifier2 = hostnameVerifier;
        hostnameVerifier = new HostnameVerifier(this){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        this.defaultVerifier = hostnameVerifier2;
        if (context != null) {
            this.context = context.getApplicationContext();
        }
    }

    private void initSSL(String string, String string2, HostnameVerifier hostnameVerifier) {
        HttpConfig httpConfig = object;
        Object object = null;
        try {
            object = httpConfig.getSSLContext(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (GeneralSecurityException generalSecurityException) {
            generalSecurityException.printStackTrace();
        }
        if (object != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(((SSLContext)object).getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
    }

    private SSLContext getSSLContext(String object, String string) {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyManager[] keyManagerArray = keyManagerArray.getKeyStore((String)object, string);
        keyManagerFactory.init((KeyStore)keyManagerArray, ((String)object).toCharArray());
        object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        ((TrustManagerFactory)object).init((KeyStore)keyManagerArray);
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        keyManagerArray = keyManagerFactory.getKeyManagers();
        sSLContext.init(keyManagerArray, ((TrustManagerFactory)object).getTrustManagers(), null);
        return sSLContext;
    }

    private KeyStore getKeyStore(String string, String string2) {
        KeyStore keyStore = KeyStore.getInstance("BKS");
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        keyStore.load(inputStream, string.toCharArray());
        inputStream.close();
        return keyStore;
    }

    public HttpConfig setSSL(String string, String string2) {
        HttpConfig httpConfig = hostnameVerifier;
        HostnameVerifier hostnameVerifier = httpConfig.defaultVerifier;
        httpConfig.initSSL(string, string2, hostnameVerifier);
        return httpConfig;
    }

    public HttpConfig setSSL(String string, String string2, HostnameVerifier hostnameVerifier) {
        HttpConfig httpConfig = this;
        httpConfig.initSSL(string, string2, hostnameVerifier);
        return httpConfig;
    }

    public HttpConfig setRetryTimes(int n) {
        this.retryTimes = n;
        return this;
    }

    public HttpConfig setRedirectTimes(int n) {
        this.redirectTimes = n;
        return this;
    }

    public HttpConfig setSocketTimeout(int n) {
        this.socketTimeout = n;
        return this;
    }

    public HttpConfig setConnectTimeout(int n) {
        this.connectTimeout = n;
        return this;
    }

    public void create() {
        HttpIotUtils.init(new HttpManager(this));
    }

    public int getRedirectTimes() {
        return this.redirectTimes;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public String toString() {
        return "HttpConfig{context=" + this.context + ", connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + '}';
    }
}

