/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.http_libs.request.multi;

import com.abupdate.http_libs.request.multi.AbstractPart;
import java.io.OutputStream;

public class BytesPart
extends AbstractPart {
    public byte[] bytes;
    public static final String TAG = BytesPart.class.getSimpleName();

    public BytesPart(String string, byte[] byArray) {
        this(string, byArray, null);
        this.bytes = byArray;
    }

    public BytesPart(String string, byte[] byArray, String string2) {
        super(string, string2);
        this.bytes = byArray;
    }

    @Override
    protected byte[] createContentType() {
        return ("Content-Type: " + this.mimeType + "\r\n").getBytes(infoCharset);
    }

    @Override
    protected byte[] createContentDisposition() {
        return ("Content-Disposition: form-data; name=\"" + this.key + "\"\r\n").getBytes(infoCharset);
    }

    @Override
    public long getTotalLength() {
        return this.header.length + this.bytes.length + CR_LF.length;
    }

    @Override
    public byte[] getTransferEncoding() {
        return TRANSFER_ENCODING_BINARY;
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        outputStream.write(this.bytes);
        outputStream.write(CR_LF);
        this.updateProgress(this.bytes.length + CR_LF.length);
    }
}

