/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.http_libs.data;

import android.content.Context;
import com.abupdate.http_libs.HttpIotUtils;
import com.abupdate.http_libs.engine.HttpManager;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;

public class HttpConfig {
    private Context context;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_TIMEOUT = 20000;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final int DEFAULT_RETRYTIMES = 3;
    private static final int DEFAULT_REDIRECTTIMES = 3;
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded; charset=UTF-8";
    private int socketTimeout = 20000;
    private int connectTimeout = 20000;
    private int retryTimes = 3;
    private int redirectTimes = 3;
    private HostnameVerifier defaultVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    };

    public HttpConfig(Context context) {
        if (context != null) {
            this.context = context.getApplicationContext();
        }
    }

    public HttpConfig setSSL(String string, String string2) {
        this.initSSL(string, string2, this.defaultVerifier);
        return this;
    }

    public HttpConfig setSSL(String string, String string2, HostnameVerifier hostnameVerifier) {
        this.initSSL(string, string2, hostnameVerifier);
        return this;
    }

    public HttpConfig setRetryTimes(int n) {
        this.retryTimes = n;
        return this;
    }

    public HttpConfig setRedirectTimes(int n) {
        this.redirectTimes = n;
        return this;
    }

    public HttpConfig setSocketTimeout(int n) {
        this.socketTimeout = n;
        return this;
    }

    public HttpConfig setConnectTimeout(int n) {
        this.connectTimeout = n;
        return this;
    }

    public void create() {
        HttpIotUtils.init(new HttpManager(this));
    }

    public int getRedirectTimes() {
        return this.redirectTimes;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    private void initSSL(String string, String string2, HostnameVerifier hostnameVerifier) {
        SSLContext sSLContext = null;
        HostnameVerifier hostnameVerifier2 = hostnameVerifier;
        try {
            sSLContext = this.getSSLContext(string, string2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            generalSecurityException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (sSLContext != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier2);
    }

    private SSLContext getSSLContext(String string, String string2) {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = this.getKeyStore(string, string2);
        keyManagerFactory.init(keyStore, string.toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return sSLContext;
    }

    private KeyStore getKeyStore(String string, String string2) {
        KeyStore keyStore = KeyStore.getInstance("BKS");
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        keyStore.load(inputStream, string.toCharArray());
        inputStream.close();
        return keyStore;
    }

    public String toString() {
        return "HttpConfig{context=" + this.context + ", connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + '}';
    }
}

