/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.http_libs.data;

import android.content.Context;
import com.abupdate.http_libs.HttpIotUtils;
import com.abupdate.http_libs.data.a;
import com.abupdate.http_libs.engine.HttpManager;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class HttpConfig {
    private Context context;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_TIMEOUT = 20000;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final int DEFAULT_RETRYTIMES = 3;
    private static final int DEFAULT_REDIRECTTIMES = 3;
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded; charset=UTF-8";
    private int socketTimeout = 20000;
    private int connectTimeout = 20000;
    private int retryTimes = 3;
    private int redirectTimes = 3;
    private HostnameVerifier defaultVerifier = new a(this);

    public HttpConfig(Context context) {
        if (context != null) {
            this.context = context.getApplicationContext();
        }
    }

    public HttpConfig setSSL(String string, String string2) {
        this.initSSL(string, string2, this.defaultVerifier);
        return this;
    }

    public HttpConfig setSSL(String string, String string2, HostnameVerifier hostnameVerifier) {
        this.initSSL(string, string2, hostnameVerifier);
        return this;
    }

    public HttpConfig setRetryTimes(int n) {
        this.retryTimes = n;
        return this;
    }

    public HttpConfig setRedirectTimes(int n) {
        this.redirectTimes = n;
        return this;
    }

    public HttpConfig setSocketTimeout(int n) {
        this.socketTimeout = n;
        return this;
    }

    public HttpConfig setConnectTimeout(int n) {
        this.connectTimeout = n;
        return this;
    }

    public void create() {
        HttpIotUtils.init(new HttpManager(this));
    }

    public int getRedirectTimes() {
        return this.redirectTimes;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    private void initSSL(String object, String string, HostnameVerifier hostnameVerifier) {
        SSLContext sSLContext = null;
        try {
            sSLContext = this.getSSLContext((String)object, string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            object = generalSecurityException;
            generalSecurityException.printStackTrace();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        if (sSLContext != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
    }

    private SSLContext getSSLContext(String object, String object2) {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        object2 = this.getKeyStore((String)object, (String)object2);
        keyManagerFactory.init((KeyStore)object2, ((String)object).toCharArray());
        object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        ((TrustManagerFactory)object).init((KeyStore)object2);
        object2 = SSLContext.getInstance("TLS");
        ((SSLContext)object2).init(keyManagerFactory.getKeyManagers(), ((TrustManagerFactory)object).getTrustManagers(), null);
        return object2;
    }

    private KeyStore getKeyStore(String string, String object) {
        KeyStore keyStore = KeyStore.getInstance("BKS");
        object = this.getClass().getResourceAsStream((String)object);
        keyStore.load((InputStream)object, string.toCharArray());
        ((InputStream)object).close();
        return keyStore;
    }

    public String toString() {
        return "HttpConfig{context=" + this.context + ", connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + '}';
    }
}

