package com.abupdate.http_libs.request;

import com.abupdate.http_libs.data.HttpMethods;
import com.abupdate.http_libs.data.RequestConfig;
import com.abupdate.http_libs.inter.HttpListener;
import com.abupdate.http_libs.response.Response;

/**
 * 请求抽象类
 * Created by raise.yang on 17/09/05.
 */

public interface Request {

    Request setUrl(String url);

    String getUrl();

    HttpMethods getMethod();

    Request setMethod(HttpMethods method);

    Request setHeaderContentType(RequestConfig.ContentType type);

    RequestConfig.ContentType getContentType();

    String getCharset();

    Request setCharset(String charset);

    Request setContent(byte[] content);

    byte[] getContent();

    int getConnectTimeout();

    int getSocketTimeout();

    int getMaxRetryTimes();

    int getMaxRedirectTimes();

    Request setConnectTimeout(int connectTimeout);

    Request setSocketTimeout(int socketTimeout);

    Request setMaxRetryTimes(int maxRetryTimes);

    Request setMaxRedirectTimes(int maxRedirectTimes);

    HttpListener getHttpListener();

    Request build();

    Response exec();

    void exec(HttpListener httpListener);
}
