/*
 * Decompiled with CFR 0.152.
 */
package com.adups.http_libs.request;

import com.adups.http_libs.data.HttpMethods;
import com.adups.http_libs.data.RequestConfig;
import com.adups.http_libs.request.AbstractRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class PostFormRequest
extends AbstractRequest {
    public PostFormRequest(String url) {
        this.setUrl(url);
        this.setMethod(HttpMethods.Post);
        this.setHeaderContentType(RequestConfig.ContentType.TYPE_FORM);
    }

    public PostFormRequest map(Map<String, String> params) {
        return (PostFormRequest)this.setContent(this.getParamsData(params));
    }

    private byte[] getParamsData(Map<String, String> params) {
        byte[] data = null;
        try {
            if (null != params && !params.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    buffer.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), this.getCharset())).append("&");
                }
                buffer.deleteCharAt(buffer.length() - 1);
                data = buffer.toString().getBytes(this.getCharset());
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return data;
    }
}

