/*
 * Decompiled with CFR 0.152.
 */
package com.adups.http_libs.request;

import com.adups.http_libs.HttpIotUtils;
import com.adups.http_libs.data.HttpMethods;
import com.adups.http_libs.data.RequestConfig;
import com.adups.http_libs.inter.HttpListener;
import com.adups.http_libs.request.Request;
import com.adups.http_libs.response.Response;

public abstract class AbstractRequest
implements Request {
    private static final String TAG = Request.class.getSimpleName();
    private String url;
    private HttpMethods method;
    private String charset = "UTF-8";
    private int connectTimeout = -1;
    private int socketTimeout = -1;
    private int maxRetryTimes = -1;
    private int maxRedirectTimes = -1;
    private HttpListener httpListener;
    private RequestConfig.ContentType type;
    private byte[] content;

    @Override
    public Request setUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public HttpMethods getMethod() {
        return this.method;
    }

    @Override
    public Request setMethod(HttpMethods method) {
        this.method = method;
        return this;
    }

    @Override
    public Request setHeaderContentType(RequestConfig.ContentType type) {
        this.type = type;
        return this;
    }

    @Override
    public RequestConfig.ContentType getContentType() {
        return this.type;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public Request setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public Request setContent(byte[] content) {
        this.content = content;
        return this;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public Request setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public Request setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @Override
    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    @Override
    public Request setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
        return this;
    }

    @Override
    public int getMaxRedirectTimes() {
        return this.maxRedirectTimes;
    }

    @Override
    public Request setMaxRedirectTimes(int maxRedirectTimes) {
        this.maxRedirectTimes = maxRedirectTimes;
        return this;
    }

    @Override
    public HttpListener getHttpListener() {
        return this.httpListener;
    }

    @Override
    public Request build() {
        return this;
    }

    @Override
    public Response exec() {
        return HttpIotUtils.getInstance().exec(this);
    }

    @Override
    public void exec(HttpListener httpListener) {
        this.httpListener = httpListener;
        HttpIotUtils.getInstance().exec(this);
    }
}

