/*
 * Decompiled with CFR 0.152.
 */
package com.adups.http_libs.engine;

import android.content.Context;
import android.os.AsyncTask;
import com.adups.http_libs.data.HttpConfig;
import com.adups.http_libs.data.HttpMethods;
import com.adups.http_libs.data.HttpStatus;
import com.adups.http_libs.data.NameValuePair;
import com.adups.http_libs.exception.HttpException;
import com.adups.http_libs.inter.HttpListener;
import com.adups.http_libs.request.Request;
import com.adups.http_libs.response.InternalResponse;
import com.adups.trace.Trace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class HttpManager {
    private static final String TAG = HttpManager.class.getSimpleName();
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private HttpConfig config;

    public static HttpConfig build(Context context) {
        return new HttpConfig(context);
    }

    public HttpManager(HttpConfig config) {
        this.initConfig(config);
    }

    private void initConfig(HttpConfig config) {
        this.config = config;
        Trace.d((String)TAG, (String)("initConfig() " + config.toString()));
    }

    public final HttpConfig getConfig() {
        return this.config;
    }

    public void enqueue(Request request) {
        ExecuteAsyncTask executeAsyncTask = new ExecuteAsyncTask();
        executeAsyncTask.execute(new Request[]{request});
    }

    public InternalResponse execute(Request request) {
        InternalResponse response = this.handleRequest(request);
        if (request.getHttpListener() != null) {
            request.getHttpListener().disableListener(true);
        }
        this.connectWithRetry(request, response);
        return response;
    }

    private boolean connectWithRetry(Request abstractRequest, InternalResponse response) {
        response.setRedirectTimes(0);
        response.setRetryTimes(0);
        for (int i = 1; i <= abstractRequest.getMaxRetryTimes() + 1; ++i) {
            if (i > 1) {
                response.setRetryTimes(response.getRetryTimes() + 1);
                if (abstractRequest.getHttpListener() != null) {
                    abstractRequest.getHttpListener().notifyCallRetry(abstractRequest, abstractRequest.getMaxRetryTimes(), response.getRetryTimes());
                }
            }
            boolean connect = false;
            try {
                connect = this.connect(abstractRequest, response);
            }
            catch (HttpException e) {
                e.printStackTrace();
                response.setException(e);
            }
            catch (IOException e) {
                e.printStackTrace();
                HttpException httpException = new HttpException(e);
                response.setException(httpException);
            }
            if (!connect) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connect(Request abstractRequest, InternalResponse response) throws HttpException, IOException {
        String u = abstractRequest.getUrl();
        URL url = null;
        try (InputStream inputStream = null;){
            int statusCode;
            url = new URL(u);
            HttpURLConnection connection = u.startsWith("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(abstractRequest.getConnectTimeout());
            connection.setReadTimeout(abstractRequest.getSocketTimeout());
            connection.setRequestMethod(abstractRequest.getMethod().getMethodName());
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty(HEADER_CONTENT_TYPE, abstractRequest.getContentType().getType());
            byte[] request_data = abstractRequest.getContent();
            if (null != request_data) {
                connection.setFixedLengthStreamingMode(request_data.length);
                connection.setRequestProperty(HEADER_CONTENT_LENGTH, String.valueOf(request_data.length));
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(request_data);
            }
            if ((statusCode = connection.getResponseCode()) != 200) {
                Trace.d((String)TAG, (String)("connect() responseCode\uff1a" + statusCode));
            }
            HttpStatus httpStatus = new HttpStatus(statusCode, connection.getResponseMessage());
            response.setHttpStatus(httpStatus);
            inputStream = connection.getInputStream();
            if (inputStream == null) {
                throw new HttpException(1);
            }
            ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
            for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
                List<String> values;
                if (header.getKey() == null || (values = header.getValue()) == null) continue;
                for (String value : values) {
                    headers.add(new NameValuePair(header.getKey(), value));
                }
            }
            response.setHeaders(headers);
            response.setContentLength(connection.getContentLength());
            response.setContentEncoding(connection.getContentEncoding());
            response.setContentType(connection.getContentType());
            if (statusCode <= 299 || statusCode == 600) {
                String charSet = this.getCharsetByContentType(response.getContentType(), abstractRequest.getCharset());
                response.setCharset(charSet);
                String result = HttpManager.getResultString(inputStream, abstractRequest.getCharset());
                response.setContent(result);
                if (abstractRequest.getHttpListener() != null) {
                    abstractRequest.getHttpListener().notifyCallSuccess(result, response);
                }
                boolean bl = true;
                return bl;
            }
            if (statusCode <= 399) {
                if (response.getRedirectTimes() < abstractRequest.getMaxRedirectTimes()) {
                    response.setRedirectTimes(response.getRedirectTimes() + 1);
                    if (abstractRequest.getHttpListener() != null) {
                        abstractRequest.getHttpListener().notifyCallRedirect(abstractRequest, abstractRequest.getMaxRedirectTimes(), response.getRedirectTimes());
                    }
                    URL redirect_url = connection.getURL();
                    Trace.d((String)TAG, (String)("connect() \u91cd\u5b9a\u5411:" + redirect_url.toString()));
                    abstractRequest.setUrl(redirect_url.toString());
                    this.connect(abstractRequest, response);
                }
            } else {
                if (statusCode <= 499) {
                    throw new HttpException(httpStatus.getCode(), new Throwable(httpStatus.getDescriptionInChinese()));
                }
                if (statusCode < 599) {
                    throw new HttpException(httpStatus.getCode(), new Throwable(httpStatus.getDescriptionInChinese()));
                }
            }
        }
        return false;
    }

    protected InternalResponse handleRequest(Request request) {
        if (request.getConnectTimeout() <= 0) {
            request.setConnectTimeout(this.config.getConnectTimeout());
        }
        if (request.getSocketTimeout() <= 0) {
            request.setSocketTimeout(this.config.getSocketTimeout());
        }
        if (request.getMethod() == null) {
            request.setMethod(HttpMethods.Get);
        }
        if (request.getCharset() == null) {
            request.setCharset("UTF-8");
        }
        if (request.getMaxRetryTimes() <= 0) {
            request.setMaxRetryTimes(this.config.getRetryTimes());
        }
        if (request.getMaxRedirectTimes() <= 0) {
            request.setMaxRedirectTimes(this.config.getRedirectTimes());
        }
        if (request.getContentType() == null) {
            request.setHeaderContentType(HttpConfig.CONTENT_TYPE);
        }
        return new InternalResponse(request);
    }

    private String getCharsetByContentType(String contentType, String defCharset) {
        if (contentType != null) {
            String[] values;
            for (String value : values = contentType.split(";")) {
                if (!(value = value.trim()).toLowerCase().startsWith("charset=")) continue;
                return value.substring("charset=".length());
            }
        }
        return defCharset == null ? "UTF-8" : defCharset;
    }

    private static String getResultString(InputStream inputStream, String encode) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        int len = 0;
        String result = "";
        if (inputStream != null) {
            try {
                while ((len = inputStream.read(data)) != -1) {
                    outputStream.write(data, 0, len);
                }
                result = new String(outputStream.toByteArray(), encode);
            }
            catch (IOException e) {
                Trace.d((String)TAG, (String)("getResultString() exception:" + e.toString()));
                e.printStackTrace();
            }
        }
        return result;
    }

    private class ExecuteAsyncTask
    extends AsyncTask<Request, Integer, InternalResponse> {
        private ExecuteAsyncTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected InternalResponse doInBackground(Request[] abstractRequests) {
            boolean b;
            Request abstractRequest = abstractRequests[0];
            InternalResponse response = HttpManager.this.handleRequest(abstractRequest);
            HttpListener httpListener = abstractRequest.getHttpListener();
            if (httpListener != null) {
                httpListener.notifyCallStart(abstractRequest);
            }
            if (!(b = HttpManager.this.connectWithRetry(abstractRequest, response)) && httpListener != null) {
                httpListener.notifyCallFailure(response.getException(), response);
            }
            return response;
        }

        protected void onPostExecute(InternalResponse internalResponse) {
            HttpListener listener = internalResponse.getRequest().getHttpListener();
            listener.notifyCallEnd(internalResponse);
            super.onPostExecute((Object)internalResponse);
        }
    }
}

