package com.adups.http_libs.request;

import com.adups.http_libs.HttpIotUtils;
import com.adups.http_libs.data.HttpConfig;
import com.adups.http_libs.data.HttpMethods;
import com.adups.http_libs.data.RequestConfig;
import com.adups.http_libs.inter.HttpListener;
import com.adups.http_libs.response.Response;

/**
 * Created by fighter_lee on 2017/7/18.
 */

public abstract class AbstractRequest implements Request {

    private static final String TAG = Request.class.getSimpleName();
    private String url;
    private HttpMethods method;
    private String charset;//默认UTF—8
    private int connectTimeout = -1;
    private int socketTimeout = -1;
    private int maxRetryTimes = -1;//重试次数
    private int maxRedirectTimes = -1;//重定向重试次数
    private HttpListener httpListener;
    private RequestConfig.ContentType type;
    private byte[] content;

    public AbstractRequest() {
        charset = HttpConfig.DEFAULT_CHARSET;
    }

    public Request setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public HttpMethods getMethod() {
        return method;
    }

    public Request setMethod(HttpMethods method) {
        this.method = method;
        return this;
    }

    /**
     * 设置请求中的媒体类型信息
     *
     * @param type
     * @return
     */
    public Request setHeaderContentType(RequestConfig.ContentType type) {
        this.type = type;
        return this;
    }

    public RequestConfig.ContentType getContentType() {
        return type;
    }

    public String getCharset() {
        return charset;
    }

    /**
     * 设置请求编码
     *
     * @param charset
     * @return
     */
    public Request setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public Request setContent(byte[] content) {
        this.content = content;
        return this;
    }

    public byte[] getContent() {
        return content;
    }

    public int getConnectTimeout() {
        return connectTimeout;
    }

    /**
     * 连接超时时间
     *
     * @param connectTimeout
     * @return
     */
    public Request setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getSocketTimeout() {
        return socketTimeout;
    }

    /**
     * 读取超时时间
     *
     * @param socketTimeout
     * @return
     */
    public Request setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public int getMaxRetryTimes() {
        return maxRetryTimes;
    }

    /**
     * 设置重试次数(第一次请求不算入重试次数中)
     *
     * @param maxRetryTimes
     * @return
     */
    public Request setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
        return this;
    }

    public int getMaxRedirectTimes() {
        return maxRedirectTimes;
    }

    /**
     * 设置重定向次数(第一次请求不算入重试次数中)
     *
     * @param maxRedirectTimes
     * @return
     */
    public Request setMaxRedirectTimes(int maxRedirectTimes) {
        this.maxRedirectTimes = maxRedirectTimes;
        return this;
    }

    public HttpListener getHttpListener() {
        return httpListener;
    }


    @Override
    public Request build() {
        return this;
    }

    @Override
    public Response exec() {
        return HttpIotUtils.getInstance().exec(this);
    }

    @Override
    public void exec(HttpListener httpListener) {
        this.httpListener = httpListener;
        HttpIotUtils.getInstance().exec(this);
    }
}