/*
 * Decompiled with CFR 0.152.
 */
package com.adups.http_libs.response;

import com.adups.http_libs.data.Data;
import com.adups.http_libs.data.HttpStatus;
import com.adups.http_libs.data.NameValuePair;
import com.adups.http_libs.exception.HttpException;
import com.adups.http_libs.request.AbstractRequest;
import com.adups.http_libs.response.Response;
import java.util.ArrayList;

public class InternalResponse<T>
implements Response<T> {
    private static final String TAG = InternalResponse.class.getSimpleName();
    protected String charSet;
    protected HttpStatus httpStatus;
    protected int retryTimes;
    protected int redirectTimes;
    protected long contentLength;
    protected String contentEncoding;
    protected String contentType;
    protected ArrayList<NameValuePair> headers;
    protected AbstractRequest<T> request;
    protected HttpException exception;
    private Data data;

    public InternalResponse(AbstractRequest<T> request) {
        this.request = request;
    }

    @Override
    public Data getResult() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    @Override
    public <R extends AbstractRequest<T>> R getRequest() {
        return (R)this.request;
    }

    public <R extends AbstractRequest<T>> void setRequest(R request) {
        this.request = request;
    }

    @Override
    public HttpException getException() {
        return this.exception;
    }

    public void setException(HttpException e) {
        this.exception = e;
    }

    @Override
    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        if (charSet != null) {
            this.charSet = charSet;
        }
    }

    @Override
    public ArrayList<NameValuePair> getHeaders() {
        return this.headers;
    }

    public void setHeaders(ArrayList<NameValuePair> headers) {
        this.headers = headers;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    public long setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this.contentLength;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public InternalResponse setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public InternalResponse setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(HttpStatus httpStatus) {
        this.httpStatus = httpStatus;
    }

    @Override
    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    @Override
    public int getRedirectTimes() {
        return this.redirectTimes;
    }

    public void setRedirectTimes(int redirectTimes) {
        this.redirectTimes = redirectTimes;
    }

    @Override
    public boolean isConnectSuccess() {
        return this.httpStatus != null && this.httpStatus.isSuccess();
    }

    public boolean isResultOk() {
        return this.getResult() != null;
    }

    public String toString() {
        return this.resToString();
    }

    @Override
    public String resToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("^_^\n").append("____________________________ IOT http response info start ____________________________").append("\n url            : ").append(this.request.getUrl()).append("\n status         : ").append(this.httpStatus).append("\n charSet        : ").append(this.charSet).append("\n retryTimes     : ").append(this.retryTimes).append("\n redirectTimes  : ").append(this.redirectTimes).append("\n contentLength  : ").append(this.contentLength).append("\n contentEncoding: ").append(this.contentEncoding).append("\n contentType    : ").append(this.contentType).append("\n header         ");
        if (this.headers == null) {
            sb.append(": null");
        } else {
            for (NameValuePair nv : this.headers) {
                sb.append("\n|    ").append(nv);
            }
        }
        sb.append("\n ").append(this.request).append("\n exception      : ").append(this.exception).append("\n.").append("\n _________________ data-start _________________").append("\n ").append(this.getResult()).append("\n _________________ data-over _________________").append("\n____________________________ IOT http response info end ____________________________");
        return sb.toString();
    }
}

