/*
 * Decompiled with CFR 0.152.
 */
package com.adups.http_libs.request;

import com.adups.http_libs.data.Data;
import com.adups.http_libs.data.HttpMethods;
import com.adups.http_libs.data.RequestConfig;
import com.adups.http_libs.inter.HttpListener;

public abstract class AbstractRequest<T> {
    private static final String TAG = AbstractRequest.class.getSimpleName();
    private String url;
    private HttpMethods method;
    private String charSet;
    private int connectTimeout = -1;
    private int socketTimeout = -1;
    private int maxRetryTimes = -1;
    private int maxRedirectTimes = -1;
    private HttpListener httpListener;
    private RequestConfig.ContentType type;
    private Data data;
    private byte[] content;

    public AbstractRequest(String url) {
        this.url = url;
    }

    public <S extends AbstractRequest<T>> S setUri(String url) {
        this.url = url;
        return (S)this;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpMethods getMethod() {
        return this.method;
    }

    public <S extends AbstractRequest<T>> S setMethod(HttpMethods method) {
        this.method = method;
        return (S)this;
    }

    public <S extends AbstractRequest<T>> S setHeaderContentType(RequestConfig.ContentType type) {
        this.type = type;
        return (S)this;
    }

    public RequestConfig.ContentType getContentType() {
        return this.type;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public <S extends AbstractRequest<T>> S setCharSet(String charSet) {
        this.charSet = charSet;
        return (S)this;
    }

    public <S extends AbstractRequest<T>> S setContent(byte[] content) {
        this.content = content;
        return (S)this;
    }

    public byte[] getContent() {
        return this.content;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public <S extends AbstractRequest<T>> S setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return (S)this;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public <S extends AbstractRequest<T>> S setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return (S)this;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public <S extends AbstractRequest<T>> S setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
        return (S)this;
    }

    public int getMaxRedirectTimes() {
        return this.maxRedirectTimes;
    }

    public <S extends AbstractRequest<T>> S setMaxRedirectTimes(int maxRedirectTimes) {
        this.maxRedirectTimes = maxRedirectTimes;
        return (S)this;
    }

    public HttpListener getHttpListener() {
        return this.httpListener;
    }

    public <S extends AbstractRequest<T>> S setHttpListener(HttpListener httpListener) {
        this.httpListener = httpListener;
        return (S)this;
    }

    public <S extends AbstractRequest<T>> S setData(Data data) {
        this.data = data;
        return (S)this;
    }

    public Data getData() {
        return this.data;
    }
}

