package com.adups.http_libs.response;

import com.adups.http_libs.data.Data;
import com.adups.http_libs.exception.HttpException;
import com.adups.http_libs.data.HttpStatus;
import com.adups.http_libs.data.NameValuePair;
import com.adups.http_libs.request.AbstractRequest;

import java.util.ArrayList;


public interface Response<T> {


    ArrayList<NameValuePair> getHeaders();

    HttpStatus getHttpStatus();

    Data getResult();

    <R extends AbstractRequest<T>> R getRequest();

    long getContentLength();

    String getContentEncoding();

    String getContentType();

    String getCharSet();

    boolean isConnectSuccess();

    int getRetryTimes();

    int getRedirectTimes();

    HttpException getException();

    String resToString();

}
