package com.adups.http_libs.response;


import com.adups.http_libs.data.Data;
import com.adups.http_libs.exception.HttpException;
import com.adups.http_libs.data.HttpStatus;
import com.adups.http_libs.data.NameValuePair;
import com.adups.http_libs.request.AbstractRequest;

import java.util.ArrayList;

public class InternalResponse<T> implements Response<T> {
    private static final String TAG = InternalResponse.class.getSimpleName();
    protected String charSet;
    protected HttpStatus httpStatus;
    protected int retryTimes;
    protected int redirectTimes;
    protected long contentLength;
    protected String contentEncoding;
    protected String contentType;
    protected ArrayList<NameValuePair> headers;
    protected AbstractRequest<T> request;
    protected HttpException exception;
    private Data data;

    public InternalResponse(AbstractRequest<T> request) {
        this.request = request;
    }

    public Data getResult() {
        return data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    @Override
    @SuppressWarnings("unchecked")
    public <R extends AbstractRequest<T>> R getRequest() {
        return (R) request;
    }

    public <R extends AbstractRequest<T>> void setRequest(R request) {
        this.request = request;
    }

    @Override
    public HttpException getException() {
        return exception;
    }

    public void setException(HttpException e) {
        this.exception = e;
    }

    @Override
    public String getCharSet() {
        return charSet;
    }

    public void setCharSet(String charSet) {
        if (charSet != null) {
            this.charSet = charSet;
        }
    }

    @Override
    public ArrayList<NameValuePair> getHeaders() {
        return headers;
    }

    public void setHeaders(ArrayList<NameValuePair> headers) {
        this.headers = headers;
    }

    @Override
    public long getContentLength() {
        return contentLength;
    }

    public long setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this.contentLength;
    }

    @Override
    public String getContentEncoding() {
        return contentEncoding;
    }

    public InternalResponse setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    @Override
    public String getContentType() {
        return contentType;
    }

    public InternalResponse setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public HttpStatus getHttpStatus() {
        return httpStatus;
    }

    public void setHttpStatus(HttpStatus httpStatus) {
        this.httpStatus = httpStatus;
    }

    @Override
    public int getRetryTimes() {
        return retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    @Override
    public int getRedirectTimes() {
        return redirectTimes;
    }

    public void setRedirectTimes(int redirectTimes) {
        this.redirectTimes = redirectTimes;
    }

    @Override
    public boolean isConnectSuccess() {
        return httpStatus != null && httpStatus.isSuccess();
    }

    public boolean isResultOk() {
        return getResult() != null;
    }

    @Override
    public String toString() {
        return resToString();
    }

    @Override
    public String resToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("^_^\n")
          .append("____________________________ IOT http response info start ____________________________")
          .append("\n url            : ").append(request.getUrl())
          .append("\n status         : ").append(httpStatus)
          .append("\n charSet        : ").append(charSet)
          .append("\n retryTimes     : ").append(retryTimes)
          .append("\n redirectTimes  : ").append(redirectTimes)
          .append("\n contentLength  : ").append(contentLength)
          .append("\n contentEncoding: ").append(contentEncoding)
          .append("\n contentType    : ").append(contentType)
          .append("\n header         ");
        if (headers == null) {
            sb.append(": null");
        } else {
            for (NameValuePair nv : headers) {
                sb.append("\n|    ").append(nv);
            }
        }
        sb.append("\n ").append(request)
          .append("\n exception      : ").append(exception)
          .append("\n.")
          .append("\n _________________ data-start _________________")
          .append("\n ").append(getResult())
          .append("\n _________________ data-over _________________")
          .append("\n____________________________ IOT http response info end ____________________________");
        return sb.toString();
    }
}
