/*
 * Decompiled with CFR 0.152.
 */
package com.adups.http_libs;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.adups.http_libs.AbstractRequest;
import com.adups.http_libs.Data;
import com.adups.http_libs.HttpException;
import com.adups.http_libs.Response;

public abstract class HttpListener {
    private static final String TAG = HttpListener.class.getSimpleName();
    private static final int M_START = 1;
    private static final int M_SUCCESS = 2;
    private static final int M_FAILURE = 3;
    private static final int M_RETRY = 4;
    private static final int M_REDIRECT = 5;
    private static final int M_END = 6;
    private HttpHandler handler;
    private boolean runOnUiThread = true;
    private HttpListener linkedListener;
    private long delayMillis;
    private boolean disableListener = false;

    public HttpListener() {
        this(true);
    }

    public HttpListener(long delayMillis) {
        this.delayMillis = delayMillis;
    }

    public HttpListener(boolean runOnUiThread) {
        this.setRunOnUiThread(runOnUiThread);
    }

    public final HttpListener getLinkedListener() {
        return this.linkedListener;
    }

    public final HttpListener setLinkedListener(HttpListener httpListener) {
        if (this.linkedListener != null) {
            HttpListener temp = this.linkedListener;
            do {
                if (httpListener != temp) continue;
                throw new RuntimeException("Circular refrence:  " + httpListener);
            } while ((temp = temp.getLinkedListener()) != null);
        }
        this.linkedListener = httpListener;
        return this;
    }

    public final boolean isRunOnUiThread() {
        return this.runOnUiThread;
    }

    public final HttpListener setRunOnUiThread(boolean runOnUiThread) {
        this.runOnUiThread = runOnUiThread;
        this.handler = runOnUiThread ? new HttpHandler(Looper.getMainLooper()) : null;
        return this;
    }

    public long getDelayMillis() {
        return this.delayMillis;
    }

    public HttpListener setDelayMillis(long delayMillis) {
        this.delayMillis = delayMillis;
        return this;
    }

    public final void notifyCallStart(AbstractRequest req) {
        if (this.disableListener) {
            return;
        }
        if (this.runOnUiThread) {
            Message msg = this.handler.obtainMessage(1);
            msg.obj = req;
            this.handler.sendMessage(msg);
        } else {
            this.onStart(req);
        }
        if (this.linkedListener != null) {
            this.linkedListener.notifyCallStart(req);
        }
    }

    public final void notifyCallSuccess(Data data, Response response) {
        this.delayOrNot();
        if (this.disableListener) {
            return;
        }
        if (this.runOnUiThread) {
            Message msg = this.handler.obtainMessage(2);
            msg.obj = new Object[]{data, response};
            this.handler.sendMessage(msg);
        } else {
            this.onSuccess(data, response);
        }
        if (this.linkedListener != null) {
            this.linkedListener.notifyCallSuccess(data, response);
        }
    }

    public final void notifyCallFailure(HttpException e, Response response) {
        this.delayOrNot();
        if (this.disableListener) {
            return;
        }
        if (this.runOnUiThread) {
            Message msg = this.handler.obtainMessage(3);
            msg.obj = new Object[]{e, response};
            this.handler.sendMessage(msg);
        } else {
            this.onFailure(e, response);
        }
        if (this.linkedListener != null) {
            this.linkedListener.notifyCallFailure(e, response);
        }
    }

    public final void notifyCallRetry(AbstractRequest req, int max, int times) {
        if (this.disableListener) {
            return;
        }
        if (this.runOnUiThread) {
            Message msg = this.handler.obtainMessage(4);
            msg.obj = new Object[]{req, max, times};
            this.handler.sendMessage(msg);
        } else {
            this.onRetry(req, max, times);
        }
        if (this.linkedListener != null) {
            this.linkedListener.notifyCallRetry(req, max, times);
        }
    }

    public final void notifyCallRedirect(AbstractRequest req, int max, int times) {
        if (this.disableListener) {
            return;
        }
        if (this.runOnUiThread) {
            Message msg = this.handler.obtainMessage(5);
            msg.obj = new Object[]{req, max, times};
            this.handler.sendMessage(msg);
        } else {
            this.onRedirect(req, max, times);
        }
        if (this.linkedListener != null) {
            this.linkedListener.notifyCallRedirect(req, max, times);
        }
    }

    public final void notifyCallEnd(Response response) {
        if (this.disableListener) {
            return;
        }
        if (this.runOnUiThread) {
            Message msg = this.handler.obtainMessage(6);
            msg.obj = response;
            this.handler.sendMessage(msg);
        } else {
            this.onEnd(response);
        }
        if (this.linkedListener != null) {
            this.linkedListener.notifyCallEnd(response);
        }
    }

    private boolean delayOrNot() {
        if (this.delayMillis > 0L) {
            try {
                Thread.sleep(this.delayMillis);
                return true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void disableListener(boolean able) {
        this.disableListener = able;
    }

    public void onStart(AbstractRequest request) {
    }

    public void onSuccess(Data data, Response response) {
    }

    public void onFailure(HttpException e, Response response) {
    }

    public void onRetry(AbstractRequest request, int max, int times) {
    }

    public void onRedirect(AbstractRequest request, int max, int times) {
    }

    public void onEnd(Response response) {
    }

    private class HttpHandler
    extends Handler {
        private HttpHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (HttpListener.this.disableListener) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    HttpListener.this.onStart((AbstractRequest)msg.obj);
                    break;
                }
                case 2: {
                    Object[] data = (Object[])msg.obj;
                    HttpListener.this.onSuccess((Data)data[0], (Response)data[1]);
                    break;
                }
                case 3: {
                    Object[] data = (Object[])msg.obj;
                    HttpListener.this.onFailure((HttpException)data[0], (Response)data[1]);
                    break;
                }
                case 4: {
                    Object[] data = (Object[])msg.obj;
                    HttpListener.this.onRetry((AbstractRequest)data[0], (Integer)data[1], (Integer)data[2]);
                    break;
                }
                case 5: {
                    Object[] data = (Object[])msg.obj;
                    HttpListener.this.onRedirect((AbstractRequest)data[0], (Integer)data[1], (Integer)data[2]);
                    break;
                }
                case 6: {
                    HttpListener.this.onEnd((Response)msg.obj);
                }
            }
        }
    }
}

