/*
 * Decompiled with CFR 0.152.
 */
package com.adups.http_libs;

public class HttpException
extends Exception {
    public static final int HTTP_ERROR_UNREACHABLE = 1;
    private int reasonCode;
    private Throwable cause;

    public HttpException(int reasonCode) {
        this.reasonCode = reasonCode;
    }

    public HttpException(int reason, Throwable cause) {
        this.reasonCode = reason;
        this.cause = cause;
    }

    public HttpException(Throwable cause) {
        this.cause = cause;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public String toString() {
        String result = this.getMessage() + " (" + this.reasonCode + ")";
        if (this.cause != null) {
            result = result + " - " + this.cause.toString();
        }
        return result;
    }

    public static String getErrorMessage(int error) {
        switch (error) {
            case 1: {
                return "\u7f51\u7edc\u65e0\u6cd5\u8bbf\u95ee";
            }
        }
        return "Unknown error";
    }
}

