/*
 * Decompiled with CFR 0.152.
 */
package com.adups.http_libs;

import android.content.Context;
import com.adups.http_libs.HttpManager;
import com.adups.http_libs.RequestConfig;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;

public class HttpConfig {
    private Context context;
    public static final int DEFAULT_TIMEOUT = 20000;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final int DEFAULT_RETRYTIMES = 3;
    private static final int DEFAULT_REDIRECTTIMES = 3;
    public static final RequestConfig.ContentType CONTENT_TYPE = RequestConfig.ContentType.TYPE_FORM;
    private int socketTimeout = 20000;
    private int connectTimeout = 20000;
    private int retryTimes = 3;
    private int redirectTimes = 3;
    private HostnameVerifier defaultVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public HttpConfig(Context context) {
        if (context != null) {
            this.context = context.getApplicationContext();
        }
    }

    public HttpConfig setSSL(String password, String keyStorePath) {
        this.initSSL(password, keyStorePath, this.defaultVerifier);
        return this;
    }

    public HttpConfig setSSL(String password, String keyStorePath, HostnameVerifier verifier) {
        this.initSSL(password, keyStorePath, verifier);
        return this;
    }

    public HttpConfig setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
        return this;
    }

    public HttpConfig setRedirectTimes(int redirectTimes) {
        this.redirectTimes = redirectTimes;
        return this;
    }

    public HttpConfig setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public HttpConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public HttpManager create() {
        return new HttpManager(this);
    }

    public int getRedirectTimes() {
        return this.redirectTimes;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    private void initSSL(String password, String keyStorePath, HostnameVerifier verifier) {
        SSLContext sslContext = null;
        HostnameVerifier hnv = verifier;
        try {
            sslContext = this.getSSLContext(password, keyStorePath);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (sslContext != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(hnv);
    }

    private SSLContext getSSLContext(String password, String keyStorePath) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = this.getKeyStore(password, keyStorePath);
        keyManagerFactory.init(keyStore, password.toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return ctx;
    }

    private KeyStore getKeyStore(String password, String keyPath) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore ks = KeyStore.getInstance("BKS");
        InputStream keyin = this.getClass().getResourceAsStream(keyPath);
        ks.load(keyin, password.toCharArray());
        keyin.close();
        return ks;
    }

    public String toString() {
        return "HttpConfig{context=" + this.context + ", connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + '}';
    }
}

