/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.http_libs.request.multi;

import com.abupdate.http_libs.request.multi.BoundaryCreater;
import com.abupdate.http_libs.request.multi.MultipartBody;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public abstract class AbstractPart {
    protected static final Charset infoCharset = BoundaryCreater.charset;
    public static final byte[] CR_LF = "\r\n".getBytes(infoCharset);
    public static final byte[] TRANSFER_ENCODING_BINARY = "Content-Transfer-Encoding: binary\r\n".getBytes(infoCharset);
    public static final byte[] TRANSFER_ENCODING_8BIT = "Content-Transfer-Encoding: 8bit\r\n".getBytes(infoCharset);
    protected String key;
    public byte[] header;
    protected String mimeType = "application/octet-stream";
    protected MultipartBody multipartBody;

    protected AbstractPart(String string, String string2) {
        this.key = string;
        if (string2 != null) {
            this.mimeType = string2;
        }
    }

    public byte[] createHeader(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(this.createContentDisposition());
            byteArrayOutputStream.write(this.createContentType());
            byteArrayOutputStream.write(this.getTransferEncoding());
            byteArrayOutputStream.write(CR_LF);
            this.header = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.header;
    }

    protected abstract byte[] createContentType();

    protected abstract byte[] createContentDisposition();

    public abstract long getTotalLength();

    public abstract byte[] getTransferEncoding();

    public abstract void writeTo(OutputStream var1);

    public void writeToServer(OutputStream outputStream) {
        if (this.header == null) {
            throw new RuntimeException("Not call createHeader()\uff0c\u672a\u8c03\u7528createHeader\u65b9\u6cd5");
        }
        outputStream.write(this.header);
        this.updateProgress(this.header.length);
        this.writeTo(outputStream);
    }

    public MultipartBody getMultipartBody() {
        return this.multipartBody;
    }

    public void setMultipartBody(MultipartBody multipartBody) {
        this.multipartBody = multipartBody;
    }

    protected void updateProgress(int n) {
        if (this.multipartBody != null) {
            this.multipartBody.updateProgress(n);
        }
    }
}

