/*
 * Decompiled with CFR 0.152.
 */
package com.abupdate.http_libs.request.multi;

import com.abupdate.http_libs.request.content.HttpBody;
import com.abupdate.http_libs.request.multi.AbstractPart;
import com.abupdate.http_libs.request.multi.BoundaryCreater;
import com.abupdate.http_libs.request.multi.BytesPart;
import com.abupdate.http_libs.request.multi.FilePart;
import com.abupdate.http_libs.request.multi.StringPart;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;

public class MultipartBody
extends HttpBody {
    private LinkedList<AbstractPart> httpParts = new LinkedList();
    private long totalSize;
    private long bytesWritten;
    BoundaryCreater boundaryCreater = new BoundaryCreater();

    public MultipartBody() {
        this.contentType = "multipart/form-data; boundary=" + this.boundaryCreater.getBoundary();
    }

    public LinkedList<AbstractPart> getHttpParts() {
        return this.httpParts;
    }

    public MultipartBody setHttpParts(LinkedList<AbstractPart> linkedList) {
        this.httpParts = linkedList;
        return this;
    }

    public MultipartBody addPart(String string, String string2, String string3, String string4) {
        return this.addPart(new StringPart(string, string2, string3, string4));
    }

    public MultipartBody addPart(String string, byte[] byArray, String string2) {
        return this.addPart(new BytesPart(string, byArray, string2));
    }

    public MultipartBody addPart(String string, File file, String string2) {
        return this.addPart(new FilePart(string, file, string2));
    }

    public MultipartBody addPart(AbstractPart abstractPart) {
        if (abstractPart == null) {
            return this;
        }
        abstractPart.setMultipartBody(this);
        abstractPart.createHeader(this.boundaryCreater.getBoundaryLine());
        this.httpParts.add(abstractPart);
        return this;
    }

    @Override
    public long getContentLength() {
        long l = -1L;
        try {
            for (AbstractPart abstractPart : this.httpParts) {
                long l2 = 0L;
                l2 = abstractPart.getTotalLength();
                if (l2 < 0L) {
                    return -1L;
                }
                l += l2;
            }
            l += (long)this.boundaryCreater.getBoundaryEnd().length;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return l;
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        this.bytesWritten = 0L;
        this.totalSize = (int)this.getContentLength();
        for (AbstractPart abstractPart : this.httpParts) {
            abstractPart.writeToServer(outputStream);
        }
        outputStream.write(this.boundaryCreater.getBoundaryEnd());
        this.updateProgress(this.boundaryCreater.getBoundaryEnd().length);
    }

    protected void updateProgress(long l) {
        this.bytesWritten += l;
    }

    public BoundaryCreater getBoundary() {
        return this.boundaryCreater;
    }
}

