/*
 * Decompiled with CFR 0.152.
 */
package com.adups.http_libs;

import com.adups.http_libs.AbstractRequest;
import com.adups.http_libs.Data;
import com.adups.http_libs.HttpException;
import com.adups.http_libs.HttpListener;
import com.adups.http_libs.HttpStatus;
import com.adups.http_libs.NameValuePair;
import com.adups.http_libs.Response;
import java.util.ArrayList;

public class InternalResponse<T>
implements Response<T> {
    private static final String TAG = InternalResponse.class.getSimpleName();
    protected String charSet;
    protected HttpStatus httpStatus;
    protected int retryTimes;
    protected int redirectTimes;
    protected long readedLength;
    protected long contentLength;
    protected String contentEncoding;
    protected String contentType;
    protected long useTime;
    protected ArrayList<NameValuePair> headers;
    protected AbstractRequest<T> request;
    protected HttpException exception;
    protected boolean isCacheHit;
    protected Object tag;
    private Data data;
    private HttpListener listener;

    public InternalResponse(AbstractRequest<T> request) {
        this.request = request;
    }

    @Override
    public Data getResult() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    @Override
    public <R extends AbstractRequest<T>> R getRequest() {
        return (R)this.request;
    }

    public <R extends AbstractRequest<T>> void setRequest(R request) {
        this.request = request;
    }

    @Override
    public Response<T> setTag(Object tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public Object getTag() {
        return this.tag;
    }

    public void setCacheHit(boolean isCacheHit) {
        this.isCacheHit = isCacheHit;
    }

    @Override
    public HttpException getException() {
        return this.exception;
    }

    public void setException(HttpException e) {
        this.exception = e;
    }

    @Override
    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        if (charSet != null) {
            this.charSet = charSet;
        }
    }

    @Override
    public ArrayList<NameValuePair> getHeaders() {
        return this.headers;
    }

    public void setHeaders(ArrayList<NameValuePair> headers) {
        this.headers = headers;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    public long setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this.contentLength;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public InternalResponse setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public InternalResponse setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(HttpStatus httpStatus) {
        this.httpStatus = httpStatus;
    }

    @Override
    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    @Override
    public int getRedirectTimes() {
        return this.redirectTimes;
    }

    public void setRedirectTimes(int redirectTimes) {
        this.redirectTimes = redirectTimes;
    }

    @Override
    public long getReadedLength() {
        return this.readedLength;
    }

    public void setReadedLength(long readedLength) {
        this.readedLength = readedLength;
    }

    @Override
    public long getUseTime() {
        return this.useTime;
    }

    public void setUseTime(long useTime) {
        this.useTime = useTime;
    }

    @Override
    public boolean isConnectSuccess() {
        return this.httpStatus != null && this.httpStatus.isSuccess();
    }

    public boolean isResultOk() {
        return this.getResult() != null;
    }

    public void setHttpListener(HttpListener httpListener) {
        this.listener = httpListener;
    }

    public HttpListener getListener() {
        return this.listener;
    }

    public String toString() {
        return this.resToString();
    }

    @Override
    public String resToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("^_^\n").append("____________________________ lite http response info start ____________________________").append("\n url            : ").append(this.request.getUrl()).append("\n status         : ").append(this.httpStatus).append("\n cache hit      : ").append(this.isCacheHit).append("\n charSet        : ").append(this.charSet).append("\n useTime        : ").append(this.useTime).append("\n retryTimes     : ").append(this.retryTimes).append("\n redirectTimes  : ").append(this.redirectTimes).append("\n readedLength   : ").append(this.readedLength).append("\n contentLength  : ").append(this.contentLength).append("\n contentEncoding: ").append(this.contentEncoding).append("\n contentType    : ").append(this.contentType).append("\n tag            : ").append(this.tag).append("\n header         ");
        if (this.headers == null) {
            sb.append(": null");
        } else {
            for (NameValuePair nv : this.headers) {
                sb.append("\n|    ").append(nv);
            }
        }
        sb.append("\n ").append(this.request).append("\n exception      : ").append(this.exception).append("\n.").append("\n _________________ data-start _________________").append("\n ").append(this.getResult()).append("\n _________________ data-over _________________").append("\n.").append("\n____________________________ lite http response info end ____________________________");
        return sb.toString();
    }
}

