package com.adups.http_libs;

import java.util.ArrayList;


public interface Response<T> {


    ArrayList<NameValuePair> getHeaders();

    HttpStatus getHttpStatus();

    Data getResult();

    <R extends AbstractRequest<T>> R getRequest();

    long getReadedLength();

    long getContentLength();

    String getContentEncoding();

    String getContentType();

    String getCharSet();

    long getUseTime();

    boolean isConnectSuccess();

    int getRetryTimes();

    int getRedirectTimes();

    HttpException getException();

    Response<T> setTag(Object tag);

    Object getTag();

    String resToString();

}
