package com.adups.http_libs;

/**
 * Created by fighter_lee on 2017/7/18.
 */

public abstract class AbstractRequest<T> {

    private static final String TAG = AbstractRequest.class.getSimpleName();
    private String url;
    private HttpMethods method;
    private String charSet;//默认UTF—8
    private int connectTimeout = -1;
    private int socketTimeout = -1;
    private int maxRetryTimes = -1;//重试次数
    private int maxRedirectTimes = -1;//重定向重试次数
    private HttpListener httpListener;
    private RequestConfig.ContentType type;
    private Data data;
    private byte[] content;

    public AbstractRequest(String url) {
        this.url = url;
    }

    public <S extends AbstractRequest<T>> S setUri(String url) {
        this.url = url;
        return (S) this;
    }

    public String getUrl() {
        return url;
    }

    public HttpMethods getMethod() {
        return method;
    }

    public <S extends AbstractRequest<T>> S setMethod(HttpMethods method) {
        this.method = method;
        return (S) this;
    }

    /**
     * 设置请求中的媒体类型信息
     * @param type
     * @param <S>
     * @return
     */
    public <S extends AbstractRequest<T>> S setHeaderContentType(RequestConfig.ContentType type) {
        this.type = type;
        return (S) this;
    }

    public RequestConfig.ContentType getContentType() {
        return type;
    }

    public String getCharSet() {
        return charSet;
    }

    /**
     * 设置请求编码
     * @param charSet
     * @param <S>
     * @return
     */
    public <S extends AbstractRequest<T>> S setCharSet(String charSet) {
        this.charSet = charSet;
        return (S) this;
    }

    public <S extends AbstractRequest<T>> S setContent(byte[] content) {
        this.content = content;
        return (S) this;
    }

    public byte[] getContent() {
        return content;
    }

    public int getConnectTimeout() {
        return connectTimeout;
    }

    /**
     * 连接超时时间
     * @param connectTimeout
     * @param <S>
     * @return
     */
    public <S extends AbstractRequest<T>> S setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return (S) this;
    }

    public int getSocketTimeout() {
        return socketTimeout;
    }

    /**
     * 读取超时时间
     * @param socketTimeout
     * @param <S>
     * @return
     */
    public <S extends AbstractRequest<T>> S setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return (S) this;
    }

    public int getMaxRetryTimes() {
        return maxRetryTimes;
    }

    /**
     * 设置重试次数
     * @param maxRetryTimes
     * @param <S>
     * @return
     */
    public <S extends AbstractRequest<T>> S setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
        return (S) this;
    }

    public int getMaxRedirectTimes() {
        return maxRedirectTimes;
    }

    /**
     * 设置重定向次数
     * @param maxRedirectTimes
     * @param <S>
     * @return
     */
    public <S extends AbstractRequest<T>> S setMaxRedirectTimes(int maxRedirectTimes) {
        this.maxRedirectTimes = maxRedirectTimes;
        return (S) this;
    }

    public HttpListener getHttpListener() {
        return httpListener;
    }

    /**
     * 设置监听
     * @param httpListener
     * @param <S>
     * @return
     */
    public <S extends AbstractRequest<T>> S setHttpListener(HttpListener httpListener) {
        this.httpListener = httpListener;
        return (S) this;
    }

    /**
     * 设置请求结果
     * @param data
     * @param <S>
     * @return
     */
    public <S extends AbstractRequest<T>> S setData(Data data) {
        this.data = data;
        return (S) this;
    }

    public Data getData() {
        return data;
    }

}