/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.openmediation.sdk.mediation.CustomBannerEvent;
import com.openmediation.sdk.utils.AdLog;
import com.vungle.warren.AdConfig;
import com.vungle.warren.Banners;
import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.error.VungleException;
import java.util.Map;

public class VungleBanner
extends CustomBannerEvent
implements LoadAdCallback,
PlayAdCallback {
    private com.vungle.warren.VungleBanner mBanner;
    private AdConfig.AdSize mAdSize = AdConfig.AdSize.BANNER;

    public int getMediation() {
        return 5;
    }

    public void loadAd(Activity activity, Map<String, String> config) throws Throwable {
        super.loadAd(activity, config);
        if (!this.check(activity, config)) {
            return;
        }
        this.mAdSize = this.getAdSize(config);
        this.checkInitAndLoad(activity, config);
    }

    public void destroy(Activity activity) {
        if (this.mBanner != null) {
            this.mBanner.destroyAd();
        }
    }

    public void onAdLoad(String id) {
        if (this.isDestroyed) {
            return;
        }
        if (this.mBanner != null) {
            this.mBanner.destroyAd();
        }
        this.mBanner = Banners.getBanner((String)id, (AdConfig.AdSize)this.mAdSize, (PlayAdCallback)this);
        if (this.mBanner != null) {
            this.mBanner.disableLifeCycleManagement(true);
            this.onInsReady(this.mBanner);
            this.mBanner.renderAd();
        } else {
            this.onInsError("Load Vungle banner error");
        }
    }

    public void onAdStart(String id) {
    }

    public void onAdEnd(String id, boolean completed, boolean isCTAClicked) {
        if (this.isDestroyed) {
            return;
        }
        if (isCTAClicked) {
            this.onInsClicked();
        }
    }

    public void onError(String id, VungleException exception) {
        if (this.isDestroyed) {
            return;
        }
        AdLog.getSingleton().LogE("Load Vungle Banner error : " + exception.getExceptionCode() + " msg : " + exception.getLocalizedMessage());
        this.onInsError("Load Vungle Banner error : " + exception.getExceptionCode() + " msg : " + exception.getLocalizedMessage());
    }

    private void loadBanner() {
        if (this.mBanner != null) {
            this.mBanner.finishAd();
        }
        Banners.loadBanner((String)this.mInstancesKey, (AdConfig.AdSize)this.mAdSize, (LoadAdCallback)this);
    }

    private void checkInitAndLoad(Activity activity, Map<String, String> config) {
        if (Vungle.isInitialized()) {
            this.loadBanner();
            return;
        }
        String appKey = config.get("AppKey");
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            AdLog.getSingleton().LogE("Load Vungle error When init Vungle SDK with empty appKey");
            this.onInsError("Load Vungle error When init Vungle SDK with empty appKey");
            return;
        }
        Vungle.init((String)appKey, (Context)activity.getApplicationContext(), (InitCallback)new InitCallback(){

            public void onSuccess() {
                AdLog.getSingleton().LogD("OM-Vungle", "Vungle init success ");
                VungleBanner.this.loadBanner();
            }

            public void onError(VungleException exception) {
                AdLog.getSingleton().LogE("OM-Vungle: Vungle init failed " + exception.getLocalizedMessage());
                VungleBanner.this.onInsError("Load Vungle error When init Vungle SDK : " + exception.getLocalizedMessage());
            }

            public void onAutoCacheAdAvailable(String placementId) {
            }
        });
    }

    private AdConfig.AdSize getAdSize(Map<String, String> config) {
        int[] size = this.getBannerSize(config);
        int width = size[0];
        int height = size[1];
        if (width == AdConfig.AdSize.BANNER_LEADERBOARD.getWidth() && height == AdConfig.AdSize.BANNER_LEADERBOARD.getHeight()) {
            return AdConfig.AdSize.BANNER_LEADERBOARD;
        }
        if (width == AdConfig.AdSize.BANNER_SHORT.getWidth() && height == AdConfig.AdSize.BANNER_SHORT.getHeight()) {
            return AdConfig.AdSize.BANNER_SHORT;
        }
        return AdConfig.AdSize.BANNER;
    }
}

