/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.openmediation.sdk.mediation.CustomAdsAdapter;
import com.openmediation.sdk.mediation.InterstitialAdCallback;
import com.openmediation.sdk.mediation.RewardedVideoCallback;
import com.openmediation.sdk.utils.AdLog;
import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.error.VungleException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class VungleAdapter
extends CustomAdsAdapter
implements PlayAdCallback {
    private InitState mInitState = InitState.NOT_INIT;
    private ConcurrentMap<String, InterstitialAdCallback> mIsCallback = new ConcurrentHashMap<String, InterstitialAdCallback>();
    private ConcurrentMap<String, RewardedVideoCallback> mRvCallback = new ConcurrentHashMap<String, RewardedVideoCallback>();

    public String getMediationVersion() {
        return "6.5.3";
    }

    public String getAdapterVersion() {
        return "1.1.0";
    }

    public int getAdNetworkId() {
        return 5;
    }

    private void initSDK(Activity activity) {
        this.mInitState = InitState.INIT_PENDING;
        Vungle.init((String)this.mAppKey, (Context)activity.getApplicationContext(), (InitCallback)new InitCallback(){

            public void onSuccess() {
                VungleAdapter.this.mInitState = InitState.INIT_SUCCESS;
                AdLog.getSingleton().LogD("Om-Vungle", "Vungle init success ");
                if (!VungleAdapter.this.mRvCallback.isEmpty()) {
                    for (Map.Entry videoCallbackEntry : VungleAdapter.this.mRvCallback.entrySet()) {
                        ((RewardedVideoCallback)videoCallbackEntry.getValue()).onRewardedVideoInitSuccess();
                    }
                }
                if (!VungleAdapter.this.mIsCallback.isEmpty()) {
                    for (Map.Entry interstitialAdCallbackEntry : VungleAdapter.this.mIsCallback.entrySet()) {
                        ((InterstitialAdCallback)interstitialAdCallbackEntry.getValue()).onInterstitialAdInitSuccess();
                    }
                }
            }

            public void onError(VungleException error) {
                VungleAdapter.this.mInitState = InitState.INIT_FAIL;
                AdLog.getSingleton().LogE("Om-Vungle: Vungle init failed " + error.getLocalizedMessage());
                if (!VungleAdapter.this.mRvCallback.isEmpty()) {
                    for (Map.Entry videoCallbackEntry : VungleAdapter.this.mRvCallback.entrySet()) {
                        ((RewardedVideoCallback)videoCallbackEntry.getValue()).onRewardedVideoInitFailed("Vungle init failed " + error.getLocalizedMessage());
                    }
                }
                if (!VungleAdapter.this.mIsCallback.isEmpty()) {
                    for (Map.Entry interstitialAdCallbackEntry : VungleAdapter.this.mIsCallback.entrySet()) {
                        ((InterstitialAdCallback)interstitialAdCallbackEntry.getValue()).onInterstitialAdInitFailed("Vungle init failed " + error.getLocalizedMessage());
                    }
                }
            }

            public void onAutoCacheAdAvailable(String placementId) {
            }
        });
    }

    public void initRewardedVideo(Activity activity, Map<String, Object> dataMap, RewardedVideoCallback callback) {
        super.initRewardedVideo(activity, dataMap, callback);
        String error = this.check(activity, (String)dataMap.get("pid"));
        if (TextUtils.isEmpty((CharSequence)error)) {
            String pid = (String)dataMap.get("pid");
            switch (this.mInitState) {
                case NOT_INIT: {
                    this.mRvCallback.put(pid, callback);
                    this.initSDK(activity);
                    break;
                }
                case INIT_PENDING: {
                    this.mRvCallback.put(pid, callback);
                    break;
                }
                case INIT_SUCCESS: {
                    if (callback == null) break;
                    callback.onRewardedVideoInitSuccess();
                    break;
                }
                case INIT_FAIL: {
                    if (callback == null) break;
                    callback.onRewardedVideoInitFailed("Vungle init failed ");
                    break;
                }
            }
        } else {
            AdLog.getSingleton().LogE("Om-Vungle: Vungle init failed ");
            callback.onRewardedVideoInitFailed(error);
        }
    }

    public void loadRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.loadRewardedVideo(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)error)) {
            if (!this.mRvCallback.containsKey(adUnitId)) {
                this.mRvCallback.put(adUnitId, callback);
            }
            if (Vungle.isInitialized()) {
                if (this.isRewardedVideoAvailable(adUnitId)) {
                    callback.onRewardedVideoLoadSuccess();
                } else {
                    Vungle.loadAd((String)adUnitId, (LoadAdCallback)new LoadCallback());
                }
            } else {
                callback.onRewardedVideoLoadFailed("Vungle load failed cause vungle not initialized " + adUnitId);
            }
        } else {
            AdLog.getSingleton().LogE("Om-Vungle: Vungle load failed, error: " + error);
            callback.onRewardedVideoLoadFailed(error);
        }
    }

    public void showRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.showRewardedVideo(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)error)) {
            if (!this.mRvCallback.containsKey(adUnitId)) {
                this.mRvCallback.put(adUnitId, callback);
            }
            if (this.isRewardedVideoAvailable(adUnitId)) {
                Vungle.playAd((String)adUnitId, null, (PlayAdCallback)this);
            } else {
                callback.onRewardedVideoAdShowFailed("Vungle show video failed no ready");
            }
        } else {
            AdLog.getSingleton().LogE("Om-Vungle: Vungle show video failed, error:" + error);
            callback.onRewardedVideoAdShowFailed(error);
        }
    }

    public boolean isRewardedVideoAvailable(String adUnitId) {
        return !TextUtils.isEmpty((CharSequence)adUnitId) && Vungle.canPlayAd((String)adUnitId);
    }

    public void initInterstitialAd(Activity activity, Map<String, Object> dataMap, InterstitialAdCallback callback) {
        super.initInterstitialAd(activity, dataMap, callback);
        String error = this.check(activity, (String)dataMap.get("pid"));
        if (TextUtils.isEmpty((CharSequence)error)) {
            String pid = (String)dataMap.get("pid");
            switch (this.mInitState) {
                case NOT_INIT: {
                    this.mIsCallback.put(pid, callback);
                    this.initSDK(activity);
                    break;
                }
                case INIT_PENDING: {
                    this.mIsCallback.put(pid, callback);
                    break;
                }
                case INIT_SUCCESS: {
                    if (callback == null) break;
                    callback.onInterstitialAdInitSuccess();
                    break;
                }
                case INIT_FAIL: {
                    if (callback == null) break;
                    callback.onInterstitialAdInitFailed("Vungle init failed ");
                    break;
                }
            }
        } else {
            AdLog.getSingleton().LogE("Om-Vungle: Vungle init failed ");
            callback.onInterstitialAdInitFailed(error);
        }
    }

    public void loadInterstitialAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        super.loadInterstitialAd(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)error)) {
            if (!this.mIsCallback.containsKey(adUnitId)) {
                this.mIsCallback.put(adUnitId, callback);
            }
            if (Vungle.isInitialized()) {
                if (this.isRewardedVideoAvailable(adUnitId)) {
                    callback.onInterstitialAdLoadSuccess();
                } else {
                    Vungle.loadAd((String)adUnitId, (LoadAdCallback)new LoadCallback());
                }
            } else {
                callback.onInterstitialAdLoadFailed("Vungle load failed cause vungle not initialized " + adUnitId);
            }
        } else {
            AdLog.getSingleton().LogE("Om-Vungle: Vungle load interstitial ad failed, error: " + error);
            callback.onInterstitialAdLoadFailed(error);
        }
    }

    public void showInterstitialAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        super.showInterstitialAd(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)error)) {
            if (!this.mIsCallback.containsKey(adUnitId)) {
                this.mIsCallback.put(adUnitId, callback);
            }
            if (this.isInterstitialAdAvailable(adUnitId)) {
                Vungle.playAd((String)adUnitId, null, (PlayAdCallback)this);
            } else {
                callback.onInterstitialAdShowFailed("Vungle show interstitial failed no ready");
            }
        } else {
            AdLog.getSingleton().LogE("Om-Vungle: Vungle show interstitial failed, error:" + error);
            callback.onInterstitialAdShowFailed(error);
        }
    }

    public boolean isInterstitialAdAvailable(String adUnitId) {
        return !TextUtils.isEmpty((CharSequence)adUnitId) && Vungle.canPlayAd((String)adUnitId);
    }

    public void onAdStart(String id) {
        AdLog.getSingleton().LogD("Om-Vungle", "Vungle onAdStart, id:" + id);
        if (this.mRvCallback.containsKey(id)) {
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallback.get(id);
            if (callback != null) {
                callback.onRewardedVideoAdShowSuccess();
                callback.onRewardedVideoAdStarted();
            }
        } else {
            InterstitialAdCallback callback = (InterstitialAdCallback)this.mIsCallback.get(id);
            if (callback != null) {
                callback.onInterstitialAdShowSuccess();
            }
        }
    }

    public void onAdEnd(String id, boolean completed, boolean isCTAClicked) {
        AdLog.getSingleton().LogD("Om-Vungle", "Vungle onAdEnd, id:" + id + ", completed:" + completed + ", isCtaClicked:" + isCTAClicked);
        if (this.mRvCallback.containsKey(id)) {
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallback.get(id);
            if (callback != null) {
                if (isCTAClicked) {
                    callback.onRewardedVideoAdClicked();
                }
                if (completed) {
                    callback.onRewardedVideoAdRewarded();
                }
                callback.onRewardedVideoAdEnded();
                callback.onRewardedVideoAdClosed();
            }
        } else {
            InterstitialAdCallback callback = (InterstitialAdCallback)this.mIsCallback.get(id);
            if (callback != null) {
                if (isCTAClicked) {
                    callback.onInterstitialAdClick();
                }
                callback.onInterstitialAdClosed();
            }
        }
    }

    public void onError(String id, VungleException error) {
        AdLog.getSingleton().LogE("Om-Vungle: Vungle ad play failed, id: " + id + ", message: " + error.getLocalizedMessage());
        if (this.mRvCallback.containsKey(id)) {
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallback.get(id);
            if (callback != null) {
                callback.onRewardedVideoAdShowFailed("Vungle video play failed, s:" + id + ", message:" + error.getLocalizedMessage());
            }
        } else {
            InterstitialAdCallback callback = (InterstitialAdCallback)this.mIsCallback.get(id);
            if (callback != null) {
                callback.onInterstitialAdShowFailed("Vungle interstitial play failed, s:" + id + ", message:" + error.getLocalizedMessage());
            }
        }
    }

    private static enum InitState {
        NOT_INIT,
        INIT_PENDING,
        INIT_SUCCESS,
        INIT_FAIL;

    }

    private class LoadCallback
    implements LoadAdCallback {
        private LoadCallback() {
        }

        public void onAdLoad(String id) {
            if (VungleAdapter.this.mRvCallback.containsKey(id)) {
                RewardedVideoCallback callback = (RewardedVideoCallback)VungleAdapter.this.mRvCallback.get(id);
                if (callback != null) {
                    AdLog.getSingleton().LogD("Om-Vungle", "Vungle load video success ");
                    callback.onRewardedVideoLoadSuccess();
                }
            } else {
                InterstitialAdCallback callback = (InterstitialAdCallback)VungleAdapter.this.mIsCallback.get(id);
                if (callback != null) {
                    AdLog.getSingleton().LogD("Om-Vungle", "Vungle load interstitial success ");
                    callback.onInterstitialAdLoadSuccess();
                }
            }
        }

        public void onError(String id, VungleException cause) {
            AdLog.getSingleton().LogE("Om-Vungle: Vungle load failed, message:" + cause.getMessage());
            if (VungleAdapter.this.mRvCallback.containsKey(id)) {
                RewardedVideoCallback callback = (RewardedVideoCallback)VungleAdapter.this.mRvCallback.get(id);
                if (callback != null) {
                    callback.onRewardedVideoLoadFailed("Vungle load video failed, message:" + cause.getLocalizedMessage());
                }
            } else {
                InterstitialAdCallback callback = (InterstitialAdCallback)VungleAdapter.this.mIsCallback.get(id);
                if (callback != null) {
                    callback.onInterstitialAdLoadFailed("Vungle load interstitial failed, message:" + cause.getMessage());
                }
            }
        }
    }
}

