/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import com.openmediation.sdk.mediation.CustomBannerEvent;
import com.openmediation.sdk.utils.AdLog;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.metadata.MediationMetaData;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;
import java.util.Map;

public class UnityBanner
extends CustomBannerEvent
implements BannerView.IListener {
    private static final String TAG = "OM-Unity: ";
    private boolean mDidInit = false;
    private BannerView mBannerView;

    public void loadAd(Activity activity, Map<String, String> config) throws Throwable {
        super.loadAd(activity, config);
        if (!this.check(activity, config)) {
            return;
        }
        AdLog.getSingleton().LogD("OM-Unity: Unity Banner Ad Start Load : " + this.mInstancesKey);
        if (!this.mDidInit) {
            this.initSDK(activity, config.get("AppKey"));
            this.mDidInit = true;
        }
        BannerView bannerView = new BannerView(activity, this.mInstancesKey, this.getAdSize(config));
        bannerView.setListener((BannerView.IListener)this);
        bannerView.load();
    }

    private synchronized void initSDK(Activity activity, String appKey) {
        AdLog.getSingleton().LogD(TAG, "initSDK, appkey:" + appKey);
        MediationMetaData mediationMetaData = new MediationMetaData((Context)activity);
        mediationMetaData.setName("AdTiming");
        mediationMetaData.setVersion("1.1.0");
        mediationMetaData.commit();
        UnityAds.initialize((Activity)activity, (String)appKey);
    }

    public int getMediation() {
        return 4;
    }

    public void destroy(Activity activity) {
        if (this.mBannerView != null) {
            this.mBannerView.destroy();
            this.mBannerView = null;
        }
        this.isDestroyed = true;
    }

    public void onBannerLoaded(BannerView bannerAdView) {
        if (this.isDestroyed) {
            return;
        }
        if (this.mBannerView != null) {
            this.mBannerView.destroy();
        }
        this.mBannerView = bannerAdView;
        AdLog.getSingleton().LogD("OM-Unity: Unity Banner Ad Load Success : " + this.mInstancesKey);
        this.onInsReady(bannerAdView);
    }

    public void onBannerClick(BannerView bannerAdView) {
        if (this.isDestroyed) {
            return;
        }
        AdLog.getSingleton().LogD("OM-Unity: Unity Banner Ad Click : " + this.mInstancesKey);
        this.onInsClicked();
    }

    public void onBannerFailedToLoad(BannerView bannerAdView, BannerErrorInfo errorInfo) {
        if (this.isDestroyed) {
            return;
        }
        AdLog.getSingleton().LogD("OM-Unity: Unity Banner Ad Load Failed " + errorInfo.errorMessage + "  " + this.mInstancesKey);
        this.onInsError(errorInfo.errorMessage);
    }

    public void onBannerLeftApplication(BannerView bannerView) {
    }

    private UnityBannerSize getAdSize(Map<String, String> config) {
        int[] size = this.getBannerSize(config);
        int width = size[0];
        int height = size[1];
        return new UnityBannerSize(width, height);
    }
}

