/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.openmediation.sdk.mediation.CustomAdsAdapter;
import com.openmediation.sdk.mediation.InterstitialAdCallback;
import com.openmediation.sdk.mediation.RewardedVideoCallback;
import com.openmediation.sdk.utils.AdLog;
import com.unity3d.ads.IUnityAdsListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.mediation.IUnityAdsExtendedListener;
import com.unity3d.ads.metadata.MediationMetaData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class UnityAdapter
extends CustomAdsAdapter
implements IUnityAdsExtendedListener {
    private static final String TAG = "Om-Unity";
    private ConcurrentLinkedQueue<String> mRvLoadTrigerIds;
    private ConcurrentLinkedQueue<String> mIsLoadTrigerIds = new ConcurrentLinkedQueue();
    private ConcurrentHashMap<String, InterstitialAdCallback> mIsCallbacks;
    private ConcurrentHashMap<String, RewardedVideoCallback> mRvCallbacks;
    private boolean mDidInit = false;

    public UnityAdapter() {
        this.mRvLoadTrigerIds = new ConcurrentLinkedQueue();
        this.mIsCallbacks = new ConcurrentHashMap();
        this.mRvCallbacks = new ConcurrentHashMap();
    }

    public String getMediationVersion() {
        return UnityAds.getVersion();
    }

    public String getAdapterVersion() {
        return "1.1.0";
    }

    public int getAdNetworkId() {
        return 4;
    }

    private synchronized void initSDK(Activity activity) {
        if (!this.mDidInit) {
            AdLog.getSingleton().LogD("UnityAdapter", "initSDK, appkey:" + this.mAppKey);
            MediationMetaData mediationMetaData = new MediationMetaData((Context)activity);
            mediationMetaData.setName("Om");
            mediationMetaData.setVersion("1.1.0");
            mediationMetaData.commit();
            UnityAds.initialize((Activity)activity, (String)this.mAppKey, (IUnityAdsListener)this);
            this.mDidInit = true;
        }
    }

    public void initRewardedVideo(Activity activity, Map<String, Object> dataMap, RewardedVideoCallback callback) {
        super.initRewardedVideo(activity, dataMap, callback);
        AdLog.getSingleton().LogD("UnityAdapter", "initRewardedVideo, appkey:" + this.mAppKey);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.initSDK(activity);
            if (this.mDidInit && callback != null) {
                callback.onRewardedVideoInitSuccess();
            }
        } else if (callback != null) {
            callback.onRewardedVideoInitFailed(error);
        }
    }

    public void loadRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.loadRewardedVideo(activity, adUnitId, callback);
        String checkError = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)checkError)) {
            this.mRvCallbacks.put(adUnitId, callback);
            if (UnityAds.isReady((String)adUnitId)) {
                if (callback != null) {
                    callback.onRewardedVideoLoadSuccess();
                }
            } else if (UnityAds.isInitialized() && UnityAds.getPlacementState((String)adUnitId) != UnityAds.PlacementState.WAITING) {
                if (callback != null) {
                    callback.onRewardedVideoLoadFailed("No Fill");
                }
            } else {
                this.mRvLoadTrigerIds.add(adUnitId);
            }
        } else if (callback != null) {
            callback.onRewardedVideoLoadFailed("loadRewardedVideo error cause " + checkError);
        }
    }

    public void showRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.showRewardedVideo(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onRewardedVideoAdShowFailed(error);
            }
            return;
        }
        if (UnityAds.isReady((String)adUnitId)) {
            UnityAds.show((Activity)activity, (String)adUnitId);
        } else {
            AdLog.getSingleton().LogE("Om-Unity: Unity Video show() called but ad not ready");
            if (callback != null) {
                callback.onRewardedVideoAdShowFailed("Unity Video show() called but ad not ready");
            }
        }
    }

    public boolean isRewardedVideoAvailable(String adUnitId) {
        return UnityAds.isReady((String)adUnitId);
    }

    public void initInterstitialAd(Activity activity, Map<String, Object> dataMap, InterstitialAdCallback callback) {
        super.initInterstitialAd(activity, dataMap, callback);
        AdLog.getSingleton().LogD("UnityAdapter", "initInterstitialAd, appkey:" + this.mAppKey);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.initSDK(activity);
            if (this.mDidInit && callback != null) {
                callback.onInterstitialAdInitSuccess();
            }
        } else if (callback != null) {
            callback.onInterstitialAdInitFailed(error);
        }
    }

    public void loadInterstitialAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        super.loadInterstitialAd(activity, adUnitId, callback);
        String checkError = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)checkError)) {
            this.mIsCallbacks.put(adUnitId, callback);
            if (UnityAds.isReady((String)adUnitId)) {
                if (callback != null) {
                    callback.onInterstitialAdLoadSuccess();
                }
            } else if (UnityAds.isInitialized() && UnityAds.getPlacementState((String)adUnitId) != UnityAds.PlacementState.WAITING) {
                if (callback != null) {
                    callback.onInterstitialAdLoadFailed("No Fill");
                }
            } else {
                this.mIsLoadTrigerIds.add(adUnitId);
            }
        } else if (callback != null) {
            callback.onInterstitialAdLoadFailed("loadInterstitialAd error cause " + checkError);
        }
    }

    public boolean isInterstitialAdAvailable(String adUnitId) {
        return UnityAds.isReady((String)adUnitId);
    }

    public void showInterstitialAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        super.showInterstitialAd(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onInterstitialAdShowFailed(error);
            }
            return;
        }
        if (UnityAds.isReady((String)adUnitId)) {
            UnityAds.show((Activity)activity, (String)adUnitId);
        } else {
            AdLog.getSingleton().LogE("Om-Unity: Unity interstitial show() called but ad not ready");
            if (callback != null) {
                callback.onInterstitialAdShowFailed("Unity interstitial show() called but ad not ready");
            }
        }
    }

    public void onUnityAdsClick(String placementId) {
        AdLog.getSingleton().LogD(TAG, "onUnityAdsClick : " + placementId);
        if (!TextUtils.isEmpty((CharSequence)placementId)) {
            RewardedVideoCallback rvCallback = this.mRvCallbacks.get(placementId);
            if (rvCallback != null) {
                rvCallback.onRewardedVideoAdClicked();
            } else {
                InterstitialAdCallback isCallback = this.mIsCallbacks.get(placementId);
                if (isCallback != null) {
                    isCallback.onInterstitialAdClick();
                }
            }
        }
    }

    public void onUnityAdsPlacementStateChanged(String placementId, UnityAds.PlacementState oldState, UnityAds.PlacementState newState) {
        AdLog.getSingleton().LogD(TAG, "onUnityAdsPlacementStateChanged : " + placementId + " oldState : " + oldState.name() + " newState: " + newState.name());
        if (newState.equals((Object)oldState) || newState.equals((Object)UnityAds.PlacementState.WAITING)) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)placementId)) {
            InterstitialAdCallback isCallback;
            if (this.mRvLoadTrigerIds.contains(placementId)) {
                RewardedVideoCallback rvCallback = this.mRvCallbacks.get(placementId);
                if (rvCallback != null) {
                    if (UnityAds.isReady((String)placementId)) {
                        rvCallback.onRewardedVideoLoadSuccess();
                    } else {
                        rvCallback.onRewardedVideoLoadFailed(placementId + " placement state: " + newState.toString());
                    }
                    this.mRvLoadTrigerIds.remove(placementId);
                }
            } else if (this.mIsLoadTrigerIds.contains(placementId) && (isCallback = this.mIsCallbacks.get(placementId)) != null) {
                if (UnityAds.isReady((String)placementId)) {
                    isCallback.onInterstitialAdLoadSuccess();
                } else {
                    isCallback.onInterstitialAdLoadFailed(placementId + " placement state: " + newState.toString());
                }
                this.mIsLoadTrigerIds.remove(placementId);
            }
        }
    }

    public void onUnityAdsReady(String placementId) {
        AdLog.getSingleton().LogD(TAG, "onUnityAdsReady : " + placementId);
    }

    public void onUnityAdsStart(String placementId) {
        AdLog.getSingleton().LogD(TAG, "onUnityAdsStart : " + placementId);
        if (!TextUtils.isEmpty((CharSequence)placementId)) {
            RewardedVideoCallback rvCallback = this.mRvCallbacks.get(placementId);
            if (rvCallback != null) {
                rvCallback.onRewardedVideoAdShowSuccess();
                rvCallback.onRewardedVideoAdStarted();
            } else {
                InterstitialAdCallback isCallback = this.mIsCallbacks.get(placementId);
                if (isCallback != null) {
                    isCallback.onInterstitialAdShowSuccess();
                }
            }
        }
    }

    public void onUnityAdsFinish(String placementId, UnityAds.FinishState result) {
        AdLog.getSingleton().LogD(TAG, "onUnityAdsFinish : " + placementId + " result : " + result.name());
        if (!TextUtils.isEmpty((CharSequence)placementId)) {
            RewardedVideoCallback rvCallback = this.mRvCallbacks.get(placementId);
            if (rvCallback != null) {
                if (result.equals((Object)UnityAds.FinishState.COMPLETED)) {
                    rvCallback.onRewardedVideoAdEnded();
                    rvCallback.onRewardedVideoAdRewarded();
                }
                rvCallback.onRewardedVideoAdClosed();
            } else {
                InterstitialAdCallback isCallback = this.mIsCallbacks.get(placementId);
                if (isCallback != null) {
                    isCallback.onInterstitialAdClosed();
                }
            }
        }
    }

    public void onUnityAdsError(UnityAds.UnityAdsError error, String message) {
        AdLog.getSingleton().LogE("Om-Unity:onUnityAdsError, error:" + error + ", message:" + message);
    }
}

