/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdExtendedListener;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdExtendedListener;
import com.facebook.ads.RewardedVideoAdListener;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomAdsAdapter;
import com.openmediation.sdk.mediation.InterstitialAdCallback;
import com.openmediation.sdk.mediation.RewardedVideoCallback;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class FacebookAdapter
extends CustomAdsAdapter {
    private static final String PAY_LOAD = "pay_load";
    private Boolean mDidInitSuccess = null;
    private AtomicBoolean mDidCallInit;
    private ConcurrentMap<String, RewardedVideoAd> mFbRvAds = new ConcurrentHashMap<String, RewardedVideoAd>();
    private ConcurrentMap<String, InterstitialAd> mFbIsAds = new ConcurrentHashMap<String, InterstitialAd>();
    private ConcurrentMap<String, RewardedVideoCallback> mRvCallbacks = new ConcurrentHashMap<String, RewardedVideoCallback>();
    private ConcurrentMap<String, InterstitialAdCallback> mIsCallbacks = new ConcurrentHashMap<String, InterstitialAdCallback>();

    public FacebookAdapter() {
        this.mDidCallInit = new AtomicBoolean(false);
    }

    public String getMediationVersion() {
        return "6.0.0";
    }

    public String getAdapterVersion() {
        return "1.3.1";
    }

    public int getAdNetworkId() {
        return 3;
    }

    public void initRewardedVideo(Activity activity, Map<String, Object> dataMap, RewardedVideoCallback callback) {
        super.initRewardedVideo(activity, dataMap, callback);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.mRvCallbacks.put((String)dataMap.get("pid"), callback);
            this.initSdk(activity);
            if (this.mDidInitSuccess != null) {
                if (this.mDidInitSuccess.booleanValue()) {
                    callback.onRewardedVideoInitSuccess();
                } else {
                    callback.onRewardedVideoInitFailed(AdapterErrorBuilder.buildInitError((String)"Rewarded Video", (String)this.mAdapterName, (String)"Init facebook sdk failed"));
                }
            }
        } else if (callback != null) {
            callback.onRewardedVideoInitFailed(AdapterErrorBuilder.buildInitError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
        }
    }

    public void loadRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.loadRewardedVideo(activity, adUnitId, callback);
        this.loadRv(activity, adUnitId, null, callback);
    }

    public void loadRewardedVideo(Activity activity, String adUnitId, Map<String, Object> extras, RewardedVideoCallback callback) {
        super.loadRewardedVideo(activity, adUnitId, extras, callback);
        this.loadRv(activity, adUnitId, extras, callback);
    }

    private void loadRv(Activity activity, String adUnitId, Map<String, Object> extras, RewardedVideoCallback callback) {
        String error = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)error)) {
            RewardedVideoAd rewardedVideoAd = this.getRv(activity, adUnitId);
            RewardedVideoAd.RewardedVideoAdLoadConfigBuilder configBuilder = rewardedVideoAd.buildLoadAdConfig();
            configBuilder.withAdListener((RewardedVideoAdListener)new FbRvListener((RewardedVideoCallback)this.mRvCallbacks.get(adUnitId)));
            if (rewardedVideoAd.isAdLoaded()) {
                if (callback != null) {
                    callback.onRewardedVideoLoadSuccess();
                }
            } else {
                if (extras != null && extras.containsKey(PAY_LOAD)) {
                    configBuilder.withBid(String.valueOf(extras.get(PAY_LOAD)));
                }
                rewardedVideoAd.loadAd(configBuilder.build());
            }
        } else if (callback != null) {
            callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
        }
    }

    public void showRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.showRewardedVideo(activity, adUnitId, callback);
        if (this.isRewardedVideoAvailable(adUnitId)) {
            RewardedVideoAd rewardedVideoAd = (RewardedVideoAd)this.mFbRvAds.get(adUnitId);
            rewardedVideoAd.show();
        } else if (callback != null) {
            callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)"Facebook rewardedVideo is not ready"));
        }
    }

    public boolean isRewardedVideoAvailable(String adUnitId) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            return false;
        }
        RewardedVideoAd rewardedVideoAd = (RewardedVideoAd)this.mFbRvAds.get(adUnitId);
        return rewardedVideoAd != null && rewardedVideoAd.isAdLoaded();
    }

    public void initInterstitialAd(Activity activity, Map<String, Object> dataMap, InterstitialAdCallback callback) {
        super.initInterstitialAd(activity, dataMap, callback);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.mIsCallbacks.put((String)dataMap.get("pid"), callback);
            this.initSdk(activity);
            if (this.mDidInitSuccess != null) {
                if (this.mDidInitSuccess.booleanValue()) {
                    callback.onInterstitialAdInitSuccess();
                } else {
                    callback.onInterstitialAdInitFailed(AdapterErrorBuilder.buildInitError((String)"Interstitial", (String)this.mAdapterName, (String)"Init facebook sdk failed"));
                }
            }
        } else if (callback != null) {
            callback.onInterstitialAdInitFailed(AdapterErrorBuilder.buildInitError((String)"Interstitial", (String)this.mAdapterName, (String)error));
        }
    }

    public void loadInterstitialAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        super.loadInterstitialAd(activity, adUnitId, callback);
        this.loadInterstitial(activity, adUnitId, null, callback);
    }

    public void loadInterstitialAd(Activity activity, String adUnitId, Map<String, Object> extras, InterstitialAdCallback callback) {
        super.loadInterstitialAd(activity, adUnitId, extras, callback);
        this.loadInterstitial(activity, adUnitId, extras, callback);
    }

    private void loadInterstitial(Activity activity, String adUnitId, Map<String, Object> extras, InterstitialAdCallback callback) {
        String error = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)error)) {
            InterstitialAd interstitialAd = this.getIs(activity, adUnitId);
            InterstitialAd.InterstitialAdLoadConfigBuilder configBuilder = interstitialAd.buildLoadAdConfig();
            configBuilder.withAdListener((InterstitialAdListener)new FbIsAdListener((InterstitialAdCallback)this.mIsCallbacks.get(adUnitId)));
            if (interstitialAd.isAdLoaded()) {
                if (callback != null) {
                    callback.onInterstitialAdLoadSuccess();
                }
            } else {
                if (extras != null && extras.containsKey(PAY_LOAD)) {
                    configBuilder.withBid(String.valueOf(extras.get(PAY_LOAD)));
                }
                interstitialAd.loadAd(configBuilder.build());
            }
        } else if (callback != null) {
            callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Interstitial", (String)this.mAdapterName, (String)error));
        }
    }

    public void showInterstitialAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        super.showInterstitialAd(activity, adUnitId, callback);
        if (this.isInterstitialAdAvailable(adUnitId)) {
            InterstitialAd interstitialAd = (InterstitialAd)this.mFbIsAds.get(adUnitId);
            interstitialAd.show();
        } else if (callback != null) {
            callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)"Facebook interstitial is not ready"));
        }
    }

    public boolean isInterstitialAdAvailable(String adUnitId) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            return false;
        }
        InterstitialAd interstitialAd = (InterstitialAd)this.mFbIsAds.get(adUnitId);
        return interstitialAd != null && interstitialAd.isAdLoaded();
    }

    private RewardedVideoAd getRv(Activity activity, String adUnitId) {
        RewardedVideoAd rewardedVideoAd = (RewardedVideoAd)this.mFbRvAds.get(adUnitId);
        if (rewardedVideoAd == null) {
            rewardedVideoAd = new RewardedVideoAd((Context)activity, adUnitId);
            this.mFbRvAds.put(adUnitId, rewardedVideoAd);
        }
        return rewardedVideoAd;
    }

    private InterstitialAd getIs(Activity activity, String adUnitId) {
        InterstitialAd interstitialAd = (InterstitialAd)this.mFbIsAds.get(adUnitId);
        if (interstitialAd == null) {
            interstitialAd = new InterstitialAd((Context)activity, adUnitId);
            this.mFbIsAds.put(adUnitId, interstitialAd);
        }
        return interstitialAd;
    }

    private void initSdk(final Activity activity) {
        AdSettings.setIntegrationErrorMode((AdSettings.IntegrationErrorMode)AdSettings.IntegrationErrorMode.INTEGRATION_ERROR_CALLBACK_MODE);
        if (this.mDidCallInit.compareAndSet(false, true)) {
            AudienceNetworkAds.buildInitSettings((Context)activity.getApplicationContext()).withInitListener(new AudienceNetworkAds.InitListener(){

                public void onInitialized(final AudienceNetworkAds.InitResult result) {
                    activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (result.isSuccess()) {
                                FacebookAdapter.this.mDidInitSuccess = true;
                                for (InterstitialAdCallback callback : FacebookAdapter.this.mIsCallbacks.values()) {
                                    callback.onInterstitialAdInitSuccess();
                                }
                                for (InterstitialAdCallback callback : FacebookAdapter.this.mRvCallbacks.values()) {
                                    callback.onRewardedVideoInitSuccess();
                                }
                            } else {
                                FacebookAdapter.this.mDidInitSuccess = false;
                                String message = "Facebook init failed:" + result.getMessage();
                                for (InterstitialAdCallback callback : FacebookAdapter.this.mIsCallbacks.values()) {
                                    callback.onInterstitialAdInitFailed(AdapterErrorBuilder.buildInitError((String)"Interstitial", (String)FacebookAdapter.this.mAdapterName, (String)message));
                                }
                                for (InterstitialAdCallback callback : FacebookAdapter.this.mRvCallbacks.values()) {
                                    callback.onRewardedVideoInitFailed(AdapterErrorBuilder.buildInitError((String)"Rewarded Video", (String)FacebookAdapter.this.mAdapterName, (String)message));
                                }
                            }
                        }
                    });
                }
            }).initialize();
        }
    }

    private static class FbIsAdListener
    implements InterstitialAdExtendedListener {
        private InterstitialAdCallback isCallback;

        FbIsAdListener(InterstitialAdCallback callback) {
            this.isCallback = callback;
        }

        public void onInterstitialDisplayed(Ad ad) {
        }

        public void onInterstitialDismissed(Ad ad) {
            if (this.isCallback != null) {
                this.isCallback.onInterstitialAdClosed();
            }
        }

        public void onError(Ad ad, AdError adError) {
            if (this.isCallback != null) {
                this.isCallback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Interstitial", (String)"FacebookAdapter", (int)adError.getErrorCode(), (String)adError.getErrorMessage()));
            }
        }

        public void onAdLoaded(Ad ad) {
            if (this.isCallback != null) {
                this.isCallback.onInterstitialAdLoadSuccess();
            }
        }

        public void onAdClicked(Ad ad) {
            if (this.isCallback != null) {
                this.isCallback.onInterstitialAdClick();
            }
        }

        public void onLoggingImpression(Ad ad) {
            if (this.isCallback != null) {
                this.isCallback.onInterstitialAdShowSuccess();
            }
        }

        public void onInterstitialActivityDestroyed() {
            if (this.isCallback != null) {
                this.isCallback.onInterstitialAdClosed();
            }
        }

        public void onRewardedAdCompleted() {
        }

        public void onRewardedAdServerSucceeded() {
        }

        public void onRewardedAdServerFailed() {
        }
    }

    private static class FbRvListener
    implements RewardedVideoAdExtendedListener {
        private RewardedVideoCallback rvCallback;
        private AtomicBoolean mDidRvCloseCallbacked;

        FbRvListener(RewardedVideoCallback callback) {
            this.rvCallback = callback;
            this.mDidRvCloseCallbacked = new AtomicBoolean(false);
        }

        public void onRewardedVideoCompleted() {
            if (this.rvCallback != null) {
                this.rvCallback.onRewardedVideoAdRewarded();
                this.rvCallback.onRewardedVideoAdEnded();
            }
        }

        public void onError(Ad ad, AdError adError) {
            if (this.rvCallback != null) {
                this.rvCallback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Rewarded Video", (String)"FacebookAdapter", (int)adError.getErrorCode(), (String)adError.getErrorMessage()));
            }
        }

        public void onAdLoaded(Ad ad) {
            if (this.rvCallback != null) {
                this.rvCallback.onRewardedVideoLoadSuccess();
            }
        }

        public void onAdClicked(Ad ad) {
            if (this.rvCallback != null) {
                this.rvCallback.onRewardedVideoAdClicked();
            }
        }

        public void onLoggingImpression(Ad ad) {
            this.mDidRvCloseCallbacked.set(false);
            if (this.rvCallback != null) {
                this.rvCallback.onRewardedVideoAdShowSuccess();
                this.rvCallback.onRewardedVideoAdStarted();
            }
        }

        public void onRewardedVideoClosed() {
            if (this.rvCallback != null && !this.mDidRvCloseCallbacked.get()) {
                this.mDidRvCloseCallbacked.set(true);
                this.rvCallback.onRewardedVideoAdClosed();
            }
        }

        public void onRewardedVideoActivityDestroyed() {
            if (this.rvCallback != null && !this.mDidRvCloseCallbacked.get()) {
                this.mDidRvCloseCallbacked.set(true);
                this.rvCallback.onRewardedVideoAdClosed();
            }
        }
    }
}

