/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdOptionsView;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdLayout;
import com.facebook.ads.NativeAdListener;
import com.openmediation.sdk.mediation.CustomNativeEvent;
import com.openmediation.sdk.nativead.AdIconView;
import com.openmediation.sdk.nativead.NativeAdView;
import com.openmediation.sdk.utils.AdLog;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class FacebookNative
extends CustomNativeEvent
implements NativeAdListener {
    private static final String PAY_LOAD = "pay_load";
    private AtomicBoolean mDidCallInit = new AtomicBoolean(false);
    private NativeAd nativeAd;
    private AdOptionsView adOptionsView;
    private com.openmediation.sdk.nativead.MediaView mediaView;
    private AdIconView adIconView;

    public void registerNativeView(NativeAdView adView) {
        NativeAdLayout fbNativeAdLayout = new NativeAdLayout(adView.getContext());
        ArrayList<Object> views = new ArrayList<Object>();
        if (adView.getMediaView() != null) {
            this.mediaView = adView.getMediaView();
            views.add(this.mediaView);
        }
        if (adView.getAdIconView() != null) {
            this.adIconView = adView.getAdIconView();
            views.add(this.adIconView);
        }
        if (adView.getTitleView() != null) {
            views.add(adView.getTitleView());
        }
        if (adView.getDescView() != null) {
            views.add(adView.getDescView());
        }
        if (adView.getCallToActionView() != null) {
            views.add(adView.getCallToActionView());
        }
        if (this.adOptionsView == null) {
            this.adOptionsView = new AdOptionsView(adView.getContext(), (NativeAdBase)this.nativeAd, fbNativeAdLayout);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(10);
            layoutParams.addRule(11);
            adView.addView((View)this.adOptionsView, (ViewGroup.LayoutParams)layoutParams);
        }
        MediaView fb_mediaView = null;
        if (this.mediaView != null) {
            this.mediaView.removeAllViews();
            fb_mediaView = new MediaView(adView.getContext());
            this.mediaView.addView((View)fb_mediaView);
        }
        MediaView fbAdIconView = null;
        if (this.adIconView != null) {
            this.adIconView.removeAllViews();
            fbAdIconView = new MediaView(adView.getContext());
            this.adIconView.addView((View)fbAdIconView);
        }
        this.nativeAd.registerViewForInteraction((View)fbNativeAdLayout, fb_mediaView, fbAdIconView, views);
        if (this.adOptionsView != null) {
            this.adOptionsView.bringToFront();
        }
    }

    public void loadAd(Activity activity, Map<String, String> config) throws Throwable {
        super.loadAd(activity, config);
        if (!this.check(activity, config)) {
            return;
        }
        this.initSdk(activity);
        this.nativeAd = new NativeAd((Context)activity, this.mInstancesKey);
        NativeAdBase.NativeAdLoadConfigBuilder loadConfigBuilder = this.nativeAd.buildLoadAdConfig();
        if (config.containsKey(PAY_LOAD)) {
            loadConfigBuilder.withBid(config.get(PAY_LOAD));
        }
        loadConfigBuilder.withAdListener((NativeAdListener)this);
        this.nativeAd.loadAd(loadConfigBuilder.build());
    }

    public int getMediation() {
        return 3;
    }

    public void destroy(Activity activity) {
        if (this.nativeAd != null) {
            this.nativeAd.destroy();
            this.nativeAd = null;
        }
        this.isDestroyed = true;
    }

    public void onMediaDownloaded(Ad ad) {
    }

    public void onError(Ad ad, AdError adError) {
        if (this.isDestroyed) {
            return;
        }
        this.onInsError(adError.getErrorMessage());
        AdLog.getSingleton().LogE("Om-Facebook: Facebook Native ad load failed " + adError.getErrorMessage());
    }

    public void onAdLoaded(Ad ad) {
        if (this.isDestroyed) {
            return;
        }
        this.mAdInfo.setDesc(this.nativeAd.getAdBodyText());
        this.mAdInfo.setType(2);
        this.mAdInfo.setCallToActionText(this.nativeAd.getAdCallToAction());
        this.mAdInfo.setTitle(this.nativeAd.getAdHeadline());
        this.onInsReady(this.mAdInfo);
        AdLog.getSingleton().LogD("Om-Facebook", "Facebook Native ad load success ");
    }

    public void onAdClicked(Ad ad) {
        if (this.isDestroyed) {
            return;
        }
        this.onInsClicked();
    }

    public void onLoggingImpression(Ad ad) {
    }

    private void initSdk(Activity activity) {
        AdSettings.setIntegrationErrorMode((AdSettings.IntegrationErrorMode)AdSettings.IntegrationErrorMode.INTEGRATION_ERROR_CALLBACK_MODE);
        if (this.mDidCallInit.compareAndSet(false, true)) {
            if (AudienceNetworkAds.isInAdsProcess((Context)activity.getApplicationContext())) {
                return;
            }
            AudienceNetworkAds.buildInitSettings((Context)activity.getApplicationContext()).withInitListener(new AudienceNetworkAds.InitListener(){

                public void onInitialized(AudienceNetworkAds.InitResult result) {
                }
            }).initialize();
        }
    }
}

