/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkSettings;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomAdsAdapter;
import com.openmediation.sdk.mediation.InterstitialAdCallback;
import com.openmediation.sdk.mediation.RewardedVideoCallback;
import com.openmediation.sdk.utils.AdLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AppLovinAdapter
extends CustomAdsAdapter
implements AppLovinAdVideoPlaybackListener,
AppLovinAdDisplayListener,
AppLovinAdClickListener {
    private boolean mDidInited = false;
    private AppLovinSdk mAppLovinSDk;
    private final ConcurrentMap<String, AppLovinAd> mAppLovinIsAds = new ConcurrentHashMap<String, AppLovinAd>();
    private final ConcurrentMap<String, InterstitialAdCallback> mIsCallbacks = new ConcurrentHashMap<String, InterstitialAdCallback>();
    private final ConcurrentMap<String, AppLovinIncentivizedInterstitial> mRvAds = new ConcurrentHashMap<String, AppLovinIncentivizedInterstitial>();
    private final ConcurrentMap<String, RewardedVideoCallback> mRvCallbacks = new ConcurrentHashMap<String, RewardedVideoCallback>();
    static final int AGE_RESTRICTION = 16;

    public String getMediationVersion() {
        return AppLovinSdk.VERSION;
    }

    public String getAdapterVersion() {
        return "1.3.2";
    }

    public int getAdNetworkId() {
        return 8;
    }

    public void setGDPRConsent(Context context, boolean consent) {
        super.setGDPRConsent(context, consent);
        if (context != null) {
            AppLovinPrivacySettings.setHasUserConsent((boolean)consent, (Context)context);
        }
    }

    public void setUserAge(Context context, int age) {
        super.setUserAge(context, age);
        this.setAgeRestricted(context, age < 16);
    }

    public void setAgeRestricted(Context context, boolean restricted) {
        super.setAgeRestricted(context, restricted);
        if (context != null) {
            AppLovinPrivacySettings.setIsAgeRestrictedUser((boolean)restricted, (Context)context);
        }
    }

    public void setUSPrivacyLimit(Context context, boolean value) {
        super.setUSPrivacyLimit(context, value);
        if (context != null) {
            AppLovinPrivacySettings.setDoNotSell((boolean)value, (Context)context);
        }
    }

    public void initRewardedVideo(Activity activity, Map<String, Object> dataMap, RewardedVideoCallback callback) {
        super.initRewardedVideo(activity, dataMap, callback);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.initSDK(activity);
            if (this.mDidInited) {
                callback.onRewardedVideoInitSuccess();
            }
        } else if (callback != null) {
            callback.onRewardedVideoInitFailed(AdapterErrorBuilder.buildInitError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
        }
    }

    private synchronized void initSDK(Activity activity) {
        if (!this.mDidInited) {
            AppLovinSdk lovinSdk = AppLovinSdk.getInstance((String)this.mAppKey, (AppLovinSdkSettings)new AppLovinSdkSettings(activity.getApplicationContext()), (Context)activity.getApplicationContext());
            if (lovinSdk == null) {
                return;
            }
            this.mAppLovinSDk = lovinSdk;
            lovinSdk.initializeSdk();
            this.mDidInited = true;
        }
    }

    private AppLovinIncentivizedInterstitial getVideo(Activity activity, String adUnitId) {
        AppLovinIncentivizedInterstitial videoAd = (AppLovinIncentivizedInterstitial)this.mRvAds.get(adUnitId);
        if (videoAd == null) {
            AppLovinSdk lovinSdk = AppLovinSdk.getInstance((String)this.mAppKey, (AppLovinSdkSettings)new AppLovinSdkSettings(), (Context)activity);
            if (lovinSdk == null) {
                return null;
            }
            videoAd = AppLovinIncentivizedInterstitial.create((String)adUnitId, (AppLovinSdk)lovinSdk);
            this.mRvAds.put(adUnitId, videoAd);
        }
        return videoAd;
    }

    public void loadRewardedVideo(Activity activity, String adUnitId, final RewardedVideoCallback callback) {
        super.loadRewardedVideo(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)error)) {
            AppLovinIncentivizedInterstitial videoAd = this.getVideo(activity, adUnitId);
            if (videoAd == null) {
                callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Rewarded Video", (String)this.mAdapterName, (String)"Ad LoadFailed"));
            } else if (videoAd.isAdReadyToDisplay()) {
                if (callback != null) {
                    callback.onRewardedVideoLoadSuccess();
                }
            } else {
                videoAd.preload(new AppLovinAdLoadListener(){

                    public void adReceived(AppLovinAd appLovinAd) {
                        if (appLovinAd != null && callback != null) {
                            callback.onRewardedVideoLoadSuccess();
                        }
                    }

                    public void failedToReceiveAd(int i) {
                        if (callback != null) {
                            callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Rewarded Video", (String)AppLovinAdapter.this.mAdapterName, (int)i, (String)AppLovinAdapter.getErrorString(i)));
                        }
                    }
                });
                this.mRvCallbacks.put(adUnitId, callback);
            }
        } else if (callback != null) {
            callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
        }
    }

    public void showRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.showRewardedVideo(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)error));
            }
            return;
        }
        AppLovinIncentivizedInterstitial videoAd = this.getVideo(activity, adUnitId);
        if (videoAd == null) {
            if (callback != null) {
                callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)"AppLovin video get fail when show"));
            }
        } else {
            if (!this.isRewardedVideoAvailable(adUnitId)) {
                if (callback != null) {
                    callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)this.mAdapterName, (String)"AppLovin video not ready when show"));
                }
                return;
            }
            if (callback != null) {
                this.mRvCallbacks.put(adUnitId, callback);
            }
            videoAd.show((Context)activity, null, (AppLovinAdVideoPlaybackListener)this, (AppLovinAdDisplayListener)this, (AppLovinAdClickListener)this);
        }
    }

    public boolean isRewardedVideoAvailable(String adUnitId) {
        AppLovinIncentivizedInterstitial videoAd = (AppLovinIncentivizedInterstitial)this.mRvAds.get(adUnitId);
        return videoAd != null && videoAd.isAdReadyToDisplay();
    }

    public void initInterstitialAd(Activity activity, Map<String, Object> dataMap, InterstitialAdCallback callback) {
        super.initInterstitialAd(activity, dataMap, callback);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.initSDK(activity);
            if (this.mDidInited && callback != null) {
                callback.onInterstitialAdInitSuccess();
            }
        } else if (callback != null) {
            callback.onInterstitialAdInitFailed(AdapterErrorBuilder.buildInitError((String)"Interstitial", (String)this.mAdapterName, (String)error));
        }
    }

    public void loadInterstitialAd(Activity activity, final String adUnitId, final InterstitialAdCallback callback) {
        super.loadInterstitialAd(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)error)) {
            if (this.isInterstitialAdAvailable(adUnitId)) {
                if (callback != null) {
                    callback.onInterstitialAdLoadSuccess();
                }
                return;
            }
            if (this.mAppLovinSDk != null) {
                this.mAppLovinSDk.getAdService().loadNextAdForZoneId(adUnitId, new AppLovinAdLoadListener(){

                    public void adReceived(AppLovinAd appLovinAd) {
                        if (appLovinAd != null) {
                            AppLovinAdapter.this.mAppLovinIsAds.put(adUnitId, appLovinAd);
                            if (callback != null) {
                                callback.onInterstitialAdLoadSuccess();
                            }
                        }
                    }

                    public void failedToReceiveAd(int i) {
                        if (callback != null) {
                            callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Interstitial", (String)AppLovinAdapter.this.mAdapterName, (int)i, (String)AppLovinAdapter.getErrorString(i)));
                        }
                    }
                });
            }
        } else if (callback != null) {
            callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Interstitial", (String)this.mAdapterName, (String)error));
        }
    }

    public void showInterstitialAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        super.showInterstitialAd(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)error));
            }
            return;
        }
        if (this.isInterstitialAdAvailable(adUnitId)) {
            AppLovinInterstitialAdDialog interstitialAd = AppLovinInterstitialAd.create((AppLovinSdk)this.mAppLovinSDk, (Context)activity);
            if (interstitialAd != null) {
                interstitialAd.setAdClickListener((AppLovinAdClickListener)this);
                interstitialAd.setAdDisplayListener((AppLovinAdDisplayListener)this);
                if (callback != null) {
                    this.mIsCallbacks.put(adUnitId, callback);
                }
                interstitialAd.showAndRender((AppLovinAd)this.mAppLovinIsAds.get(adUnitId));
                this.mAppLovinIsAds.remove(adUnitId);
            }
        } else if (callback != null) {
            callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)this.mAdapterName, (String)"not ready"));
        }
    }

    public boolean isInterstitialAdAvailable(String adUnitId) {
        return this.mAppLovinIsAds.containsKey(adUnitId);
    }

    public void adClicked(AppLovinAd appLovinAd) {
        AdLog.getSingleton().LogD("OM-AppLovin", "adClicked:" + appLovinAd);
        if (appLovinAd != null) {
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(appLovinAd.getZoneId());
            if (callback != null) {
                callback.onRewardedVideoAdClicked();
            } else {
                InterstitialAdCallback interstitialAdCallback = (InterstitialAdCallback)this.mIsCallbacks.get(appLovinAd.getZoneId());
                if (interstitialAdCallback != null) {
                    interstitialAdCallback.onInterstitialAdClick();
                }
            }
        }
    }

    public void adDisplayed(AppLovinAd appLovinAd) {
        AdLog.getSingleton().LogD("OM-AppLovin", "adDisplayed:" + appLovinAd);
        if (appLovinAd != null) {
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(appLovinAd.getZoneId());
            if (callback != null) {
                callback.onRewardedVideoAdShowSuccess();
            } else {
                InterstitialAdCallback interstitialAdCallback = (InterstitialAdCallback)this.mIsCallbacks.get(appLovinAd.getZoneId());
                if (interstitialAdCallback != null) {
                    interstitialAdCallback.onInterstitialAdShowSuccess();
                }
            }
        }
    }

    public void adHidden(AppLovinAd appLovinAd) {
        AdLog.getSingleton().LogD("OM-AppLovin", "adHidden:" + appLovinAd);
        if (appLovinAd != null) {
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(appLovinAd.getZoneId());
            if (callback != null) {
                callback.onRewardedVideoAdClosed();
            } else {
                InterstitialAdCallback interstitialAdCallback = (InterstitialAdCallback)this.mIsCallbacks.get(appLovinAd.getZoneId());
                if (interstitialAdCallback != null) {
                    interstitialAdCallback.onInterstitialAdClosed();
                }
            }
        }
    }

    public void videoPlaybackBegan(AppLovinAd appLovinAd) {
        RewardedVideoCallback callback;
        AdLog.getSingleton().LogD("OM-AppLovin", "videoPlaybackBegan:" + appLovinAd);
        if (appLovinAd != null && (callback = (RewardedVideoCallback)this.mRvCallbacks.get(appLovinAd.getZoneId())) != null) {
            callback.onRewardedVideoAdStarted();
        }
    }

    public void videoPlaybackEnded(AppLovinAd appLovinAd, double percentViewed, boolean fullyWatched) {
        RewardedVideoCallback callback;
        AdLog.getSingleton().LogD("OM-AppLovin", "videoPlaybackEnded:" + appLovinAd + ", percentViewed:" + percentViewed + ", fullyWatched:" + fullyWatched);
        if (appLovinAd != null && (callback = (RewardedVideoCallback)this.mRvCallbacks.get(appLovinAd.getZoneId())) != null) {
            callback.onRewardedVideoAdEnded();
            if (fullyWatched) {
                callback.onRewardedVideoAdRewarded();
            }
        }
    }

    static String getErrorString(int errorCode) {
        switch (errorCode) {
            case -102: {
                return "Ad fetch timeout";
            }
            case -300: {
                return "No ad pre-loaded";
            }
            case -500: {
                return "Server timeout";
            }
            case -400: {
                return "Unknown server error";
            }
            case -600: {
                return "User closed video before reward";
            }
            case 204: {
                return "No fill";
            }
            case -103: {
                return "No network available";
            }
            case -6: {
                return "Unable to render ad";
            }
            case -1: {
                return "Unspecified error";
            }
        }
        return "Unknown error";
    }
}

