/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.applovin.adview.AppLovinAdView;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkSettings;
import com.openmediation.sdk.mediation.AdapterErrorBuilder;
import com.openmediation.sdk.mediation.CustomBannerEvent;
import com.openmediation.sdk.mobileads.AppLovinAdapter;
import com.openmediation.sdk.utils.AdLog;
import java.util.Map;

public class AppLovinBanner
extends CustomBannerEvent
implements AppLovinAdLoadListener,
AppLovinAdClickListener,
AppLovinAdDisplayListener {
    private boolean mDidInited = false;
    private AppLovinAdView mAppLovinAdView;
    private AppLovinSdk mAppLovinSdk;
    private static final String TAG = "OM-AppLovin";

    public void setGDPRConsent(Context context, boolean consent) {
        super.setGDPRConsent(context, consent);
        if (context != null) {
            AppLovinPrivacySettings.setHasUserConsent((boolean)consent, (Context)context);
        }
    }

    public void setUserAge(Context context, int age) {
        super.setUserAge(context, age);
        this.setAgeRestricted(context, age < 16);
    }

    public void setAgeRestricted(Context context, boolean restricted) {
        super.setAgeRestricted(context, restricted);
        if (context != null) {
            AppLovinPrivacySettings.setIsAgeRestrictedUser((boolean)restricted, (Context)context);
        }
    }

    public void setUSPrivacyLimit(Context context, boolean value) {
        super.setUSPrivacyLimit(context, value);
        if (context != null) {
            AppLovinPrivacySettings.setDoNotSell((boolean)value, (Context)context);
        }
    }

    public void loadAd(Activity activity, Map<String, String> config) throws Throwable {
        super.loadAd(activity, config);
        if (!this.check(activity, config)) {
            return;
        }
        if (!this.mDidInited) {
            AppLovinSdkSettings settings = new AppLovinSdkSettings(activity.getApplicationContext());
            this.mAppLovinSdk = AppLovinSdk.getInstance((String)config.get("AppKey"), (AppLovinSdkSettings)settings, (Context)activity.getApplicationContext());
            this.mAppLovinSdk.initializeSdk();
            this.mDidInited = true;
        }
        if (this.mAppLovinAdView != null) {
            this.mAppLovinAdView.loadNextAd();
            return;
        }
        AppLovinAdSize adSize = this.getAdSize((Context)activity, config);
        this.mAppLovinAdView = new AppLovinAdView(this.mAppLovinSdk, adSize, this.mInstancesKey, (Context)activity);
        this.mAppLovinAdView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.mAppLovinAdView.setAdLoadListener((AppLovinAdLoadListener)this);
        this.mAppLovinAdView.setAdClickListener((AppLovinAdClickListener)this);
        this.mAppLovinAdView.setAdDisplayListener((AppLovinAdDisplayListener)this);
        this.mAppLovinAdView.loadNextAd();
    }

    public int getMediation() {
        return 8;
    }

    public void destroy(Activity activity) {
        if (this.mAppLovinAdView != null) {
            this.mAppLovinAdView.destroy();
            this.mAppLovinAdView = null;
        }
        this.isDestroyed = true;
    }

    public void adClicked(AppLovinAd ad) {
        if (this.isDestroyed) {
            return;
        }
        AdLog.getSingleton().LogD(TAG, "AppLovin Banner ad clicked ");
        this.onInsClicked();
    }

    public void adReceived(AppLovinAd ad) {
        if (this.isDestroyed) {
            return;
        }
        AdLog.getSingleton().LogD(TAG, "AppLovin Banner ad load success ");
        this.onInsReady(this.mAppLovinAdView);
    }

    public void failedToReceiveAd(int errorCode) {
        if (this.isDestroyed) {
            return;
        }
        this.onInsError(AdapterErrorBuilder.buildLoadError((String)"Banner", (String)this.mAdapterName, (int)errorCode, (String)AppLovinAdapter.getErrorString(errorCode)));
    }

    public void adDisplayed(AppLovinAd ad) {
    }

    public void adHidden(AppLovinAd ad) {
    }

    private AppLovinAdSize getAdSize(Context context, Map<String, String> config) {
        String bannerDesc;
        switch (bannerDesc = this.getBannerDesc(config)) {
            case "LEADERBOARD": {
                return AppLovinAdSize.LEADER;
            }
            case "RECTANGLE": {
                return AppLovinAdSize.MREC;
            }
            case "SMART": {
                if (AppLovinBanner.isLargeScreen((Context)context)) {
                    return AppLovinAdSize.LEADER;
                }
                return AppLovinAdSize.BANNER;
            }
        }
        return AppLovinAdSize.BANNER;
    }
}

