/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkSettings;
import com.openmediation.sdk.mediation.CustomAdsAdapter;
import com.openmediation.sdk.mediation.InterstitialAdCallback;
import com.openmediation.sdk.mediation.RewardedVideoCallback;
import com.openmediation.sdk.utils.AdLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AppLovinAdapter
extends CustomAdsAdapter
implements AppLovinAdVideoPlaybackListener,
AppLovinAdDisplayListener,
AppLovinAdClickListener {
    private boolean mDidInited = false;
    private AppLovinSdk mAppLovinSDk;
    private ConcurrentMap<String, AppLovinInterstitialAdDialog> mIsAds = new ConcurrentHashMap<String, AppLovinInterstitialAdDialog>();
    private ConcurrentMap<String, AppLovinAd> mAppLovinIsAds = new ConcurrentHashMap<String, AppLovinAd>();
    private ConcurrentMap<String, InterstitialAdCallback> mIsCallbacks = new ConcurrentHashMap<String, InterstitialAdCallback>();
    private ConcurrentMap<String, AppLovinIncentivizedInterstitial> mRvAds = new ConcurrentHashMap<String, AppLovinIncentivizedInterstitial>();
    private ConcurrentMap<String, RewardedVideoCallback> mRvCallbacks = new ConcurrentHashMap<String, RewardedVideoCallback>();

    public String getMediationVersion() {
        return AppLovinSdk.VERSION;
    }

    public String getAdapterVersion() {
        return "1.2.0";
    }

    public int getAdNetworkId() {
        return 8;
    }

    public void initRewardedVideo(Activity activity, Map<String, Object> dataMap, RewardedVideoCallback callback) {
        super.initRewardedVideo(activity, dataMap, callback);
        AdLog.getSingleton().LogD("AppLovinAdapter", "initsdk:" + this.mAppKey);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.initSDK(activity);
            if (this.mDidInited) {
                callback.onRewardedVideoInitSuccess();
            }
        } else if (callback != null) {
            callback.onRewardedVideoInitFailed(error);
        }
    }

    private synchronized void initSDK(Activity activity) {
        if (!this.mDidInited) {
            AdLog.getSingleton().LogD("AppLovinAdapter", "initsdk:" + this.mAppKey);
            AppLovinSdk lovinSdk = AppLovinSdk.getInstance((String)this.mAppKey, (AppLovinSdkSettings)new AppLovinSdkSettings(activity.getApplicationContext()), (Context)activity.getApplicationContext());
            if (lovinSdk == null) {
                return;
            }
            this.mAppLovinSDk = lovinSdk;
            lovinSdk.initializeSdk();
            this.mDidInited = true;
        }
    }

    private AppLovinIncentivizedInterstitial getVideo(Activity activity, String adUnitId) {
        AppLovinIncentivizedInterstitial videoAd = (AppLovinIncentivizedInterstitial)this.mRvAds.get(adUnitId);
        if (videoAd == null) {
            AppLovinSdk lovinSdk = AppLovinSdk.getInstance((String)this.mAppKey, (AppLovinSdkSettings)new AppLovinSdkSettings(), (Context)activity);
            if (lovinSdk == null) {
                return null;
            }
            videoAd = AppLovinIncentivizedInterstitial.create((String)adUnitId, (AppLovinSdk)lovinSdk);
            this.mRvAds.put(adUnitId, videoAd);
        }
        return videoAd;
    }

    public void loadRewardedVideo(Activity activity, String adUnitId, final RewardedVideoCallback callback) {
        super.loadRewardedVideo(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)error)) {
            AppLovinIncentivizedInterstitial videoAd = this.getVideo(activity, adUnitId);
            if (videoAd == null) {
                callback.onRewardedVideoLoadFailed("onRewardedVideoLoadFailed");
            } else if (videoAd.isAdReadyToDisplay()) {
                if (callback != null) {
                    callback.onRewardedVideoLoadSuccess();
                }
            } else {
                videoAd.preload(new AppLovinAdLoadListener(){

                    public void adReceived(AppLovinAd appLovinAd) {
                        AdLog.getSingleton().LogD("AppLovinAdapter", "adReceived:" + appLovinAd);
                        if (appLovinAd != null && callback != null) {
                            callback.onRewardedVideoLoadSuccess();
                        }
                    }

                    public void failedToReceiveAd(int i) {
                        AdLog.getSingleton().LogE("AppLovinAdapter: failedToReceiveAd:" + i);
                        if (callback != null) {
                            callback.onRewardedVideoLoadFailed("failedToReceiveAd:" + i);
                        }
                    }
                });
                this.mRvCallbacks.put(adUnitId, callback);
            }
        } else if (callback != null) {
            callback.onRewardedVideoLoadFailed(error);
        }
    }

    public void showRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.showRewardedVideo(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onRewardedVideoAdShowFailed(error);
            }
            return;
        }
        AppLovinIncentivizedInterstitial videoAd = this.getVideo(activity, adUnitId);
        if (videoAd == null) {
            if (callback != null) {
                callback.onRewardedVideoAdShowFailed("applovin video get fail when show");
            }
        } else {
            if (!this.isRewardedVideoAvailable(adUnitId)) {
                if (callback != null) {
                    callback.onRewardedVideoAdShowFailed("applovin video not ready when show");
                }
                return;
            }
            videoAd.show((Context)activity, null, (AppLovinAdVideoPlaybackListener)this, (AppLovinAdDisplayListener)this, (AppLovinAdClickListener)this);
        }
    }

    public boolean isRewardedVideoAvailable(String adUnitId) {
        AppLovinIncentivizedInterstitial videoAd = (AppLovinIncentivizedInterstitial)this.mRvAds.get(adUnitId);
        return videoAd != null && videoAd.isAdReadyToDisplay();
    }

    public void initInterstitialAd(Activity activity, Map<String, Object> dataMap, InterstitialAdCallback callback) {
        super.initInterstitialAd(activity, dataMap, callback);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.initSDK(activity);
            if (this.mDidInited) {
                AppLovinInterstitialAdDialog interstitialAd = AppLovinInterstitialAd.create((AppLovinSdk)this.mAppLovinSDk, (Context)activity);
                String pid = (String)dataMap.get("pid");
                if (!TextUtils.isEmpty((CharSequence)pid)) {
                    this.mIsAds.put(pid, interstitialAd);
                    this.mIsCallbacks.put(pid, callback);
                    interstitialAd.setAdClickListener((AppLovinAdClickListener)this);
                    interstitialAd.setAdDisplayListener((AppLovinAdDisplayListener)this);
                }
                if (callback != null) {
                    callback.onInterstitialAdInitSuccess();
                }
            }
        } else if (callback != null) {
            callback.onInterstitialAdInitFailed(error);
        }
    }

    public void loadInterstitialAd(Activity activity, final String adUnitId, final InterstitialAdCallback callback) {
        super.loadInterstitialAd(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)error)) {
            if (this.mAppLovinSDk != null) {
                this.mAppLovinSDk.getAdService().loadNextAdForZoneId(adUnitId, new AppLovinAdLoadListener(){

                    public void adReceived(AppLovinAd appLovinAd) {
                        if (appLovinAd != null) {
                            AppLovinAdapter.this.mAppLovinIsAds.put(adUnitId, appLovinAd);
                            if (callback != null) {
                                callback.onInterstitialAdLoadSuccess();
                            }
                        }
                    }

                    public void failedToReceiveAd(int i) {
                        AdLog.getSingleton().LogE("Om-AppLovin: AppLovin interstitial ad load failed : " + i);
                        if (callback != null) {
                            callback.onInterstitialAdLoadFailed("Om-");
                        }
                    }
                });
            }
        } else if (callback != null) {
            callback.onInterstitialAdLoadFailed(error);
        }
    }

    public void showInterstitialAd(Activity activity, String adUnitId, InterstitialAdCallback callback) {
        super.showInterstitialAd(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (!TextUtils.isEmpty((CharSequence)error)) {
            if (callback != null) {
                callback.onInterstitialAdShowFailed(error);
            }
            return;
        }
        if (this.isInterstitialAdAvailable(adUnitId)) {
            AppLovinInterstitialAdDialog adDialog = (AppLovinInterstitialAdDialog)this.mIsAds.get(adUnitId);
            if (adDialog != null) {
                adDialog.showAndRender((AppLovinAd)this.mAppLovinIsAds.get(adUnitId));
                this.mAppLovinIsAds.remove(adUnitId);
            }
        } else if (callback != null) {
            callback.onInterstitialAdShowFailed("AppLovin Interstitial ad is not ready to show");
        }
    }

    public boolean isInterstitialAdAvailable(String adUnitId) {
        AppLovinInterstitialAdDialog adDialog = (AppLovinInterstitialAdDialog)this.mIsAds.get(adUnitId);
        return adDialog != null && this.mAppLovinIsAds.containsKey(adUnitId);
    }

    public void adClicked(AppLovinAd appLovinAd) {
        AdLog.getSingleton().LogD("AppLovinAdapter", "adClicked:" + appLovinAd);
        if (appLovinAd != null) {
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(appLovinAd.getZoneId());
            if (callback != null) {
                callback.onRewardedVideoAdClicked();
            } else {
                InterstitialAdCallback interstitialAdCallback = (InterstitialAdCallback)this.mIsCallbacks.get(appLovinAd.getZoneId());
                if (interstitialAdCallback != null) {
                    interstitialAdCallback.onInterstitialAdClick();
                }
            }
        }
    }

    public void adDisplayed(AppLovinAd appLovinAd) {
        AdLog.getSingleton().LogD("AppLovinAdapter", "adDisplayed:" + appLovinAd);
        if (appLovinAd != null) {
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(appLovinAd.getZoneId());
            if (callback != null) {
                callback.onRewardedVideoAdShowSuccess();
            } else {
                InterstitialAdCallback interstitialAdCallback = (InterstitialAdCallback)this.mIsCallbacks.get(appLovinAd.getZoneId());
                if (interstitialAdCallback != null) {
                    interstitialAdCallback.onInterstitialAdShowSuccess();
                }
            }
        }
    }

    public void adHidden(AppLovinAd appLovinAd) {
        AdLog.getSingleton().LogD("AppLovinAdapter", "adHidden:" + appLovinAd);
        if (appLovinAd != null) {
            RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallbacks.get(appLovinAd.getZoneId());
            if (callback != null) {
                callback.onRewardedVideoAdClosed();
            } else {
                InterstitialAdCallback interstitialAdCallback = (InterstitialAdCallback)this.mIsCallbacks.get(appLovinAd.getZoneId());
                if (interstitialAdCallback != null) {
                    interstitialAdCallback.onInterstitialAdClosed();
                }
            }
        }
    }

    public void videoPlaybackBegan(AppLovinAd appLovinAd) {
        RewardedVideoCallback callback;
        AdLog.getSingleton().LogD("AppLovinAdapter", "videoPlaybackBegan:" + appLovinAd);
        if (appLovinAd != null && (callback = (RewardedVideoCallback)this.mRvCallbacks.get(appLovinAd.getZoneId())) != null) {
            callback.onRewardedVideoAdStarted();
        }
    }

    public void videoPlaybackEnded(AppLovinAd appLovinAd, double percentViewed, boolean fullyWatched) {
        RewardedVideoCallback callback;
        AdLog.getSingleton().LogD("AppLovinAdapter", "videoPlaybackEnded:" + appLovinAd + ", percentViewed:" + percentViewed + ", fullyWatched:" + fullyWatched);
        if (appLovinAd != null && (callback = (RewardedVideoCallback)this.mRvCallbacks.get(appLovinAd.getZoneId())) != null) {
            callback.onRewardedVideoAdEnded();
            if (fullyWatched) {
                callback.onRewardedVideoAdRewarded();
            }
        }
    }
}

