/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;
import com.adcolony.sdk.AdColony;
import com.adcolony.sdk.AdColonyInterstitial;
import com.adcolony.sdk.AdColonyInterstitialListener;
import com.adcolony.sdk.AdColonyReward;
import com.adcolony.sdk.AdColonyRewardListener;
import com.adcolony.sdk.AdColonyZone;
import com.openmediation.sdk.mediation.CustomAdsAdapter;
import com.openmediation.sdk.mediation.RewardedVideoCallback;
import com.openmediation.sdk.utils.AdLog;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AdColonyAdapter
extends CustomAdsAdapter
implements AdColonyRewardListener {
    private boolean mDidInited = false;
    private ConcurrentMap<String, RewardedVideoCallback> mRvCallback = new ConcurrentHashMap<String, RewardedVideoCallback>();
    private ConcurrentHashMap<String, AdColonyInterstitial> mAdColonyAds = new ConcurrentHashMap();

    public String getMediationVersion() {
        return AdColony.getSDKVersion();
    }

    public String getAdapterVersion() {
        return "1.2.0";
    }

    public int getAdNetworkId() {
        return 7;
    }

    public void initRewardedVideo(Activity activity, Map<String, Object> dataMap, RewardedVideoCallback callback) {
        super.initRewardedVideo(activity, dataMap, callback);
        String error = this.check(activity);
        if (TextUtils.isEmpty((CharSequence)error)) {
            this.initAdColony(activity, dataMap);
            if (callback != null) {
                callback.onRewardedVideoInitSuccess();
            }
        } else if (callback != null) {
            callback.onRewardedVideoInitFailed(error);
        }
    }

    public void loadRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.loadRewardedVideo(activity, adUnitId, callback);
        String error = this.check(activity, adUnitId);
        if (TextUtils.isEmpty((CharSequence)error)) {
            AdColonyInterstitial rvAd = this.mAdColonyAds.get(adUnitId);
            this.mRvCallback.put(adUnitId, callback);
            if (rvAd == null || rvAd.isExpired()) {
                AdColony.setRewardListener((AdColonyRewardListener)this);
                AdColony.requestInterstitial((String)adUnitId, (AdColonyInterstitialListener)new AdColonyAdListener());
            } else if (!rvAd.isExpired()) {
                callback.onRewardedVideoLoadSuccess();
            }
        } else {
            callback.onRewardedVideoLoadFailed(error);
        }
    }

    public void showRewardedVideo(Activity activity, String adUnitId, RewardedVideoCallback callback) {
        super.showRewardedVideo(activity, adUnitId, callback);
        if (this.isRewardedVideoAvailable(adUnitId)) {
            AdColonyInterstitial interstitial = this.mAdColonyAds.get(adUnitId);
            if (interstitial != null) {
                interstitial.show();
            } else if (callback != null) {
                callback.onRewardedVideoAdShowFailed("AdColony ad not ready");
            }
        } else {
            AdLog.getSingleton().LogE("Om-AdColony: AdColony ad not ready");
            if (callback != null) {
                callback.onRewardedVideoAdShowFailed("AdColony ad not ready");
            }
        }
    }

    public boolean isRewardedVideoAvailable(String adUnitId) {
        try {
            if (TextUtils.isEmpty((CharSequence)adUnitId)) {
                return false;
            }
            AdColonyInterstitial interstitial = this.mAdColonyAds.get(adUnitId);
            return interstitial != null && !interstitial.isExpired();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private synchronized void initAdColony(Activity activity, Map<String, Object> dataMap) {
        if (!this.mDidInited) {
            List idList = null;
            if (dataMap.get("zoneIds") instanceof List) {
                idList = (List)dataMap.get("zoneIds");
            }
            if (idList != null) {
                String[] zoneIds = idList.toArray(new String[idList.size()]);
                AdColony.configure((Application)activity.getApplication(), (String)this.mAppKey, (String[])zoneIds);
            } else {
                AdColony.configure((Application)activity.getApplication(), (String)this.mAppKey, (String[])new String[0]);
            }
            this.mDidInited = true;
        }
    }

    public void onReward(AdColonyReward adColonyReward) {
        RewardedVideoCallback callback = (RewardedVideoCallback)this.mRvCallback.get(adColonyReward.getZoneID());
        if (adColonyReward.success() && callback != null) {
            callback.onRewardedVideoAdRewarded();
        }
    }

    private class AdColonyAdListener
    extends AdColonyInterstitialListener {
        private AdColonyAdListener() {
        }

        public void onRequestFilled(AdColonyInterstitial var1) {
            AdColonyAdapter.this.mAdColonyAds.put(var1.getZoneID(), var1);
            RewardedVideoCallback callback = (RewardedVideoCallback)AdColonyAdapter.this.mRvCallback.get(var1.getZoneID());
            if (callback != null) {
                callback.onRewardedVideoLoadSuccess();
            }
        }

        public void onRequestNotFilled(AdColonyZone zone) {
            RewardedVideoCallback callback = (RewardedVideoCallback)AdColonyAdapter.this.mRvCallback.get(zone.getZoneID());
            if (callback != null) {
                callback.onRewardedVideoLoadFailed("AdColony ad not filled");
            }
        }

        public void onOpened(AdColonyInterstitial ad) {
            RewardedVideoCallback callback = (RewardedVideoCallback)AdColonyAdapter.this.mRvCallback.get(ad.getZoneID());
            if (callback != null) {
                callback.onRewardedVideoAdShowSuccess();
                callback.onRewardedVideoAdStarted();
            }
        }

        public void onClosed(AdColonyInterstitial ad) {
            RewardedVideoCallback callback = (RewardedVideoCallback)AdColonyAdapter.this.mRvCallback.get(ad.getZoneID());
            if (callback != null) {
                callback.onRewardedVideoAdEnded();
                callback.onRewardedVideoAdClosed();
            }
        }

        public void onExpiring(AdColonyInterstitial ad) {
            AdColony.requestInterstitial((String)ad.getZoneID(), (AdColonyInterstitialListener)this);
        }

        public void onClicked(AdColonyInterstitial ad) {
            RewardedVideoCallback callback = (RewardedVideoCallback)AdColonyAdapter.this.mRvCallback.get(ad.getZoneID());
            if (callback != null) {
                callback.onRewardedVideoAdClicked();
            }
        }
    }
}

