/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.content.Context;
import com.facebook.bidding.FBAdBidFormat;
import com.facebook.bidding.FBAdBidRequest;
import com.facebook.bidding.FBAdBidResponse;
import com.openmediation.sdk.bid.AdTimingBidResponse;
import com.openmediation.sdk.bid.BidAdapter;
import com.openmediation.sdk.bid.BidCallback;
import com.openmediation.sdk.utils.AdLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FacebookBidAdapter
extends BidAdapter {
    private static final String CLAZZ = "com.facebook.bidding.FBAdBidRequest";
    private ConcurrentHashMap<String, FBAdBidResponse> mFbBidResponses = new ConcurrentHashMap();

    public void executeBid(Context context, Map<String, Object> dataMap, BidCallback callback) {
        block2: {
            super.executeBid(context, dataMap, callback);
            try {
                Class<?> clazz = Class.forName(CLAZZ);
                String placementId = (String)dataMap.get("placement_id");
                int bidAdType = (Integer)dataMap.get("ad_type");
                String appKey = (String)dataMap.get("app_key");
                FBAdBidRequest bidRequest = new FBAdBidRequest(context, appKey, placementId, this.getBidFormat(bidAdType));
                bidRequest.getFBBid((FBAdBidRequest.BidResponseCallback)new FbBidResCallback(callback));
            }
            catch (ClassNotFoundException e) {
                AdLog.getSingleton().LogE("Facebook bid sdk not been integrated");
                if (callback == null) break block2;
                callback.bidFailed("Facebook bid sdk not integrated");
            }
        }
    }

    public void notifyWin(String placementId) {
        FBAdBidResponse bidResponse;
        super.notifyWin(placementId);
        if (this.mFbBidResponses.containsKey(placementId) && (bidResponse = this.mFbBidResponses.get(placementId)) != null) {
            bidResponse.notifyWin();
        }
    }

    public void notifyLose(String placementId) {
        FBAdBidResponse bidResponse;
        super.notifyLose(placementId);
        if (this.mFbBidResponses.containsKey(placementId) && (bidResponse = this.mFbBidResponses.get(placementId)) != null) {
            bidResponse.notifyLoss();
        }
    }

    private FBAdBidFormat getBidFormat(int adType) {
        switch (adType) {
            case 0: {
                return FBAdBidFormat.BANNER_320_50;
            }
            case 1: {
                return FBAdBidFormat.NATIVE;
            }
            case 3: {
                return FBAdBidFormat.INTERSTITIAL;
            }
            case 2: {
                return FBAdBidFormat.REWARDED_VIDEO;
            }
        }
        return null;
    }

    private class FbBidResCallback
    implements FBAdBidRequest.BidResponseCallback {
        private BidCallback mCallback;

        FbBidResCallback(BidCallback callback) {
            this.mCallback = callback;
        }

        public void handleBidResponse(FBAdBidResponse fbAdBidResponse) {
            if (fbAdBidResponse == null) {
                if (this.mCallback != null) {
                    this.mCallback.bidFailed("Facebook bid response return null");
                }
                return;
            }
            if (fbAdBidResponse.isSuccess().booleanValue()) {
                FacebookBidAdapter.this.mFbBidResponses.put(fbAdBidResponse.getPlacementId(), fbAdBidResponse);
                AdTimingBidResponse response = new AdTimingBidResponse();
                response.setOriginal(fbAdBidResponse.toString());
                response.setCur(fbAdBidResponse.getCurrency());
                response.setPrice(fbAdBidResponse.getPrice());
                response.setPayLoad(fbAdBidResponse.getPayload());
                if (this.mCallback != null) {
                    this.mCallback.bidSuccess(response);
                }
            } else {
                if (fbAdBidResponse.getPlacementId() != null) {
                    FacebookBidAdapter.this.mFbBidResponses.remove(fbAdBidResponse.getPlacementId());
                }
                if (this.mCallback != null) {
                    this.mCallback.bidFailed(fbAdBidResponse.getErrorMessage());
                }
            }
        }
    }
}

