/*
 * Decompiled with CFR 0.152.
 */
package com.openmediation.sdk.mobileads;

import android.app.Activity;
import android.content.Context;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.AudienceNetworkAds;
import com.openmediation.sdk.mediation.CustomBannerEvent;
import com.openmediation.sdk.utils.AdLog;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class FacebookBanner
extends CustomBannerEvent
implements AdListener {
    private static final String PAY_LOAD = "pay_load";
    private AtomicBoolean mDidCallInit = new AtomicBoolean(false);
    private AdView adView;

    public void loadAd(Activity activity, Map<String, String> config) throws Throwable {
        super.loadAd(activity, config);
        if (!this.check(activity, config)) {
            return;
        }
        this.initSdk(activity);
        if (this.adView != null) {
            this.adView.loadAd();
            return;
        }
        AdSize adSize = AdSize.BANNER_HEIGHT_50;
        this.adView = new AdView(activity.getApplicationContext(), this.mInstancesKey, adSize);
        AdView.AdViewLoadConfigBuilder loadConfigBuilder = this.adView.buildLoadAdConfig();
        if (config.containsKey(PAY_LOAD)) {
            loadConfigBuilder.withBid(config.get(PAY_LOAD));
        }
        loadConfigBuilder.withAdListener((AdListener)this);
        this.adView.loadAd(loadConfigBuilder.build());
    }

    public int getMediation() {
        return 3;
    }

    public void destroy(Activity activity) {
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
        this.isDestroyed = true;
    }

    public void onError(Ad ad, AdError adError) {
        if (this.isDestroyed) {
            return;
        }
        AdLog.getSingleton().LogE("Om-Facebook: Facebook Banner ad load failed " + adError.getErrorMessage());
        this.onInsError(adError.getErrorMessage());
    }

    public void onAdLoaded(Ad ad) {
        if (this.isDestroyed) {
            return;
        }
        AdLog.getSingleton().LogD("Om-Facebook", "Facebook Banner ad load success ");
        this.onInsReady(this.adView);
    }

    public void onAdClicked(Ad ad) {
        if (this.isDestroyed) {
            return;
        }
        this.onInsClicked();
    }

    public void onLoggingImpression(Ad ad) {
    }

    private void initSdk(Activity activity) {
        AdSettings.setIntegrationErrorMode((AdSettings.IntegrationErrorMode)AdSettings.IntegrationErrorMode.INTEGRATION_ERROR_CALLBACK_MODE);
        if (this.mDidCallInit.compareAndSet(false, true)) {
            if (AudienceNetworkAds.isInAdsProcess((Context)activity.getApplicationContext())) {
                return;
            }
            AudienceNetworkAds.buildInitSettings((Context)activity.getApplicationContext()).withInitListener(new AudienceNetworkAds.InitListener(){

                public void onInitialized(AudienceNetworkAds.InitResult result) {
                }
            }).initialize();
        }
    }
}

