/*
 * Decompiled with CFR 0.152.
 */
package com.adsamcik.recycler;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.util.TypedValue;
import androidx.annotation.ColorInt;
import com.adsamcik.recycler.R;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J'\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/adsamcik/recycler/Util;", "", "()V", "dp", "", "getDp$recycler_release", "(I)I", "formatNumber", "", "number", "formatNumber$recycler_release", "getAccentColor", "context", "Landroid/content/Context;", "getAccentColor$recycler_release", "getColorDrawableFromColor", "Landroid/graphics/drawable/ColorDrawable;", "color", "getPressedColorRippleDrawable", "Landroid/graphics/drawable/RippleDrawable;", "normalColor", "pressedColor", "mask", "Landroid/graphics/drawable/Drawable;", "getPressedColorRippleDrawable$recycler_release", "getPressedColorSelector", "Landroid/content/res/ColorStateList;", "recycler_release"})
public final class Util {
    public static final Util INSTANCE;

    public final int getDp$recycler_release(int $this$dp) {
        float f = $this$dp;
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return (int)(f * resources.getDisplayMetrics().density);
    }

    @NotNull
    public final RippleDrawable getPressedColorRippleDrawable$recycler_release(int normalColor, int pressedColor, @Nullable Drawable mask) {
        return new RippleDrawable(this.getPressedColorSelector(pressedColor), (Drawable)(normalColor == 0 ? null : this.getColorDrawableFromColor(normalColor)), mask);
    }

    private final ColorStateList getPressedColorSelector(int pressedColor) {
        return new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{pressedColor});
    }

    private final ColorDrawable getColorDrawableFromColor(int color) {
        return new ColorDrawable(color);
    }

    @ColorInt
    public final int getAccentColor$recycler_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorAccent, typedValue, true);
        return typedValue.data;
    }

    @NotNull
    public final String formatNumber$recycler_release(int number) {
        DecimalFormat df = new DecimalFormat("#,###,###");
        String string = df.format(number);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"df.format(number.toLong())");
        return string;
    }

    private Util() {
    }

    static {
        Util util;
        INSTANCE = util = new Util();
    }
}

