/*
 * Decompiled with CFR 0.152.
 */
package com.adsamcik.recycler.adapter.implementation.sortable;

import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SortedList;
import com.adsamcik.recycler.adapter.abstraction.MutableAdapter;
import com.adsamcik.recycler.adapter.abstraction.ReadableAdapter;
import com.adsamcik.recycler.adapter.implementation.sortable.AppendPriority;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u00052\b\u0012\u0004\u0012\u0002H\u00010\u0006:\u0002%&B\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\nJ\u0016\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0016J!\u0010\u0013\u001a\u00020\f2\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\u0015H\u0007\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001aH\u0016J\u0015\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010 \u001a\u00020\fH\u0016J\u0015\u0010!\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\"\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/adsamcik/recycler/adapter/implementation/sortable/SortableAdapter;", "Data", "VH", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/adsamcik/recycler/adapter/abstraction/ReadableAdapter;", "Lcom/adsamcik/recycler/adapter/abstraction/MutableAdapter;", "()V", "dataList", "Landroidx/recyclerview/widget/SortedList;", "Lcom/adsamcik/recycler/adapter/implementation/sortable/SortableAdapter$SortableData;", "add", "", "data", "(Ljava/lang/Object;)V", "element", "priority", "Lcom/adsamcik/recycler/adapter/implementation/sortable/AppendPriority;", "(Ljava/lang/Object;Lcom/adsamcik/recycler/adapter/implementation/sortable/AppendPriority;)V", "addAll", "collection", "", "list", "addAllSortable", "getItem", "index", "", "(I)Ljava/lang/Object;", "getItemCount", "indexOf", "(Ljava/lang/Object;)I", "remove", "removeAll", "removeAt", "updateAt", "value", "(ILjava/lang/Object;)V", "SortableData", "SortedListCallback", "recycler_release"})
public abstract class SortableAdapter<Data, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH>
implements ReadableAdapter<Data>,
MutableAdapter<Data> {
    private final SortedList<SortableData<?>> dataList = new SortedList(SortableData.class, (SortedList.Callback)new SortedListCallback());

    public int getItemCount() {
        return this.dataList.size();
    }

    public final void add(Data element, @NotNull AppendPriority priority) {
        Intrinsics.checkParameterIsNotNull((Object)priority, (String)"priority");
        this.add((Data)new SortableData<Data>(element, priority));
    }

    @Override
    public final void add(@NotNull SortableData<Data> data) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this.dataList.add(data);
    }

    @Override
    public void add(Data data) {
        this.add(data, AppendPriority.Companion.getAny());
    }

    @JvmName(name="addAllSortable")
    public final void addAllSortable(@NotNull Collection<SortableData<Data>> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        this.dataList.addAll(list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addAll(@NotNull Collection<? extends Data> collection) {
        Collection collection2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(collection, (String)"collection");
        Iterable iterable = collection;
        SortableAdapter sortableAdapter = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection2 = destination$iv$iv;
            boolean bl = false;
            SortableData sortableData = new SortableData(it, null, 2, null);
            collection2.add(sortableData);
        }
        collection2 = (List)destination$iv$iv;
        sortableAdapter.addAllSortable(collection2);
    }

    @Override
    public void removeAll() {
        this.dataList.clear();
    }

    @Override
    public void remove(Data data) {
        int index = this.indexOf(data);
        if (index >= 0) {
            this.dataList.removeItemAt(index);
        }
    }

    @Override
    public Data removeAt(int index) {
        return ((SortableData)this.dataList.removeItemAt(index)).getData();
    }

    @Override
    public void updateAt(int index, Data value) {
        SortableData originalItem = (SortableData)this.dataList.get(index);
        SortableData<Data> newItem = new SortableData<Data>(value, originalItem.getPriority());
        this.dataList.updateItemAt(index, newItem);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int indexOf(Data data) {
        int size = this.dataList.size();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            if (Intrinsics.areEqual(((SortableData)this.dataList.get((int)i)).getData(), data)) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Data getItem(int index) {
        return ((SortableData)this.dataList.get(index)).getData();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/adsamcik/recycler/adapter/implementation/sortable/SortableAdapter$SortableData;", "Data", "", "data", "priority", "Lcom/adsamcik/recycler/adapter/implementation/sortable/AppendPriority;", "(Ljava/lang/Object;Lcom/adsamcik/recycler/adapter/implementation/sortable/AppendPriority;)V", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getPriority", "()Lcom/adsamcik/recycler/adapter/implementation/sortable/AppendPriority;", "component1", "component2", "copy", "(Ljava/lang/Object;Lcom/adsamcik/recycler/adapter/implementation/sortable/AppendPriority;)Lcom/adsamcik/recycler/adapter/implementation/sortable/SortableAdapter$SortableData;", "equals", "", "other", "hashCode", "", "toString", "", "recycler_release"})
    public static final class SortableData<Data> {
        private final Data data;
        @NotNull
        private final AppendPriority priority;

        public final Data getData() {
            return this.data;
        }

        @NotNull
        public final AppendPriority getPriority() {
            return this.priority;
        }

        public SortableData(Data data, @NotNull AppendPriority priority) {
            Intrinsics.checkParameterIsNotNull((Object)priority, (String)"priority");
            this.data = data;
            this.priority = priority;
        }

        public /* synthetic */ SortableData(Object object, AppendPriority appendPriority, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                appendPriority = AppendPriority.Companion.getAny();
            }
            this(object, appendPriority);
        }

        public final Data component1() {
            return this.data;
        }

        @NotNull
        public final AppendPriority component2() {
            return this.priority;
        }

        @NotNull
        public final SortableData<Data> copy(Data data, @NotNull AppendPriority priority) {
            Intrinsics.checkParameterIsNotNull((Object)priority, (String)"priority");
            return new SortableData<Data>(data, priority);
        }

        public static /* synthetic */ SortableData copy$default(SortableData sortableData, Object object, AppendPriority appendPriority, int n, Object object2) {
            if ((n & 1) != 0) {
                object = sortableData.data;
            }
            if ((n & 2) != 0) {
                appendPriority = sortableData.priority;
            }
            return sortableData.copy(object, appendPriority);
        }

        @NotNull
        public String toString() {
            return "SortableData(data=" + this.data + ", priority=" + this.priority + ")";
        }

        public int hashCode() {
            Data Data = this.data;
            AppendPriority appendPriority = this.priority;
            return (Data != null ? Data.hashCode() : 0) * 31 + (appendPriority != null ? ((Object)appendPriority).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SortableData)) break block3;
                    SortableData sortableData = (SortableData)object;
                    if (!Intrinsics.areEqual(this.data, sortableData.data) || !Intrinsics.areEqual((Object)this.priority, (Object)sortableData.priority)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J \u0010\b\u001a\u00020\u00052\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J \u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/adsamcik/recycler/adapter/implementation/sortable/SortableAdapter$SortedListCallback;", "Landroidx/recyclerview/widget/SortedList$Callback;", "Lcom/adsamcik/recycler/adapter/implementation/sortable/SortableAdapter$SortableData;", "(Lcom/adsamcik/recycler/adapter/implementation/sortable/SortableAdapter;)V", "areContentsTheSame", "", "oldItem", "newItem", "areItemsTheSame", "item1", "item2", "compare", "", "o1", "o2", "onChanged", "", "position", "count", "onInserted", "onMoved", "fromPosition", "toPosition", "onRemoved", "recycler_release"})
    private final class SortedListCallback
    extends SortedList.Callback<SortableData<?>> {
        public boolean areItemsTheSame(@NotNull SortableData<?> item1, @NotNull SortableData<?> item2) {
            Intrinsics.checkParameterIsNotNull(item1, (String)"item1");
            Intrinsics.checkParameterIsNotNull(item2, (String)"item2");
            return Intrinsics.areEqual(item1.getData(), item2.getData());
        }

        public void onMoved(int fromPosition, int toPosition) {
            SortableAdapter.this.notifyItemMoved(fromPosition, toPosition);
        }

        public void onChanged(int position, int count) {
            if (count == 1) {
                SortableAdapter.this.notifyItemChanged(position);
            } else {
                SortableAdapter.this.notifyItemRangeChanged(position, count);
            }
        }

        public void onInserted(int position, int count) {
            if (count == 1) {
                SortableAdapter.this.notifyItemInserted(position);
            } else {
                SortableAdapter.this.notifyItemRangeInserted(position, count);
            }
        }

        public void onRemoved(int position, int count) {
            if (count == 1) {
                SortableAdapter.this.notifyItemRemoved(position);
            } else {
                SortableAdapter.this.notifyItemRangeRemoved(position, count);
            }
        }

        public int compare(@NotNull SortableData<?> o1, @NotNull SortableData<?> o2) {
            Intrinsics.checkParameterIsNotNull(o1, (String)"o1");
            Intrinsics.checkParameterIsNotNull(o2, (String)"o2");
            return o1.getPriority().getBehavior() == o2.getPriority().getBehavior() ? o1.getPriority().getPriority() - o2.getPriority().getPriority() : o1.getPriority().getBehavior().ordinal() - o2.getPriority().getBehavior().ordinal();
        }

        public boolean areContentsTheSame(@NotNull SortableData<?> oldItem, @NotNull SortableData<?> newItem) {
            Intrinsics.checkParameterIsNotNull(oldItem, (String)"oldItem");
            Intrinsics.checkParameterIsNotNull(newItem, (String)"newItem");
            return Intrinsics.areEqual(oldItem.getData(), newItem.getData());
        }
    }
}

