/*
 * Decompiled with CFR 0.152.
 */
package com.adsamcik.recycler.card.table;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import androidx.annotation.StyleRes;
import androidx.cardview.widget.CardView;
import androidx.core.graphics.ColorUtils;
import com.adsamcik.recycler.R;
import com.adsamcik.recycler.Util;
import com.adsamcik.recycler.ViewHolderCreator;
import com.adsamcik.recycler.card.table.TableCard;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0002J>\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J>\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001d\u001a\u00020\u00052\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0002J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0003H\u0002J \u0010$\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0012H\u0002J\b\u0010(\u001a\u00020\u0005H\u0016J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\nH\u0002J \u0010+\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/adsamcik/recycler/card/table/TableCardCreator;", "Lcom/adsamcik/recycler/ViewHolderCreator;", "Lcom/adsamcik/recycler/card/table/TableCard$ViewHolder;", "Lcom/adsamcik/recycler/card/table/TableCard;", "theme", "", "(I)V", "dividerColor", "createView", "parent", "Landroidx/cardview/widget/CardView;", "viewType", "generateButton", "Landroid/widget/TextView;", "context", "Landroid/content/Context;", "button", "Landroid/util/Pair;", "", "Landroid/view/View$OnClickListener;", "generateButtonsRow", "Landroid/widget/TableRow;", "buttons", "", "sideMargin", "generateDataRow", "showNumber", "", "rowData", "index", "generateDataRows", "", "rootLayout", "Landroid/view/ViewGroup;", "padding", "card", "generateTitleView", "layout", "Landroid/widget/TableLayout;", "title", "getTheme", "updateDividerColor", "cardView", "updateView", "viewHolder", "recycler_release"})
public final class TableCardCreator
implements ViewHolderCreator<TableCard.ViewHolder, TableCard> {
    private int dividerColor;
    private final int theme;

    @Override
    public int getTheme() {
        return this.theme;
    }

    @Override
    public void updateView(@NotNull Context context, @NotNull TableCard.ViewHolder viewHolder, @NotNull TableCard card) {
        block1: {
            String it;
            boolean bl;
            boolean bl2;
            String string;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)viewHolder), (String)"viewHolder");
            Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
            Resources resources = context.getResources();
            int padding = (int)resources.getDimension(R.dimen.table_padding);
            viewHolder.getLayout().removeAllViews();
            String string2 = card.getTitle();
            if (string2 != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl3 = false;
                this.generateTitleView(context, viewHolder.getLayout(), it);
            }
            this.generateDataRows(context, (ViewGroup)viewHolder.getLayout(), padding, card);
            TableRow tableRow = this.generateButtonsRow(card.getButtons(), context, this.theme, padding);
            if (tableRow == null) break block1;
            string = tableRow;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl4 = false;
            viewHolder.getLayout().addView((View)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateDataRows(Context context, ViewGroup rootLayout, int padding, TableCard card) {
        if (card.getData().isEmpty()) {
            return;
        }
        TableLayout.LayoutParams layoutParams = new TableLayout.LayoutParams(-1, Util.INSTANCE.toPx$recycler_release(1));
        int itemVerticalPadding = (int)context.getResources().getDimension(R.dimen.table_item_vertical_padding);
        int n = 0;
        int n2 = card.getData().size();
        while (n < n2) {
            void i;
            if (i > 0) {
                View divider = new View(context);
                divider.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                divider.setBackgroundColor(this.dividerColor);
                rootLayout.addView(divider);
            }
            TableRow rowLayout = this.generateDataRow(context, card.getShowRowNumber(), card.getData().get((int)i), (int)i, this.theme);
            rowLayout.setPadding(padding, itemVerticalPadding, padding, itemVerticalPadding);
            rootLayout.addView((View)rowLayout);
            ++i;
        }
    }

    private final void generateTitleView(Context context, TableLayout layout, String title) {
        TextView textView = new TextView(context, null, this.theme);
        boolean bl = false;
        boolean bl2 = false;
        TextView $this$apply = textView;
        boolean bl3 = false;
        $this$apply.setTextSize(18.0f);
        $this$apply.setTypeface(null, 1);
        $this$apply.setGravity(17);
        $this$apply.setLines(1);
        $this$apply.setEllipsize(TextUtils.TruncateAt.END);
        int padding = (int)context.getResources().getDimension(R.dimen.table_padding);
        TableLayout.LayoutParams titleLayoutParams = new TableLayout.LayoutParams(-2, -2);
        titleLayoutParams.setMargins(padding, 0, padding, Util.INSTANCE.toPx$recycler_release(16));
        $this$apply.setLayoutParams((ViewGroup.LayoutParams)titleLayoutParams);
        $this$apply.setText((CharSequence)title);
        TextView titleView = textView;
        layout.addView((View)titleView, 0);
    }

    private final void updateDividerColor(CardView cardView) {
        ColorStateList colorStateList = cardView.getCardBackgroundColor();
        Intrinsics.checkExpressionValueIsNotNull((Object)colorStateList, (String)"cardView.cardBackgroundColor");
        int color = colorStateList.getDefaultColor();
        double lum = ColorUtils.calculateLuminance((int)color);
        this.dividerColor = lum > 0.5 ? Color.argb((int)30, (int)0, (int)0, (int)0) : Color.argb((int)30, (int)255, (int)255, (int)255);
    }

    private final TextView generateButton(Context context, Pair<String, View.OnClickListener> button, @StyleRes int theme) {
        int dp48px = Util.INSTANCE.toPx$recycler_release(48);
        int dp16px = Util.INSTANCE.toPx$recycler_release(16);
        Button button2 = new Button(context, null, theme);
        boolean bl = false;
        boolean bl2 = false;
        Button $this$apply = button2;
        boolean bl3 = false;
        $this$apply.setMinWidth(dp48px);
        $this$apply.setPadding(dp16px, 0, dp16px, 0);
        $this$apply.setHeight(dp48px);
        TableRow.LayoutParams layoutParams = new TableRow.LayoutParams(-2, -2);
        layoutParams.setMargins(0, dp16px, 0, 0);
        $this$apply.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        Object object = button.first;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"button.first");
        String string = (String)object;
        Button button3 = $this$apply;
        boolean bl4 = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        String string4 = string3;
        button3.setText((CharSequence)string4);
        $this$apply.setTypeface(Typeface.defaultFromStyle((int)1));
        $this$apply.setOnClickListener((View.OnClickListener)button.second);
        $this$apply.setTextSize(16.0f);
        $this$apply.setGravity(17);
        $this$apply.setBackground((Drawable)Util.INSTANCE.getPressedColorRippleDrawable$recycler_release(0, Util.INSTANCE.getAccentColor$recycler_release(context), context.getDrawable(R.drawable.rectangle)));
        return (TextView)button2;
    }

    private final TableRow generateDataRow(Context context, boolean showNumber, Pair<String, String> rowData, int index, @StyleRes int theme) {
        TableRow row = new TableRow(context);
        if (showNumber) {
            TextView rowNum = new TextView(context, null, theme);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.UK;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.UK");
            Locale locale2 = locale;
            String string = "%d";
            Object[] objectArray = new Object[]{index + 1};
            TextView textView = rowNum;
            boolean bl = false;
            String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            String string3 = string2;
            textView.setText((CharSequence)string3);
            rowNum.setLayoutParams((ViewGroup.LayoutParams)new TableRow.LayoutParams(0, -2, 0.5f));
            row.addView((View)rowNum);
        }
        TextView textId = new TextView(context, null, theme);
        textId.setText((CharSequence)rowData.first);
        textId.setLayoutParams((ViewGroup.LayoutParams)new TableRow.LayoutParams(0, -2, 3.0f));
        row.addView((View)textId);
        TextView textValue = new TextView(context, null, theme);
        String value = (String)rowData.second;
        try {
            textValue.setText((CharSequence)Util.INSTANCE.formatNumber$recycler_release(Integer.parseInt(value)));
        }
        catch (NumberFormatException e) {
            textValue.setText((CharSequence)value);
        }
        textValue.setLayoutParams((ViewGroup.LayoutParams)new TableRow.LayoutParams(0, -2, 2.0f));
        textValue.setGravity(0x800005);
        row.addView((View)textValue);
        return row;
    }

    private final TableRow generateButtonsRow(List<? extends Pair<String, View.OnClickListener>> buttons, Context context, @StyleRes int theme, int sideMargin) {
        Collection collection = buttons;
        boolean bl = false;
        if (!collection.isEmpty()) {
            TableRow row = new TableRow(context);
            TableLayout.LayoutParams lp = new TableLayout.LayoutParams(-2, -2);
            lp.topMargin = Util.INSTANCE.toPx$recycler_release(4);
            lp.setMargins(sideMargin, 0, sideMargin, 0);
            row.setLayoutParams((ViewGroup.LayoutParams)lp);
            for (Pair<String, View.OnClickListener> pair : buttons) {
                row.addView((View)this.generateButton(context, pair, theme));
            }
            return row;
        }
        return null;
    }

    @Override
    @NotNull
    public TableCard.ViewHolder createView(@NotNull CardView parent, int viewType) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        if (this.dividerColor == 0) {
            this.updateDividerColor(parent);
        }
        Context context = parent.getContext();
        TableLayout tableLayout = new TableLayout(context);
        boolean bl = false;
        boolean bl2 = false;
        TableLayout $this$apply = tableLayout;
        boolean bl3 = false;
        $this$apply.setPadding(0, 30, 0, 30);
        parent.addView((View)$this$apply);
        TableLayout layout = tableLayout;
        return new TableCard.ViewHolder((View)parent, layout);
    }

    public TableCardCreator(@StyleRes int theme) {
        this.theme = theme;
    }
}

