/*
 * Decompiled with CFR 0.152.
 */
package com.adsamcik.recycler;

import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SortedList;
import com.adsamcik.recycler.AppendBehavior;
import com.adsamcik.recycler.AppendPriority;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0005J\u001b\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\bJ\u001a\u0010\u0010\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0012J\u0006\u0010\u0013\u001a\u00020\nJ\u0013\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0015\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0016R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/adsamcik/recycler/SortableAdapter;", "T", "VH", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "()V", "dataList", "Landroidx/recyclerview/widget/SortedList;", "Lcom/adsamcik/recycler/SortableAdapter$SortableData;", "add", "", "element", "priority", "Lcom/adsamcik/recycler/AppendPriority;", "(Ljava/lang/Object;Lcom/adsamcik/recycler/AppendPriority;)V", "data", "addAll", "list", "", "clear", "getItem", "index", "", "(I)Ljava/lang/Object;", "getItemCount", "indexOf", "(Ljava/lang/Object;)I", "remove", "(Ljava/lang/Object;)V", "size", "SortableData", "SortedListCallback", "recycler_release"})
public abstract class SortableAdapter<T, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    private final SortedList<SortableData<?>> dataList = new SortedList(SortableData.class, (SortedList.Callback)new SortedListCallback());

    public int getItemCount() {
        return this.dataList.size();
    }

    public final void add(T element, @NotNull AppendPriority priority) {
        Intrinsics.checkParameterIsNotNull((Object)priority, (String)"priority");
        this.add(new SortableData<T>(element, priority));
    }

    public final void add(@NotNull SortableData<T> data) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this.dataList.add(data);
    }

    public final void addAll(@NotNull Collection<SortableData<T>> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        this.dataList.addAll(list);
    }

    public final void clear() {
        this.dataList.clear();
    }

    public final void remove(T element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.dataList.removeItemAt(index);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int indexOf(T element) {
        int size = this.dataList.size();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            if (Intrinsics.areEqual(((SortableData)this.dataList.get((int)i)).getData(), element)) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    public final T getItem(int index) {
        return ((SortableData)this.dataList.get(index)).getData();
    }

    public final int size() {
        return this.dataList.size();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/adsamcik/recycler/SortableAdapter$SortableData;", "T", "", "data", "priority", "Lcom/adsamcik/recycler/AppendPriority;", "(Ljava/lang/Object;Lcom/adsamcik/recycler/AppendPriority;)V", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getPriority", "()Lcom/adsamcik/recycler/AppendPriority;", "component1", "component2", "copy", "(Ljava/lang/Object;Lcom/adsamcik/recycler/AppendPriority;)Lcom/adsamcik/recycler/SortableAdapter$SortableData;", "equals", "", "other", "hashCode", "", "toString", "", "recycler_release"})
    public static final class SortableData<T> {
        private final T data;
        @NotNull
        private final AppendPriority priority;

        public final T getData() {
            return this.data;
        }

        @NotNull
        public final AppendPriority getPriority() {
            return this.priority;
        }

        public SortableData(T data, @NotNull AppendPriority priority) {
            Intrinsics.checkParameterIsNotNull((Object)priority, (String)"priority");
            this.data = data;
            this.priority = priority;
        }

        public /* synthetic */ SortableData(Object object, AppendPriority appendPriority, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                AppendPriority.Companion this_$iv = AppendPriority.Companion;
                boolean $i$f$getAny = false;
                appendPriority = new AppendPriority(AppendBehavior.Any, 0, 2, null);
            }
            this(object, appendPriority);
        }

        public final T component1() {
            return this.data;
        }

        @NotNull
        public final AppendPriority component2() {
            return this.priority;
        }

        @NotNull
        public final SortableData<T> copy(T data, @NotNull AppendPriority priority) {
            Intrinsics.checkParameterIsNotNull((Object)priority, (String)"priority");
            return new SortableData<T>(data, priority);
        }

        @NotNull
        public static /* synthetic */ SortableData copy$default(SortableData sortableData, Object object, AppendPriority appendPriority, int n, Object object2) {
            if ((n & 1) != 0) {
                object = sortableData.data;
            }
            if ((n & 2) != 0) {
                appendPriority = sortableData.priority;
            }
            return sortableData.copy(object, appendPriority);
        }

        @NotNull
        public String toString() {
            return "SortableData(data=" + this.data + ", priority=" + this.priority + ")";
        }

        public int hashCode() {
            T t = this.data;
            AppendPriority appendPriority = this.priority;
            return (t != null ? t.hashCode() : 0) * 31 + (appendPriority != null ? ((Object)appendPriority).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SortableData)) break block3;
                    SortableData sortableData = (SortableData)object;
                    if (!Intrinsics.areEqual(this.data, sortableData.data) || !Intrinsics.areEqual((Object)this.priority, (Object)sortableData.priority)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J \u0010\b\u001a\u00020\u00052\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J \u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/adsamcik/recycler/SortableAdapter$SortedListCallback;", "Landroidx/recyclerview/widget/SortedList$Callback;", "Lcom/adsamcik/recycler/SortableAdapter$SortableData;", "(Lcom/adsamcik/recycler/SortableAdapter;)V", "areContentsTheSame", "", "oldItem", "newItem", "areItemsTheSame", "item1", "item2", "compare", "", "o1", "o2", "onChanged", "", "position", "count", "onInserted", "onMoved", "fromPosition", "toPosition", "onRemoved", "recycler_release"})
    public final class SortedListCallback
    extends SortedList.Callback<SortableData<?>> {
        public boolean areItemsTheSame(@NotNull SortableData<?> item1, @NotNull SortableData<?> item2) {
            Intrinsics.checkParameterIsNotNull(item1, (String)"item1");
            Intrinsics.checkParameterIsNotNull(item2, (String)"item2");
            return Intrinsics.areEqual(item1.getData(), item2.getData());
        }

        public void onMoved(int fromPosition, int toPosition) {
            SortableAdapter.this.notifyItemMoved(fromPosition, toPosition);
        }

        public void onChanged(int position, int count) {
            if (count == 1) {
                SortableAdapter.this.notifyItemChanged(position);
            } else {
                SortableAdapter.this.notifyItemRangeChanged(position, count);
            }
        }

        public void onInserted(int position, int count) {
            if (count == 1) {
                SortableAdapter.this.notifyItemInserted(position);
            } else {
                SortableAdapter.this.notifyItemRangeInserted(position, count);
            }
        }

        public void onRemoved(int position, int count) {
            if (count == 1) {
                SortableAdapter.this.notifyItemRemoved(position);
            } else {
                SortableAdapter.this.notifyItemRangeRemoved(position, count);
            }
        }

        public int compare(@NotNull SortableData<?> o1, @NotNull SortableData<?> o2) {
            Intrinsics.checkParameterIsNotNull(o1, (String)"o1");
            Intrinsics.checkParameterIsNotNull(o2, (String)"o2");
            return o1.getPriority().getBehavior() == o2.getPriority().getBehavior() ? o1.getPriority().getPriority() - o2.getPriority().getPriority() : o1.getPriority().getBehavior().ordinal() - o2.getPriority().getBehavior().ordinal();
        }

        public boolean areContentsTheSame(@NotNull SortableData<?> oldItem, @NotNull SortableData<?> newItem) {
            Intrinsics.checkParameterIsNotNull(oldItem, (String)"oldItem");
            Intrinsics.checkParameterIsNotNull(newItem, (String)"newItem");
            return Intrinsics.areEqual(oldItem.getData(), newItem.getData());
        }
    }
}

