package com.adpdigital.push;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapUtils {

    public static Map<String, Object> objectToMap(Object obj) {
        try {
            JSONObject jsonObj = new JSONObject(""+obj);
            Map<String, Object> map = new HashMap<String, Object>();
            Iterator<String> keys = jsonObj.keys();
            while(keys.hasNext()) {
                String key = keys.next();
                Object value = jsonObj.get(key);
                if (value instanceof JSONArray) {
                    value = toList((JSONArray) value);
                } else if (value instanceof JSONObject) {
                    value = objectToMap((JSONObject) value);
                }
                map.put(key, value);
            }   return map;
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return null;
    }

    public static List<Object> toList(JSONArray array) throws JSONException {
        List<Object> list = new ArrayList<Object>();
        for(int i = 0; i < array.length(); i++) {
            Object value = array.get(i);
            if (value instanceof JSONArray) {
                value = toList((JSONArray) value);
            }
            else if (value instanceof JSONObject) {
                value = objectToMap((JSONObject) value);
            }
            list.add(value);
        }   return list;
    }

    public static HashMap<String, Object> jsonObjectToMap(JSONObject jsonobj) throws JSONException {
        HashMap<String, Object> map = new HashMap<>();
        Iterator<String> keys = jsonobj.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            Object value = jsonobj.get(key);
            if (value instanceof JSONArray) {
                value = JsonUtils.jsonArrayToList((JSONArray) value);
            } else if (value instanceof JSONObject) {
                value = jsonObjectToMap((JSONObject) value);
            }
            map.put(key, value);
        }
        return map;
    }
}