package com.adpdigital.push;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.Calendar;
import java.util.Date;

public class Datetime implements Parcelable {
    private long timeMillis; // milliseconds after January 1, 1970 00:00:00 GMT.

    public Datetime() {
        timeMillis = Datetime.now();
    }

    /**
     * Sets this <code>Datetime</code> object to represent a point in time that is
     * <code>time</code> milliseconds after January 1, 1970 00:00:00 GMT.
     *
     * @param time the number of milliseconds.
     */
    public Datetime(long time) {
        if (time <= 0) {
            timeMillis = Datetime.now();
        } else {
            timeMillis = time;
        }
    }

    public Datetime(Date date) {
        if (date == null) {
            timeMillis = Datetime.now();
        } else {
            timeMillis = date.getTime();
        }
    }

    public Datetime(Calendar calendar) {
        if (calendar == null) {
            timeMillis = Datetime.now();
        } else {
            timeMillis = calendar.getTimeInMillis();
        }
    }

    protected Datetime(Parcel in) {
        timeMillis = in.readLong();
    }

    public static final Creator<Datetime> CREATOR = new Creator<Datetime>() {
        @Override
        public Datetime createFromParcel(Parcel in) {
            return new Datetime(in);
        }

        @Override
        public Datetime[] newArray(int size) {
            return new Datetime[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(timeMillis);
    }

    public long getTime() {
        return timeMillis;
    }

    public Date getDate() {
        return new Date(timeMillis);
    }

    /**
     * Returns the current time in milliseconds.  Note that
     * while the unit of time of the return value is a millisecond,
     * the granularity of the value depends on the underlying
     * operating system and may be larger.  For example, many
     * operating systems measure time in units of tens of
     * milliseconds.
     *
     * <p> See the description of the class <code>Date</code> for
     * a discussion of slight discrepancies that may arise between
     * "computer time" and coordinated universal time (UTC).
     *
     * @return the difference, measured in milliseconds, between
     * the current time and midnight, January 1, 1970 UTC.
     * @see java.util.Date
     */
    public static long now() {
        return System.currentTimeMillis();
    }
}
