package com.adpdigital.push;

import android.content.Context;
import android.provider.Settings;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class ChabokCrypto {
    private static final String TAG = ChabokCrypto.class.getName();
    private static final String TRANSFORMATION = "504245576974684d4435416e64444553";
    private static final String KEY = "424548524144";
    private static final String CHARSET = "UTF-8";

    private ChabokCrypto() {
        // no instance
    }

    public static String encrypt(Context context, String value) {
        try {
            String transformation = convertHexToString(TRANSFORMATION);
            final byte[] bytes = value != null ? value.getBytes(CHARSET) : new byte[0];
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(transformation);
            SecretKey key = keyFactory.generateSecret(new PBEKeySpec(convertHexToString(KEY).toCharArray()));
            Cipher pbeCipher = Cipher.getInstance(transformation);
            pbeCipher.init(Cipher.ENCRYPT_MODE, key, new PBEParameterSpec(
                    Settings.Secure.getString(
                            context.getContentResolver(),
                            Settings.Secure.ANDROID_ID).getBytes(CHARSET),
                    20));
            return new String(Base64Support.encode(pbeCipher.doFinal(bytes), Base64Support.NO_WRAP), CHARSET);
        } catch (Exception e) {
            Logger.e(TAG, "Warning, could not encrypt the value.  It may be stored in plaintext.  " + e.getMessage(), e);
            return value;
        }
    }

    public static String decrypt(Context context, String value) {
        if (value == null) {
            return value;
        }

        try {
            String transformation = convertHexToString(TRANSFORMATION);
            final byte[] bytes = value != null ? Base64Support.decode(value, Base64Support.DEFAULT) : new byte[0];
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(transformation);
            SecretKey key = keyFactory.generateSecret(new PBEKeySpec(convertHexToString(KEY).toCharArray()));
            Cipher pbeCipher = Cipher.getInstance(transformation);
            pbeCipher.init(Cipher.DECRYPT_MODE, key, new PBEParameterSpec(
                    Settings.Secure.getString(
                            context.getContentResolver(),
                            Settings.Secure.ANDROID_ID).getBytes(CHARSET),
                    20));
            return new String(pbeCipher.doFinal(bytes), CHARSET);
        } catch (Exception e) {
            Logger.e(TAG, "Warning, could not decrypt the value.  It may be stored in plaintext.  " + e.getMessage(), e);
            return value;
        }
    }

    static String convertHexToString(String hex) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < hex.length(); i += 2) {
            str.append((char) Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        return str.toString();
    }
}
