package com.adpdigital.push;


import android.app.Activity;
import android.app.AlarmManager;
import android.app.AlertDialog;
import android.app.Application;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Color;
import android.graphics.Point;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.provider.Settings;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.widget.CheckBox;
import android.widget.CompoundButton;

import com.adpdigital.push.config.Configuration;
import com.adpdigital.push.config.ConfigurationFactory;
import com.adpdigital.push.config.Environment;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.messaging.FirebaseMessaging;
import com.network.InstallationModel;
import com.network.NetworkPreferences;
import com.network.RemoteRepository;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import de.greenrobot.event.EventBus;
import me.leolin.shortcutbadger.ShortcutBadger;

import static com.adpdigital.push.AppState.BACKGROUND;
import static com.adpdigital.push.AppState.FOREGROUND;
import static com.adpdigital.push.AppState.REGISTERED;
import static com.adpdigital.push.Constants.MALFORMED;
import static com.adpdigital.push.GooglePlayServicesClient.getGooglePlayServicesInfo;
import static com.network.InstallationModel.PROPERTY_DEVICE_TOKEN;
import static com.network.InstallationModel.PROPERTY_INSTALLATION_ID;


/**
 * Created by: Alireza
 * Date: 5/8/2015.
 */
@SuppressWarnings("all")
public class AdpPushClient {

    public static final String TAG = AdpPushClient.class.getName();

    public static final String SDK_VERSION = BuildConfig.VERSION_NAME;
    // constants used to notify the Activity UI of received messages
    public static final String PUSH_DELIVERY_RECEIVED_INTENT = "com.adpdigital.push.client.DLVRECEIVE";
    public static final String PUSH_MSG_RECEIVED_INTENT = "com.adpdigital.push.client.MSGRECEIVE";
    public static final String PUSH_MSG_RECEIVED_TOPIC = "com.adpdigital.push.client.MSGRECVD_TOPIC";
    public static final String PUSH_MSG_RECEIVED_MSG = "com.adpdigital.push.client.MSGRECVD_MSGBODY";
    public static final String USE_BADGE_COUNT = "com.adpdigital.push.client.BadgeCount";
    public static final String ADVERTISING_ID_ENABLED = "com.adpdigital.push.client.ADVERTISING_ID_ENABLED";
    public static final String FB_DEFAULT_NOTIFICATION_ICON = "com.google.firebase.messaging.default_notification_icon";
    public static final String CHABOK_DEFAULT_NOTIFICATION_ICON = "com.adpdigital.push.client.default_notification_icon";
    public static final String FB_DEFAULT_NOTIFICATION_COLOR = "com.google.firebase.messaging.default_notification_color";
    public static final String CHABOK_DEFAULT_NOTIFICATION_COLOR  = "com.adpdigital.push.client.default_notification_color";


    //Prevents from showing non-chabok notifications
    public static final String SHOW_ONLY_CHABOK_NOTIFICATIONS = "com.adpdigital.push.client.SHOW_ONLY_CHABOK_NOTIFICATIONS";
    public static final String DISABLE_REALTIME = "com.adpdigital.push.client.DISABLE_REALTIME";

    // constants used by status bar notifications
    public static final int PUSH_NOTIFICATION_UPDATE = 2;
    public static final String APPLICATION_LAUNCH = "AppLaunched";
    public static final String APPLICATION_LAUNCH_TS = "AppLaunchTs";
    public static final String ACTIVITY_KEY = "MainActivityClassName";
    public static final String PURCHASE_EVENT_NAME = "purchase";
    private static final int TOTAL_RETRIES = 10;
    private static final ScheduledExecutorService worker =
            Executors.newSingleThreadScheduledExecutor();
    public static String packageName;

    //    private GoogleCloudMessaging gcm;
    private static boolean FORCE_STICKY = false;
    private static int installationRetries = 0;
    private static int tokenRetries = 0;
    static private Collection<String> notifs = new BoundedQueue<>(200);
    private static AdpPushClient pushClientInstance = null;
    private static boolean disableSdk;
    private static Environment chabokEnvironment;
    private Set<NotificationHandler> handlers = new HashSet<>();
    private boolean restartServiceState = false;
    private boolean isFreshStart = false;
    private boolean registeredOnce = false;
    private boolean registering = false;
    private boolean isNewInstall = false;
    private long lastLaunchTime;
    private long installDate;
    private boolean isLaunched = false;
    private EventBus eventBus = EventBus.getDefault();
    private static Context context;
    private static Class activityClass;
    private WeakReference<Activity> currentActivity;
    private ChabokNotificationAction lastNotificationAction;
    private ChabokNotification lastNotificationData;
    private OnDeeplinkResponseListener onDeeplinkResponseListener;
    private DeferredDataListener deferredDataListener;
    private Configuration config;
    private String userHash;
    private boolean _isLoggedInNow = false;
    private static Application.ActivityLifecycleCallbacks lifecycleCallbacks;
    private final Object _installationLock = new Object();
    private final Object _tokenLock = new Object();
    private static final ScheduledExecutorService tokenWorker =
            Executors.newSingleThreadScheduledExecutor();

    /**
     * This should be your tracker id.
     */
    private static String defaultTracker;

    /**
     * User's ID, this should be set from the acquired user phone number
     */
    private SecureString userId;
//    /**
//     * Substitute you own sender ID here. This is the project number you got
//     * from the API Console, as described in "Getting Started."
//     */
//    private String senderId;
    /**
     * Substitute your own application ID here. This is the id of the
     * application you registered in your LoopBack server by calling
     * Application.register().
     */
    private String appId;
    private String apiKey;
    private HashMap<String, Object> userInfo = new HashMap<>();
    /**
     * Channels name on which client subscribes to by default
     */
    private String[] channels = new String[]{
            Constants.DEFAULT_CHANNEL
    };
    private JSONObject notificationSettings;
    private ForegroundManager foreground;
    private boolean useSecure = true;
    private boolean useDev = true;
    private int notificationIcon = -1;
    private int notificationIconSilhouette = -1;
    private ChabokCommunicateFallbackMachine communicateFallbackMachine = ChabokCommunicateFallbackMachine.getInstance();

    private static final String GUEST_TAG = "CHABOK_GUEST";
    private static final String META_DATA = "__meta";
    private Callback<String> registerCallback;

    public static void setLogLevel(LogLevel logLevel){
        Logger.setLogLevel(logLevel);
    }

    public static void setApplicationContext(Context context) {
        Logger.d(TAG, "setApplicationContext is called with context = " + context);

        if (context.getApplicationContext() == null) {
            AdpPushClient.context = context;
        } else {
            AdpPushClient.context = context.getApplicationContext();
        }

        if (AdpPushClient.context instanceof Application) {
            registerOnActivityLifeCycle((Application) context);
        }

        AdpPushClient.activityClass = getActivityClass(AdpPushClient.context);
    }

    private static void registerOnActivityLifeCycle(Application context) {
        try {
            if (lifecycleCallbacks == null) {
                lifecycleCallbacks = new Application.ActivityLifecycleCallbacks() {
                    @Override
                    public void onActivityCreated(Activity activity, Bundle bundle) {
                    }

                    @Override
                    public void onActivityStarted(Activity activity) {
                    }

                    @Override
                    public void onActivityResumed(Activity activity) {
                        AdpPushClient.get().currentActivity = new WeakReference<>(activity);
                    }

                    @Override
                    public void onActivityPaused(Activity activity) {
                    }

                    @Override
                    public void onActivityStopped(Activity activity) {
                    }

                    @Override
                    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                    }

                    @Override
                    public void onActivityDestroyed(Activity activity) {
                    }
                };
                context.registerActivityLifecycleCallbacks(lifecycleCallbacks);
            }
        } catch (Exception ignored) {
            Logger.e(TAG, "can not register activity life cycle listener", ignored);
        }
    }

    static Class getActivityClass(Context context) {
        try {
            String className = context
                    .getPackageManager()
                    .getLaunchIntentForPackage(context.getPackageName())
                    .getComponent().getClassName();

            return Class.forName(className);
        } catch (Exception e) {
            e.printStackTrace();
        }

        Logger.w(TAG, "Could not find main activity class. " +
                "Please before calling Chabok init method call " +
                "AdpPushClient.setActivityClass(MainActivity.getClass())");
        return null;
    }

    private AdpPushClient(String appId, String apiKey, String username, String password) {
        Logger.i(TAG, "Creating a new AdpPushClient instance");

        // https://groups.google.com/forum/#!msg/google-admob-ads-sdk/_x12qmjWI7M/8WkalST9hvUJ
        try {
            Class.forName("android.os.AsyncTask");
        } catch (Throwable ignore) {
        }

        isFreshStart = true;

        validateAndPopulate(
                appId,
                apiKey,
                username,
                password);

        eventBus.register(this);

        // Check device for Play Services APK.
        // If check succeeds, proceed with GCM registration.
        if (!checkPlayServices()) {
            ChabokLocalStorage.setIsSupportPlayServices(getApplicationContext(),true);
            Logger.w(TAG, "No valid Google Play Services found.");
            // TODO if shouldBeSticky(), protectedApps should be enabled, ifHuaweiAlert may be used
        } else {
            ChabokLocalStorage.setIsSupportPlayServices(getApplicationContext(),false);
        }

        if (shouldBeSticky() && hasProtectedAppSupport()) {
            eventBus.post(AppState.PROTECTED_GRANT_NEEDED);
        }

        this.foreground = ForegroundManager.get(getApplicationContext());

        this.foreground.addListener(new AppListener() {
            @Override
            public void onBecameForeground(Class activityClass) {
                if (isFreshStart) {
                    Logger.i(TAG, "Application Launch");

                    updateLaunchStats();

                    eventBus.post(AppState.LAUNCH);

                    if (isNewInstall) {
                        eventBus.post(AppState.INSTALL);
                    }
                    doRegister();

                    isFreshStart = false;
                }

                if (isAutoResetBadge()) {
                    resetBadge();
                }

                PushService.performAction(getApplicationContext(), "START");

                if (!shouldBeSticky()) {
                    resetBackgroundTimer();
                }

                eventBus.post(FOREGROUND);
            }

            @Override
            public void onBecameBackground() {
                if (!shouldBeSticky()) {
                    startBackgroundTimer();
                }
                eventBus.post(BACKGROUND);
            }
        });

        initializeAdapter();
    }

    /**
     * Initialize Chabok SDK
     *
     * @deprecated As of release v3.0.0, because we added chabok gradle plugin use json configuration files instead.
     *             @see <a href="https://chabok.io">Chabok Initialization</a>
     *
     * @param context is the application context. For example: getApplicationContext()
     * @param handlerActivity is a default activity class to be shown when user clicks on notification.
     *                       For example: MainActivity.getClass()
     * @param appId is based on your environment. You can find it in your panel> settings.
     * @param apiKey is based on your environment. You can find it in your panel> settings.
     * @param username is based on your environment. You can find it in your panel> settings.
     * @param password is based on your environment and it's available on settings of panel.
     *
     * @return instance of AdpPushClient if parameters was valid.
     */
    @Deprecated
    public static AdpPushClient init(Context context,
                                     Class handlerActivity,
                                     String appId,
                                     String apiKey,
                                     String username,
                                     String password) {
        if (pushClientInstance == null) {
            synchronized (AdpPushClient.class) {
                if (pushClientInstance == null) {
                    packageName = AdpPushClient.context.getPackageName();
                    pushClientInstance = new AdpPushClient(appId, apiKey, username, password);
                    EventBus.getDefault().post(AppState.INITIALIZED);
                }
            }
        }
        return pushClientInstance;
    }

    private static AdpPushClient init(String appId,
                                      String apiKey,
                                      String username,
                                      String password) {
        return AdpPushClient.init(AdpPushClient.context,
                           AdpPushClient.activityClass,
                           appId,
                           apiKey,
                           username,
                           password);
    }

    public static void setDisableSdk(boolean disableSdk){
        AdpPushClient.disableSdk = disableSdk;

        if (disableSdk){
            Logger.w(TAG, "Chabok has been disabled.");
        }
    }

    public static boolean isDisabledSdk() {
        if (AdpPushClient.disableSdk) {
            Logger.w(TAG, "Chabok has been disabled by calling setDisableSdk(boolean) method.");
            return true;
        }
        return false;
    }

    public synchronized static AdpPushClient get() {
        if (pushClientInstance == null) {
            throw new IllegalStateException("AdpPushClient not initialized, " +
                    "Make sure to call AdpPushClient.configureEnvironment(Environment) in onCreate() method of your Application class. Please see http://bit.ly/32x1Tsn");
        }
        return pushClientInstance;
    }

    public static Context getContext() {
        return context;
    }

    static boolean hasNotified(String id) {
        return notifs.contains(id);
    }

    private void initializeAdapter() {
        String restApi = "https://" + Constants.ADP_RESOLVED_HOST + Constants.ADP_SERVER_PORT + "/api/";
        String currentHost = Constants.ADP_RESOLVED_HOST;
        String currentPortBroker = Constants.BROKER_PORT;
        useDev = getSharedPreferences().getBoolean("useDev", true);

        if (useSecure) {
            String appSubDomain = "";

            if (!appId.equalsIgnoreCase("chabok-demo")
                    && !appId.equalsIgnoreCase("adp-nms-push")
                    && !appId.equalsIgnoreCase("chabok-demo")) {
                appSubDomain = appId.split("-demo")[0] + ".";
            }
            restApi = "https://" + appSubDomain + Constants.ADP_RESOLVED_HOST + Constants.ADP_SERVER_PORT_SSL + "/api/";
            currentHost = appSubDomain + Constants.ADP_RESOLVED_HOST;
            currentPortBroker = Constants.BROKER_PORT_SSL;
        }
        if (useDev) {
            if (chabokEnvironment == null){
                restApi = "https://" + Constants.ADP_SERVER_SANDBOX + Constants.ADP_SERVER_PORT_DEV + "/api/";
            } else {
                restApi = "https://" + Constants.ADP_SERVER_SANDBOX + Constants.ADP_SERVER_PORT_DEV + "/api/";
            }

            currentHost = Constants.ADP_SERVER_SANDBOX;
            currentPortBroker = Constants.BROKER_PORT_DEV;
        }
        if (useDev && useSecure) {
            if (chabokEnvironment == null){
                restApi = "https://" + Constants.ADP_SERVER_DEVEVELOPMENT + Constants.ADP_SERVER_PORT_DEV_SSL + "/api/";
                currentHost = Constants.ADP_SERVER_DEVEVELOPMENT;
            } else {
                restApi = "https://" + Constants.ADP_SERVER_SANDBOX + Constants.ADP_SERVER_PORT_DEV_SSL + "/api/";
                currentHost = Constants.ADP_SERVER_SANDBOX;
            }

            currentPortBroker = Constants.BROKER_PORT_DEV_SSL;
        }
        getSharedPreferences().edit()
                .putString("host", currentHost)
                .putString("port", currentPortBroker)
                .putBoolean("useSecure", useSecure).apply();

        NetworkPreferences.initialize();
        NetworkPreferences.getInstance().setRestApi(restApi);
        NetworkPreferences.getInstance().setAccessToken(apiKey);
    }

    private void validateAndPopulate(String appId, String apiKey, String username, String password) {
        if (context == null) {
            throw new IllegalArgumentException("No Context passed," +
                    " Please call AdpPushClient.setApplicationContext(getApplicationContext())" +
                    " method before Chabok init method.");
        }

//        if (handlerActivity == null) {
//            throw new IllegalArgumentException("No Handler Activity Class passed, PushClient needs a work on a activity");
//        }
//        this.activityClass = handlerActivity;
//        getSharedPreferences().edit().putString(ACTIVITY_KEY, getActivityClass().getName()).apply();

        if (username == null) {
            throw new IllegalArgumentException("Please provide your username");
        }
        ChabokLocalStorage.setUsername(getApplicationContext(), username);

        if (password == null) {
            throw new IllegalArgumentException("Please provide your password");
        }
        ChabokLocalStorage.setPassword(getApplicationContext(), password);

        if (appId == null) {
            throw new IllegalArgumentException("Pleas provide your application ID");
        }

        String applicationId = appId;

        String[] token = appId.split("/");
        if (token.length > 1){
            applicationId = token[0];
            if (token.length == 2) {
                Logger.i(Logger.TAG, "SenderId is removed from Chabok SDK v3.0.0. Remove it from appId.");
            }
        }

        this.apiKey = apiKey;
        this.appId = applicationId;
        ChabokLocalStorage.setAppId(getApplicationContext(), this.appId);

        Set<String> storedChannels = ChabokLocalStorage.getTopics(
                getApplicationContext(),
                new HashSet<>(Arrays.asList(this.channels))
        );
        this.channels = storedChannels.toArray(new String[storedChannels.size()]);


        String storedNotifSettings = getSharedPreferences().getString("notificationSettings", null);
        if (storedNotifSettings != null) {
            try {
                notificationSettings = new JSONObject(storedNotifSettings);
            } catch (JSONException e) {
                Logger.e(TAG, e.getMessage(), e);
            }
        }

        Set<String> cache = getSharedPreferences().getStringSet("notifs", null);
        if (cache != null) {
            notifs.addAll(cache);
        }

        isNewInstall = !getSharedPreferences().getBoolean("chabokInstallation", false);

        this.installDate = getSharedPreferences().getLong("installDate", -1);
        if (this.installDate == -1) {
            long unixTime = System.currentTimeMillis();
            getSharedPreferences().edit().putLong("installDate", unixTime).apply();
            this.installDate = unixTime;
        }
    }

    private void resetBackgroundTimer() {
        AlarmManager alarm = ((AlarmManager) getApplicationContext().getSystemService(Context.ALARM_SERVICE));
        if (alarm == null) {
            return;
        }

        alarm.cancel(getBackgroundIntent());
    }

    private void startBackgroundTimer() {
        AlarmManager alarm = ((AlarmManager) getApplicationContext().getSystemService(Context.ALARM_SERVICE));
        if (alarm == null) {
            return;
        }

        long interval = 170 * 1000;
        PendingIntent backgroundIntent = getBackgroundIntent();
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT) {
            alarm.set(AlarmManager.ELAPSED_REALTIME_WAKEUP, SystemClock.elapsedRealtime() + interval, backgroundIntent);
        } else {
            alarm.setExact(AlarmManager.ELAPSED_REALTIME_WAKEUP, SystemClock.elapsedRealtime() + interval, backgroundIntent);
        }
    }

    private PendingIntent getBackgroundIntent() {
        Intent background = new Intent();
        background.setClass(getApplicationContext(), PushService.class);
        background.setAction("BackgroundTimeExceeded");
        if (android.os.Build.VERSION.SDK_INT >= 31) {
            return PendingIntent.getService(getApplicationContext(), 0, background, PendingIntent.FLAG_IMMUTABLE);
        } else {
            return PendingIntent.getService(getApplicationContext(), 0, background, 0);
        }
    }

    public void onEvent(final GcmMessage gcmMessage) {
        Logger.w(TAG, "New GCM message (foreground:" + isForeground() + "): " + gcmMessage.getIntent().getExtras());
        if (isForeground()) {
            Logger.w(TAG, "How is this happening...!? we are in foreground, so ignore GCM message");
        } else {
            final AdpPushClient that = this;
            isReceivedMessage(gcmMessage.getIntent().getExtras().getString("messageId"),
                    new com.adpdigital.push.Callback() {
                        @Override
                        public void onSuccess(Object value) {
                            boolean isReceived = (boolean) value;
                            eventBus.post(new createNotificationEvent(
                                    that,
                                    gcmMessage.getIntent(),
                                /* TODO: revisit: we are in background, but ignore this GCM message also...
                                    since brokerService should receive it soon or later
                                */
                                    true,
                                    isReceived
                                    /*toBeCanceledNotifs.contains(gcmMessage.getIntent().getExtras().getString("messageId"))*/
                            ));
                        }

                        @Override
                        public void onFailure(Throwable value) {
                        }
                    });
        }
    }

    public void publish(final PushMessage message, final com.adpdigital.push.Callback clbk) {
        if (AdpPushClient.isDisabledSdk()){
            return;
        }

        if (!isEnabledRealtime()) {
            return;
        }

        if (message.getUser().contains("/") || message.getChannel().contains("/")) {
            if (clbk != null) {
                clbk.onFailure(new Throwable("Channel or user should not contain slashes"));
            }
            return;
        }

        PushServiceManager.getInstance(getApplicationContext()).publish(message, clbk);
    }

    public void publish(
            final String channel,
            final String text,
            final com.adpdigital.push.Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (!isEnabledRealtime()) {
            return;
        }

        if (channel.contains("/")) {
            if (clbk != null) {
                clbk.onFailure(new Throwable("Channel should not contain slashes"));
            }
            return;
        }

        PushMessage message = new PushMessage();
        message.setId(UUID.randomUUID().toString());
        message.setCreatedAt(System.currentTimeMillis());
        message.setBody(text);
        message.setChannel(channel);
        PushServiceManager.getInstance(getApplicationContext()).publish(message, clbk);
    }

    public void publish(
            final String user,
            final String channel,
            final String text,
            final com.adpdigital.push.Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (!isEnabledRealtime()) {
            return;
        }

        if (channel.contains("/") || user.contains("/")) {
            if (clbk != null) {
                clbk.onFailure(new Throwable("Channel or user should not contain slashes"));
            }
            return;
        }

        PushMessage message = new PushMessage();
        message.setId(UUID.randomUUID().toString());
        message.setCreatedAt(System.currentTimeMillis());
        message.setBody(text);
        message.setChannel(channel);
        message.setUser(user);
        PushServiceManager.getInstance(getApplicationContext()).publish(message, clbk);
    }

    void publishMessageEvent(final String subject, final String messageId) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        try {
            JSONObject obj = new JSONObject();
            obj.put("ts", System.currentTimeMillis());
            emit(TopicType.event, subject, messageId, obj, true, false);
        } catch (Exception e) {
            Logger.e(TAG, "Couldnt publish message event " + messageId, e);
        }
    }

    public void publishEvent(final String event, final JSONObject data) {
        publishEvent(event, data, true, false);
    }

    public void publishEvent(final String event, final JSONObject data, final boolean live) {
        publishEvent(event, data, live, false);
    }

    public void publishEvent(final String event, final JSONObject data,
                             final boolean live, final boolean stateful) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (event == null || event.isEmpty()) {
            Logger.e(TAG, "eventName parameter is null. Please, provide an eventName");
            return;
        }
        if (data == null) {
            Logger.e(TAG, "data parameter is null. Please, provide a data");
            return;
        }

        JSONObject eventData = new JSONObject();

        try {
            boolean isMatchFeedback = event.contentEquals("matchUserFeedback") &&
                    (AdpPushClient.get().getAppId().contentEquals("90-dev") ||
                            AdpPushClient.get().getAppId().contentEquals("90-demo"));
            if (event.contentEquals("geo") || isMatchFeedback) {
                data.put("id", UUID.randomUUID().toString());
                data.put("createdAt", System.currentTimeMillis());
                eventData = data;
            } else {
                eventData.put("id", UUID.randomUUID().toString());
                eventData.put("createdAt", System.currentTimeMillis());
                eventData.put("data", data);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (this.getInstallationId() == null) {
            final JSONObject finalEventData = eventData;
            eventBus.register(new Object() {
                public void onEvent(ConnectionStatus state) {
                    if (state == ConnectionStatus.CONNECTED) {
                        emit(TopicType.event, event, getInstallationId(), finalEventData, live, stateful);
                        eventBus.unregister(this);
                    }
                }
            });
            return;
        }

        Logger.d(TAG, "publishEvent: sending data, event: " + event);
        emit(TopicType.event, event, this.getInstallationId(), eventData, live, stateful);
    }

    public void publishEvent(final String event, final Bundle data) {
        publishEvent(event, data, true, false);
    }

    public void publishEvent(final String event, final Bundle data, final boolean live) {
        publishEvent(event, data, live, false);
    }

    public void publishEvent(final String event, final Bundle data,
                             final boolean live, final boolean stateful) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (event == null || event.isEmpty()) {
            Logger.e(TAG, "eventName parameter is null. Please, provide an eventName");
            return;
        }
        if (data == null) {
            Logger.e(TAG, "data parameter is null. Please, provide a data");
            return;
        }

        // add metadata for datetime values
        JSONObject metadata = prepareMetaData(data);
        JSONObject convertedData = DataConverter.bundleToJson(data);

        JSONObject eventData = new JSONObject();

        try {
            boolean isMatchFeedback = event.contentEquals("matchUserFeedback") &&
                    (AdpPushClient.get().getAppId().contentEquals("90-dev") ||
                            AdpPushClient.get().getAppId().contentEquals("90-demo"));
            if (event.contentEquals("geo") || isMatchFeedback) {
                convertedData.put("id", UUID.randomUUID().toString());
                convertedData.put("createdAt", System.currentTimeMillis());

                if (metadata != null) {
                    convertedData.put(META_DATA, metadata);
                }
                eventData = convertedData;
            } else {
                eventData.put("id", UUID.randomUUID().toString());
                eventData.put("createdAt", System.currentTimeMillis());
                eventData.put("data", convertedData);

                if (metadata != null) {
                    eventData.put(META_DATA, metadata);
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (this.getInstallationId() == null) {
            final JSONObject finalEventData = eventData;
            eventBus.register(new Object() {
                public void onEvent(ConnectionStatus state) {
                    if (state == ConnectionStatus.CONNECTED) {
                        emit(TopicType.event, event, getInstallationId(), finalEventData, live, stateful);
                        eventBus.unregister(this);
                    }
                }
            });
            return;
        }

        Logger.d(TAG, "publishEvent: sending data, event: " + event);
        emit(TopicType.event, event, this.getInstallationId(), eventData, live, stateful);
    }

    /**
     *
     * @deprecated As of release v3.2.0, replaced by {@link AdpPushClient#publishEvent(String, JSONObject)}
     *
     * @param event event name
     * @param data event data
     */
    @Deprecated
    public void publishBackground(final String event, final JSONObject data) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (event == null || event.isEmpty()) {
            Logger.e(TAG, "eventName parameter is null. Please, provide an eventName");
            return;
        }

        if (data == null) {
            Logger.e(TAG, "data parameter is null. Please, provide a data");
            return;
        }

        JSONObject json = new JSONObject();
        JSONObject eventData = new JSONObject();

        try {

            if (event.equals("geo")) {
                eventData = data;
            } else {
                eventData.put("data", data);
            }
            eventData.put("eventName", event);
            eventData.put("id", UUID.randomUUID().toString());
            eventData.put("createdAt", System.currentTimeMillis());

            json.put("type", 3);
            json.put("data", eventData);

            ChabokCommunicateEvent communicateEvent = new ChabokCommunicateEvent(
                    json,
                    ChabokCommunicateStatus.PublishInBackground
            );
            eventBus.post(communicateEvent);

        } catch (JSONException e) {
            e.printStackTrace();
        }

    }

    private void emit(final TopicType type, final String event, final String subject, final JSONObject data,
                      final boolean live, final boolean stateful) {

//        String dataStr = "";
        SecureString secData = null;
        if (data != null) {
            secData = SecureString.instance(data.toString());
//            dataStr = data.toString();
            Logger.d(TAG, "emit: data: " + secData + " , subject: " + subject);
        }
//        final String payload = dataStr;

        PushServiceManager.getInstance(getApplicationContext()).publishReliably(type, event, subject, secData, live, stateful);
    }

    private void isReceivedMessage(final String messageId, final com.adpdigital.push.Callback clbk) {
        clbk.onSuccess(PushServiceManager.getInstance(getApplicationContext()).hasReceivedMessage(messageId));
    }

    public void getStatus(final com.adpdigital.push.Callback<ConnectionStatus> clbk) {
        if (!PushService.isRunning(getApplicationContext())) {
            clbk.onSuccess(ConnectionStatus.DISCONNECTED);
            return;
        }
        clbk.onSuccess(PushServiceManager.getInstance(getApplicationContext()).getStatus());
    }

    public void setEnableAlertForNotSupportingGcm(boolean supportGCMDialog) {
        getSharedPreferences()
                .edit()
                .putBoolean("CHK_SHOW_DIALOG_FOR_NOT_SUPPORT_GCM", supportGCMDialog)
                .apply();
    }

    private boolean isEnabledAlertForNotSupportingGcm() {
        return getSharedPreferences().getBoolean("CHK_SHOW_DIALOG_FOR_NOT_SUPPORT_GCM", true);
    }

    public void subscribe(String channel,
                          final com.adpdigital.push.Callback clbk) {

        subscribe(channel, false, clbk);
    }

    public void subscribe(final String channel,
                          final boolean live,
                          final com.adpdigital.push.Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (!isEnabledRealtime()) {
            return;
        }

        if (!live) {
            Set<String> allChannels = new HashSet<>(Arrays.asList(channels));
            allChannels.add(convertChannelName2OldConvention(channel));

            ChabokLocalStorage.setTopics(getApplicationContext(), allChannels);
            channels = allChannels.toArray(new String[allChannels.size()]);
            updateInstallation(new HashMap<String, Object>());

            if (channel.startsWith("public/") || !channel.startsWith("private/")) {
                ChabokFirebaseMessaging.subscribe(channel);
            }
        }

        String channelName = ChabokFirebaseMessaging.getChannelIdFromTopic(channel);
        createOrUpdateNotificationChannel(channel, channelName);

        PushServiceManager.getInstance(getApplicationContext()).subscribe(channel, live, clbk);
    }

    private String convertChannelName2OldConvention(String channel) {
        if (channel.startsWith("private/")) {
            return channel.substring(channel.indexOf("/") + 1);
        } else if (channel.startsWith("public/")) {
            return channel;
        } else {
            return "public/" + channel;
        }
    }

    public void unsubscribe(final String channel,
                            final com.adpdigital.push.Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (!isEnabledRealtime()) {
            return;
        }

        Set<String> allChannels = new HashSet<>(Arrays.asList(channels));
        allChannels.remove(convertChannelName2OldConvention(channel));
        //TODO restore public topic if all public/ are ubsubed?
        ChabokLocalStorage.setTopics(getApplicationContext(), allChannels);
        channels = allChannels.toArray(new String[allChannels.size()]);

        updateInstallation(new HashMap<String, Object>());

        if (channel.startsWith("public/") || !channel.startsWith("private/")) {
            ChabokFirebaseMessaging.unsubscribe(channel);
        }

        if (hasNotificationChannel(channel)) {
            deleteNotificationChannel(channel);
        }

        PushServiceManager.getInstance(getApplicationContext()).unsubscribe(channel, clbk);
    }

    public void updateNotificationSettings(String topicName, String sound, boolean alert) {
        if (notificationSettings == null) {
            notificationSettings = new JSONObject();
        }
        JSONObject topicSetting = new JSONObject();
        notificationSettings.remove(topicName);
        try {
            topicSetting.put("sound", sound);
            topicSetting.put("alert", alert);
            notificationSettings.put(topicName, topicSetting);
            getSharedPreferences()
                    .edit()
                    .putString("notificationSettings", notificationSettings.toString())
                    .apply();

            HashMap<String, Object> props = new HashMap();
            HashMap notifSettings = getNotificationSettings();
            if (notifSettings != null) {
                props.put("notificationSettings", notifSettings);
            }
            updateInstallation(props);
        } catch (JSONException e) {
            Logger.e(TAG, e.getMessage(), e);
        }
    }

    public AdpPushClient addListener(Object object) {
        if (!eventBus.isRegistered(object)) {
            eventBus.register(object);
        }
        return this;
    }

    public AdpPushClient notify(Object object) {
        if (eventBus != null) {
            eventBus.post(object);
        }
        return this;
    }

    public AdpPushClient removeListener(Object object) {
        if (eventBus.isRegistered(object)) {
            eventBus.unregister(object);
        }
        return this;
    }

    //TODO check side effects of refactoring Context to Object
    public AdpPushClient setPushListener(Object ctx) {
//        this.clientContextInstance = ctx;
        return addListener(ctx);
    }

    public AdpPushClient removePushListener(Object activity) {
//        this.clientContextInstance = null;
        return removeListener(activity);
    }

    private AdpPushClient register(String userId) {
        return register(userId, new String[]{}, null);
    }

    private AdpPushClient register(String userId, Callback<String> registrationCallback){
        return register(userId, new String[]{}, registrationCallback);
    }

    private AdpPushClient register(String userId, String[] channels, Callback<String> registrationCallback){
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }

        if (userId == null || userId.trim().equals("") || userId.trim().equals("null")) {
            Logger.e(TAG, "Please provide a user ID to register with ADP server: " + userId);
            if (registrationCallback != null) {
                registrationCallback.onFailure(new IllegalArgumentException("Please provide a user ID to register with ADP server: " + userId));
            }
            return pushClientInstance;
        }

        if (!isValid(userId)) {
            Logger.e(TAG, "User ID is not valid: " + userId);
            if (registrationCallback != null) {
                registrationCallback.onFailure(new IllegalArgumentException("User ID is not valid: " + userId));
            }
            return pushClientInstance;
        }

        String guid = getGuestUserId();

        if (guid != null && !userId.contentEquals(guid)) {
            _isLoggedInNow = true;
            setGuestUserId(null);
        }

        return _register(userId, channels, registrationCallback);
    }

    private AdpPushClient registerAsGuest(){
        return _registerAsGuest(null, null);
    }

    private AdpPushClient registerAsGuest(Callback<String> registrationCallback){
        return _registerAsGuest(null, registrationCallback);
    }

    private AdpPushClient registerAsGuest(String guestId){
        return _registerAsGuest(guestId, null);
    }

    private AdpPushClient registerAsGuest(String guestId, Callback<String> registrationCallback){
        return _registerAsGuest(guestId, registrationCallback);
    }

    private AdpPushClient _registerAsGuest(String guestId, Callback<String> registrationCallback){
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }

        String userId = getGuestUserId();
        if ((guestId != null && userId == null) ||
                (guestId != null && !guestId.contentEquals(userId))) {
            userId = guestId;
            setGuestUserId(userId);
        }
        if (userId == null) {
            userId = UUID.randomUUID().toString().replace("-", "");
            setGuestUserId(userId);
        }
        _isLoggedInNow = false;
        userHash = "";

        return _register(userId, new String[]{}, registrationCallback);
    }

    private AdpPushClient reRegister(String userId) {
        return reRegister(userId, new String[]{});
    }

    private AdpPushClient reRegister(String userId, String[] channels) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }

        ChabokLocalStorage.setReregisteredFrom(getApplicationContext(), this.userId);
        unregister(true);
        _register(userId, channels, registerCallback);
        return this;
    }

    private AdpPushClient _register(final String userId, final String[] channels, final Callback<String> registrationCallback) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }

        if (userId == null || userId.trim().equals("") || userId.trim().equals("null")) {
            Logger.e(TAG, "Please provide a user ID to register with ADP server: " + userId);
            if (registrationCallback != null) {
                registrationCallback.onFailure(new IllegalArgumentException("Please provide a user ID to register with ADP server: " + userId));
            }
            return pushClientInstance;
        }

        if (!isValid(userId)) {
            Logger.e(TAG, "User ID is not valid: " + userId);
            if (registrationCallback != null) {
                registrationCallback.onFailure(new IllegalArgumentException("User ID is not valid: " + userId));
            }
            return pushClientInstance;
        }

        if (registering) {
            Logger.w(TAG, "Already in registering...");

            eventBus.register(new Object() {
                public void onEvent(AppState state) {
                    if (state == REGISTERED) {
                        eventBus.unregister(this);
                        _register(userId, channels, registrationCallback);
                    }
                }
            });

            return this;
        }

        this.registerCallback = registrationCallback;

        if (hasNotificationChannel(getInstallationId())){
            deleteNotificationChannel(getInstallationId());
        }

        SecureString currentUserId = getSecureUserId();
        if (!userId.equalsIgnoreCase(currentUserId.asString())) {
            setRegisterTs(System.currentTimeMillis());
        }

        if (currentUserId.asString() != null && !userId.equalsIgnoreCase(currentUserId.asString())) {
            return reRegister(userId, channels);
        }

        registeredOnce = false;

        this.userId = SecureString.instance(userId);

        ChabokLocalStorage.setUserId(context, this.userId);

        Set<String> allTopics = new HashSet<>(Arrays.asList(this.channels));
        List<String> newChannels = new ArrayList<>();
        boolean userHasNewTopic = false;

        for (String ch : channels) {
            String chName = convertChannelName2OldConvention(ch);
            newChannels.add(chName);
            if (!allTopics.contains(chName)) {
                userHasNewTopic = true;
            }
        }
        allTopics.addAll(newChannels);
//        boolean userHasPublicTopic = false;
//        for( String t : allTopics) {
//            if( t.contains("public/") && !t.equalsIgnoreCase(Constants.PUBLIC_CHANNEL) ) {
//                userHasPublicTopic = true;
//            }
//        }
//        if( userHasPublicTopic ) {
//            allTopics.remove(Constants.PUBLIC_CHANNEL);
//        } else {
//            allTopics.add(Constants.PUBLIC_CHANNEL);
//        }
        if (userHasNewTopic) {
            makeSubsDirty();
        }
        ChabokLocalStorage.setTopics(getApplicationContext(), allTopics);
        this.channels = allTopics.toArray(new String[allTopics.size()]);

        installationRetries = 0;

        // Check device for Play Services APK.
        // If check succeeds, proceed with GCM registration.
        if (!checkPlayServices()) {
            ChabokLocalStorage.setIsSupportPlayServices(getApplicationContext(), true);
            Logger.w(TAG, "No valid Google Play Services found.");
        } else {
            ChabokLocalStorage.setIsSupportPlayServices(getApplicationContext(), false);
        }

        //TODO: Make sure need to get install referrer data each time or only once.
        getApplicationInstallReferrer();

        doRegister();

        return this;
    }

    private boolean isValid(String userId) {
        if (TextUtils.isEmpty(userId)) {
            return false;
        }
        if (userId.length() < 1 || userId.length() > 64) {
            return false;
        }
        String REGEX = ".*(\\s|#|\\+|/|\\*|\\\\).*";
        return !userId.matches(REGEX);
    }


    private void doRegister() {
        doRegister(false);
    }

    private void doRegister(final boolean restartService) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (userId.asString() == null) {
            Logger.e(TAG, "userId not initialized yet");
            return;
        }
        if (registering) {
            Logger.d(TAG, "Register already in progress for " + userId);
            return;
        }

        registering = true;

        Logger.d(TAG, "-- Post Event REGISTERING");
        eventBus.post(AppState.REGISTERING);

        initializeAdapter();

        worker.schedule(new Runnable() {
            public void run() {
                if (registeredOnce) {
                    Logger.w(TAG, "Already Registered Once!");
                    registering = false;
                    return;
                }
                if (!foreground.isForeground()) {
                    Logger.w(TAG, "Don't register in non-foreground mode!");
                    registering = false;
                    return;
                }

                Logger.i(TAG, "Registering to Chabok, foreground:" + isForeground());

                updateRegistration(restartService);
            }
        }, 250, TimeUnit.MILLISECONDS);
    }

    /**
     * @deprecated As of release v3.0.0, you do not need anymore to call this method.
     */
    @Deprecated
    public void dismiss() {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        Logger.i(TAG, "Dismiss AdpPushClient");
        eventBus.unregister(this);
        getForegroundManager().removeListeners();

        deferredDataListener = null;
        onDeeplinkResponseListener = null;
    }

    private void cleanData() {
        getSharedPreferences().edit().clear().apply();
    }

    void makeSubsDirty() {
        getSharedPreferences().edit().putBoolean("subscriptionDirty", true).apply();
    }

    /**
     * Check the device to make sure it has the Google Play Services APK. If
     * it doesn't, display a dialog that allows users to download the APK from
     * the Google Play Store or enable it in the device's system settings.
     */
    private boolean checkPlayServices() {
        try {
            GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
            int resultCode = apiAvailability.isGooglePlayServicesAvailable(getApplicationContext());
            if (resultCode != ConnectionResult.SUCCESS && resultCode != ConnectionResult.SERVICE_VERSION_UPDATE_REQUIRED) {
                if (apiAvailability.isUserResolvableError(resultCode)) {
                    if (currentActivity != null && currentActivity.get() != null) {
                        try {
                            if (isEnabledAlertForNotSupportingGcm() && !AdpPushClient.isDisabledSdk()) {
                                apiAvailability
                                        .getErrorDialog(currentActivity.get(), resultCode, Constants.PLAY_SERVICES_RESOLUTION_REQUEST)
                                        .show();
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                Logger.i(TAG, "This device is not supported, but google api is available");
                return false;
            }
            return true;
        } catch (NoClassDefFoundError e) {
            Logger.i(TAG, "This device is not supported and google api is not available");
            return false;
        }
    }

    /**
     * Updates the registration for push notifications.
     */
    private AdpPushClient updateRegistration(boolean restartService) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }

        // 2. Create InstallationModel instance
        final InstallationModel installationModel = new InstallationModel(getApplicationContext());


        //TODO Don't update unnecessary fields each time

        // 3. Update Installation properties that were not pre-filled
        // Enter the id of the LoopBack Application
        installationModel.setAppId(getAppId());

        installationModel.setAppVersion(SDK_VERSION);

        // Substitute a real id of the user logged in this application
        installationModel.setUserId(getSecureUserId());

        installationModel.setSubscriptions(channels);

//        // 4. Check if we have a valid GCM registration id
//        if (installation.getDeviceToken() != null && !installation.getDeviceToken().equals("---")) {
//            // 5a. We have a valid GCM token, all we need to do now
//            //     is to save the installation to the server
//            saveInstallation(installation, restartService);
//        } else {
//            // 5b. We don't have a valid GCM token. Get one from GCM
//            // and save the installation afterwards.
//            registerInBackground(installation);
//        }

        restartServiceState = restartService;

        registerInBackground(installationModel);

        return this;
    }

    private void fetchAndSetAdId(InstallationModel installationModel) {
        // Get advertising id if client has play services
        // url: http://bit.ly/2B8QzH8
        if (isAdvertisingIdEnabled()) {
            Boolean isExistPlayServices = checkPlayServices();
            if (isExistPlayServices) {
                Logger.d(Logger.TAG, "\n\n ==================================== \n\n" +
                        "Start getting AdvertisingId at " + System.currentTimeMillis() +
                        "\n\n ==================================== \n\n");

                try {
                    String adId = getPlayAdId(context);
                    if (adId != null) {
                        installationModel.setAdId(adId);
                    }

                    Boolean trackingEnabled = isPlayTrackingEnabled(context);
                    installationModel.setAdIdEnabled(trackingEnabled);

                } catch (Exception ex) {
                    Logger.e(TAG, "Exception happen for get advertisingId doInBackground: -----> ", ex);
                    ex.printStackTrace();
                }

                Logger.d(Logger.TAG, "\n\n ==================================== \n\n" +
                        "Get AdvertisingId = " + installationModel.getAdId() + " at " + System.currentTimeMillis() +
                        "\n\n ==================================== \n\n");
            }
        }
    }

    /**
     * Registers the application with GCM servers asynchronously.
     * <p/>
     * Stores the registration ID in the provided InstallationModel
     */
    private synchronized void registerInBackground(final InstallationModel installationModel) {
        Logger.d(TAG, String.format(Locale.getDefault(),
                "registerInBackground called in `%s` Thread (%d)",
                Thread.currentThread().getName(),
                Thread.currentThread().getId()));

        fetchAndSetAdId(installationModel);

        if (!isEnabledPushNotification()) {
            final DeviceToken deviceToken = new DeviceToken(SecureString.instance("disabled"));
            deviceToken.setCallerId(AdpPushClient.class.getCanonicalName());
            EventBus.getDefault().post(deviceToken);

            return;
        }

        Logger.d(TAG, "registerInBackground...");

        getToken(true);
    }

    private synchronized void getToken(final boolean installationRequired) {
        Logger.d(TAG, String.format(Locale.getDefault(),
                "getToken called in `%s` Thread (%d)",
                Thread.currentThread().getName(),
                Thread.currentThread().getId()));

        FirebaseMessaging.getInstance().getToken()
                .addOnCompleteListener(new OnCompleteListener<String>() {
                    @Override
                    public void onComplete(@NonNull Task<String> task) {
                        if (!task.isSuccessful()) {
                            String errorMessage = "";
                            if (task.getException() != null) {
                                errorMessage = task.getException().getMessage();
                            }

                            final DeviceToken deviceToken = new DeviceToken(
                                    SecureString.instance("---"),
                                    errorMessage,
                                    201);
                            deviceToken.setCallerId(AdpPushClient.class.getCanonicalName());
                            deviceToken.setForceUpdate(!installationRequired);
                            EventBus.getDefault().post(deviceToken);

                            Logger.e(TAG, "ERROR DeviceToken ", task.getException());
                        } else {
                            if (task.getResult() == null) {
                                final DeviceToken deviceToken = new DeviceToken(
                                        SecureString.instance("---"),
                                        "Token is null for unknown reason.",
                                        200);
                                deviceToken.setCallerId(AdpPushClient.class.getCanonicalName());
                                deviceToken.setForceUpdate(!installationRequired);
                                EventBus.getDefault().post(deviceToken);
                            } else {
                                SecureString token = SecureString.instance(task.getResult());

                                final DeviceToken deviceToken = new DeviceToken(token);
                                deviceToken.setCallerId(AdpPushClient.class.getCanonicalName());
                                deviceToken.setForceUpdate(!installationRequired);
                                EventBus.getDefault().post(deviceToken);

                                Logger.d(TAG, "DeviceToken task is successful ~> " + token);
                            }
                        }
                    }
                })
                .addOnCanceledListener(new OnCanceledListener() {
                    @Override
                    public void onCanceled() {
                        final DeviceToken deviceToken = new DeviceToken(
                                SecureString.instance("---"),
                                "CANCELED",
                                202);
                        deviceToken.setCallerId(AdpPushClient.class.getCanonicalName());
                        deviceToken.setForceUpdate(!installationRequired);
                        EventBus.getDefault().post(deviceToken);

                        Logger.w(TAG, "Canceled get DeviceToken ");
                    }
                });
    }

    public void onEvent(final DeviceToken token) {
        Logger.d(TAG, String.format(Locale.getDefault(),
                "DeviceToken onEvent called in `%s` Thread (%d)",
                Thread.currentThread().getName(),
                Thread.currentThread().getId()));

        final InstallationModel installationModel = getInstallationModel();
        Logger.d(TAG, "on event DeviceToken " + token.getToken() + " ?== " + installationModel.getDeviceToken());

        new AsyncTask<Void, Void, Boolean>() {
            @Override
            protected Boolean doInBackground(final Void... params) {
                Logger.d(TAG, "onEvent(DeviceToken).doInBackground()");

                synchronized (_tokenLock) {
                    Logger.d(TAG, "_tokenLock acquired");

                    Logger.d(TAG, String.format(Locale.getDefault(),
                            "DeviceToken doInBackground called in `%s` Thread (%d)",
                            Thread.currentThread().getName(),
                            Thread.currentThread().getId()));

                    if (token.getCallerId() != null) {
                        if (token.getCallerId().equalsIgnoreCase(ChabokFirebaseMessaging.class.getCanonicalName())) {
                            Logger.d(TAG, "token received from Firebase.onNewToken() method");

                            SecureString currentToken = SecureString.instance(getSharedPreferences().getString(PROPERTY_DEVICE_TOKEN, null));
                            if (currentToken.asString() == null) {
                                Logger.i(TAG, "GOT current token ~> null, don't update installation");
                                Logger.d(TAG, "_tokenLock released");

                                return false;
                            } else if (token.getToken().asString().equalsIgnoreCase(currentToken.asString())) {
                                Logger.i(TAG, "GOT same token, don't update installation");
                                Logger.d(TAG, "_tokenLock released");

                                return false;
                            }

                            if (isNewInstall) {
                                Logger.i(TAG, "this is a new install, so installation dropped!");
                                Logger.d(TAG, "_tokenLock released");

                                return false;
                            }
                        } else {
                            Logger.d(TAG, "token received from Firebase.getInstanceId() method");
                        }
                    } else {
                        Logger.d(TAG, "token received from unknown callerId so ... we accept it!");
                    }

                    if (token == null || token.getToken().asString() == null) {
                        Logger.i(TAG, "token ~> null, now registering installation");

                        installationModel.setDeviceToken(SecureString.instance("---"));
                        installationModel.setTokenStatus("ERR");
                        installationModel.setTokenError("Token is null for unknown reason.", 200);

                        Logger.d(TAG, "_tokenLock released");

                        return true;
                    }

                    installationModel.setDeviceToken(token.getToken());
                    try {
                        if (token.getTokenStatus() != null) {
                            installationModel.setTokenStatus(token.getTokenStatus());
                        }
                        if (token.getTokenErr() != null) {
                            installationModel.setTokenError(token.getTokenErr(), token.getTokenErrCode());
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                    if ("SERVICE_NOT_AVAILABLE".equalsIgnoreCase(token.getTokenErr())) {
                        Logger.e(TAG, "FCM:SERVICE_NOT_AVAILABLE ~> retryRegistrationBackoff...");

                        retryGetTokenBackoff();

                        if (token.isForceUpdate()) {
                            return false;
                        }
                    } else if (token.isForceUpdate()) {
                        Logger.w(TAG, "token force update!");

                        updateDeviceToken(token);

                        return false;
                    }

                    Logger.d(TAG, "_tokenLock released");
                }

                return true;
            }

            @Override
            protected void onPostExecute(final Boolean registered) {
                if (registered) {
                    Logger.i(TAG, "Got token, now registering installation");

                    saveInstallation(installationModel, restartServiceState);
                    restartServiceState = false;
                }
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null, null, null);
    }

    /**
     * Saves the Installation to the LoopBack server and reports the result.
     *
     * @param installationModel
     */
    private void saveInstallation(final InstallationModel installationModel, final boolean restartService) {
        final HashMap<String, Object> props = new HashMap<>();

        // fore this on each device save request
        props.put("launchCount", getAppLaunchCount());
        props.put("launchTime", getAppLaunchTime());
        props.put("realtime", isEnabledRealtime());
        if (getLastAppLaunchTime() > 0) {
            props.put("lastLaunchTime", getLastAppLaunchTime());
        }
        //Install Referrer
        if (hasInstallReferrerData()) {
            String installReferrer = getInstallReferrer();

            if (installReferrer != null) {
                props.put("referrer", installReferrer);
                props.put("refClickTs", getInstallReferrerClickTs());
                props.put("refBeginTs", getInstallReferrerInstallBeginTs());
            }
        }

        if (getRawInstallReferrer() != null) {
            props.put("rawReferrer", getRawInstallReferrer());
            props.put("rawRefClickTs", getRawInstallReferrerClickTs());

            //Adjust send array params but it's not necessary for us.
            //props.put("rawReferrerParams", getRawInstallReferrerParams());
        }

        if (defaultTracker != null &&
                !defaultTracker.trim().isEmpty()) {
            props.put("defaultTracker", defaultTracker);
        }

        JSONArray cachedData = communicateFallbackMachine.getReadyToSendEventData();
        if (cachedData != null) {
            props.put("eventData", cachedData);
        }

        //TODO: deviceId deprecated because it was not reliable.
        props.put("deviceId", getDeviceId());

        //This uniqueId will replace to deviceId.
        String uniqueId = getUniqueID();
        if (uniqueId != null && uniqueId.trim() != "") {
            props.put("uniqueId", uniqueId);
        }

        try {
            String appSignature = DeviceUtil.getAppSignature(context);
            if (appSignature != null) {
                props.put("appSessionId", appSignature);
            } else {
                props.put("appSessionId", "INVALID");
            }
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        props.put("appTokenId", DeviceUtil.base64CreateFingerprint(context));

        props.put("mobileOperator", DeviceUtil.getMobileOperator(context));

        boolean isExistPlayServices = checkPlayServices();
        if (!isExistPlayServices) {
            props.put("gpsVersionFound", -1);
        } else {
            try {
                if (context != null && context.getPackageManager() != null) {
                    int installedPlayServices = context.getPackageManager().getPackageInfo(GoogleApiAvailability.GOOGLE_PLAY_SERVICES_PACKAGE, 0).versionCode;
                    props.put("gpsVersionFound", installedPlayServices);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        int appRequiredPlayServices = GoogleApiAvailability.GOOGLE_PLAY_SERVICES_VERSION_CODE;
        props.put("gpsVersionRequired", appRequiredPlayServices);

        // we can omit this until a change is happening!
        props.put("connection", Connectivity.getNetworkClass(getApplicationContext()));
        props.put("osVersion", Build.VERSION.RELEASE);
        props.put("deviceManufacturer", Build.MANUFACTURER);
        props.put("deviceModel", Build.MODEL);
        props.put("osBuild", Build.ID);
        props.put("locale", Locale.getDefault());
        props.put("clientVersion", getClientVersion());
        props.put("launched", isLaunched);
        props.put("newInstall", isNewInstall);

        if (_isLoggedInNow) {
            props.put("isLoggedIn", _isLoggedInNow);
        }

        if (userHash != null && !userHash.isEmpty()) {
            props.put("userHash", userHash);
        }

        if (this.userInfo != null && !this.userInfo.isEmpty()) {
            props.put("userInfo", this.userInfo);
        }

        HashMap notifSettings = getNotificationSettings();
        if (notifSettings != null) {
            props.put("notificationSettings", notifSettings);
        }

        //Add app installer id (MarketPlace) to props if was not null, set `notSet`.
        props.put("installSource", getInstallSource());

        props.put("installDate", installDate);

        String screenRes = getDeviceScreenResolution();
        if (screenRes != null) {
            props.put("screenResolution", screenRes);
        }

        SecureString reregisteredFrom = getReregisteredFrom();
        if (reregisteredFrom.asString() != null) {
            props.put("reregisteredFrom", reregisteredFrom.asString());
        }

        //Get package name and put in appBundleId.
        if (context != null) {
            if (context.getPackageName() != null) {
                props.put("appBundleId", context.getPackageName());
            }
        }

        if (installationModel.getTokenStatus() == null) {
            try {
                boolean areNotificationsEnabled = NotificationManagerCompat.from(context).areNotificationsEnabled();
                if (areNotificationsEnabled) {
                    installationModel.setTokenStatus("ALLOWED");
                } else {
                    installationModel.setTokenStatus("DENIED");
                }
            } catch (Exception exc) {
                exc.printStackTrace();
            }
        }

        props.put("isProduction", !BuildConfig.DEBUG);

        final AdpPushClient finalThis = AdpPushClient.this;

        new AsyncTask<Void, Void, Boolean>() {
            @Override
            protected Boolean doInBackground(final Void... params) {
                Logger.d(TAG, "saveInstallation.doInBackground()");

                synchronized (_installationLock) {
                    Logger.d(TAG, "_installationLock acquired");

                    Logger.i(TAG, "Saving installation " + installationModel.getId());

                    Logger.d(TAG, String.format(Locale.getDefault(),
                            "installation doInBackground called in `%s` Thread (%d)",
                            Thread.currentThread().getName(),
                            Thread.currentThread().getId()));

                    final CountDownLatch _installationLatch = new CountDownLatch(1);

                    RemoteRepository.installation(installationModel,props,installationModel.getRequireParams(), new com.adpdigital.push.Callback() {
                        @Override
                        public void onSuccess(Object value) {
                            Logger.d(TAG, "installation.save().onSuccess()");

                            Logger.d(TAG, String.format(Locale.getDefault(),
                                    "installation onSuccess called in `%s` Thread (%d)",
                                    Thread.currentThread().getName(),
                                    Thread.currentThread().getId()));

                            registering = false;
                            registeredOnce = true;
                            installationRetries = 0;

                            Logger.i(Constants.TAG, "Device saved: " + installationModel.getId());

                            eventBus.post(REGISTERED);

                            if (finalThis.registerCallback != null) {
                                finalThis.registerCallback.onSuccess(finalThis.userId.asString());
                                finalThis.registerCallback = null;
                            }

                            //Send get request for getting deferred deep-link.
                            if (isNewInstall &&
                                    (onDeeplinkResponseListener != null || deferredDataListener != null)) {
                                getDeferredDeepLink();
                            }

                            _isLoggedInNow = false;
                            isNewInstall = false;
                            userHash = "";
                            isLaunched = false;

                            getSharedPreferences().edit().putBoolean("chabokInstallation", true).apply();

                            if (restartService) {
                                AdpPushClient.get().makeSubsDirty();
                                PushService.performAction(getApplicationContext(), "RESTART");
                            } else {
                                PushService.performAction(getApplicationContext(), "START");
                            }

                            Logger.d(TAG, "_installationLatch countdown");

                            _installationLatch.countDown();
                        }

                        @Override
                        public void onFailure(Throwable t) {
                            Logger.d(TAG, "installation.save().onError()");

                            Logger.d(TAG, String.format(Locale.getDefault(),
                                    "installation onError called in `%s` Thread (%d)",
                                    Thread.currentThread().getName(),
                                    Thread.currentThread().getId()));

                            registering = false;
                            registeredOnce = false;

                            if (finalThis.registerCallback != null) {
                                finalThis.registerCallback.onFailure(t);
                                finalThis.registerCallback = null;
                            }

                            Logger.e(TAG, "Cannot save device, Reason: " + t.getMessage(), t);

                            eventBus.post(ConnectionStatus.DISCONNECTED);
                            eventBus.post(ChabokCommunicateStatus.FailInstallationReq);

                            retryRegistrationBackoff();

                            Logger.d(TAG, "_installationLatch countdown");

                            _installationLatch.countDown();
                        }
                    });

                    Logger.d(TAG, "_installationLatch await");

                    try {
                        _installationLatch.await();
                    } catch (InterruptedException e) {
                        e.printStackTrace();

                        Logger.e(TAG, "_installationLatch interrupted");
                    }

                    Logger.d(TAG, "_installationLock released");
                }
                return true;
            }

            @Override
            protected void onPostExecute(final Boolean registered) {
                // nothing!
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null, null, null);
    }

    public static Map<String, Object> beforeSend(Map<String, Object> params) {
        return AdpPushClient.get()._beforeSend(params);
    }

    private Map<String, Object> _beforeSend(Map<String, Object> params) {

        try {
//            if (isGuestUser()) {
//                ArrayList<String> guestTags = new ArrayList<String>();
//                guestTags.add(GUEST_TAG);
//                params.put("tags", guestTags);
//            }

            params.put("isGuest", isGuestUser());
            params.put("registerTs", getRegisterTs());

            long lt = getAppLaunchTime();
            Integer l = String.valueOf(JsonUtils.mapToJson(params))
                    .replaceAll("(\\\\.)", "/")
                    .length();

            String type = params.get("deviceType") + "";

            String ui = getUniqueID();
            if (ui == null) {
                ui = "";
            }
            String manId = ChabokUtils.getManufacturerId(getSecureUserId(), ui, type, lt, l);
            if (manId != null) {
                params.put("manufacturerId", manId);
            }

        } catch (JSONException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return params;
    }

    private String getPlayAdId(Context context) {
        String playAdId = null;
        // Based on Adjust Android SDK:
        // https://github.com/adjust/android_sdk/blob/21355ae9a2b802bbc82dfb3582ea2142c5739d1b/Adjust/sdk-core/src/main/java/com/adjust/sdk/Util.java#L215
        long timeoutServiceMilli = Constants.ONE_SECOND * 11;

        for (int i = 0; i < 3; i += 1) {
            try {
                GooglePlayServicesClient.GooglePlayServicesInfo gpsInfo = GooglePlayServicesClient.getGooglePlayServicesInfo(context, timeoutServiceMilli);
                playAdId = gpsInfo.getGpsAdid();
                if (playAdId != null) {
                    break;
                }
            } catch (Exception e) {
            }
            playAdId = Reflection.getPlayAdId(context);
            if (playAdId != null) {
                break;
            }
        }
        return playAdId;
    }

    private boolean isPlayTrackingEnabled(Context context) {
        Boolean isTrackingEnabled = null;
        // Based on Adjust Android SDK:
        // https://github.com/adjust/android_sdk/blob/21355ae9a2b802bbc82dfb3582ea2142c5739d1b/Adjust/sdk-core/src/main/java/com/adjust/sdk/Util.java#L215
        long timeoutServiceMilli = Constants.ONE_SECOND * 11;

        for (int i = 0; i < 3; i += 1) {
            try {
                GooglePlayServicesClient.GooglePlayServicesInfo gpsInfo = getGooglePlayServicesInfo(context, timeoutServiceMilli);
                isTrackingEnabled = gpsInfo.isTrackingEnabled();
                if (isTrackingEnabled != null) {
                    break;
                }
            } catch (Exception e) {
            }
            isTrackingEnabled = Reflection.isPlayTrackingEnabled(context);
            if (isTrackingEnabled != null) {
                break;
            }
        }
        if (isTrackingEnabled == null) {
            return false;
        }
        return isTrackingEnabled;
    }

    private String getInstallSource() {
        try {
            if (context != null) {
                if (context.getPackageManager() != null) {
                    PackageManager pm = context.getPackageManager();

                    if (context.getPackageName() != null) {
                        String installationSource = pm.getInstallerPackageName(context.getPackageName());

                        if (installationSource != null) {
                            return installationSource;
                        }
                    }
                }
            }
        } catch (Exception exc) {
            exc.printStackTrace();
        }
        return "notSet";
    }

    @Nullable
    private String getDeviceScreenResolution() {
        if (currentActivity == null || currentActivity.get() == null) {
            return null;
        }
        WindowManager windowManager = currentActivity.get().getWindowManager();
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);


        // since SDK_INT = 1;
        int mWidthPixels = displayMetrics.widthPixels;
        int mHeightPixels = displayMetrics.heightPixels;

        // includes window decorations (statusbar bar/menu bar)
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
            try {
                mWidthPixels = (Integer) Display.class.getMethod("getRawWidth").invoke(display);
                mHeightPixels = (Integer) Display.class.getMethod("getRawHeight").invoke(display);
            } catch (Exception ignored) {
            }
        }

        // includes window decorations (statusbar bar/menu bar)
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point realSize = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke(display, realSize);
                mWidthPixels = realSize.x;
                mHeightPixels = realSize.y;
            } catch (Exception ignored) {
            }
        }

        return mWidthPixels + "x" + mHeightPixels;
    }

    HashMap<String, HashMap> getNotificationSettings() {
        if (notificationSettings != null) {
            HashMap<String, HashMap> notifSettings = new HashMap<>();
            Iterator<String> channelSettings = notificationSettings.keys();
            while (channelSettings.hasNext()) {
                String topic = channelSettings.next();
                JSONObject channelSetting = notificationSettings.optJSONObject(topic);
                HashMap<String, String> setting = new HashMap<>();
                setting.put("alert", channelSetting.optString("alert", null));
                setting.put("sound", channelSetting.optString("sound", null));
                notifSettings.put(topic, setting);
            }
            return notifSettings;
        }
        return null;
    }

    private void retryRegistrationBackoff() {
        if (++installationRetries <= TOTAL_RETRIES) {
            Runnable retryTask = new Runnable() {
                public void run() {
                    Logger.d(TAG, "retryRegistration started");

                    Logger.d(TAG, String.format(Locale.getDefault(),
                            "retryRegistration called in `%s` Thread (%d)",
                            Thread.currentThread().getName(),
                            Thread.currentThread().getId()));

                    doRegister();
                }
            };
            long nextTry = (long) Math.max(Math.pow(2, installationRetries), 32);

            Logger.d(TAG, String.format(Locale.getDefault(),
                    "retryRegistration with `%d` seconds Backoff",
                    nextTry));

            worker.schedule(retryTask, nextTry, TimeUnit.SECONDS);
        }
    }

    private void retryGetTokenBackoff() {
        if (++tokenRetries <= 5) {
            Runnable retryTask = new Runnable() {
                public void run() {
                    Logger.d(TAG, "retryGetToken started");

                    Logger.d(TAG, String.format(Locale.getDefault(),
                            "retryGetToken called in `%s` Thread (%d)",
                            Thread.currentThread().getName(),
                            Thread.currentThread().getId()));

                    getToken(false);
                }
            };
            long nextTry = (long) Math.max(Math.pow(2, tokenRetries), 10);

            Logger.d(TAG, String.format(Locale.getDefault(),
                    "retryGetToken with `%d` seconds Backoff",
                    nextTry));

            tokenWorker.schedule(retryTask, nextTry, TimeUnit.SECONDS);
        }
    }

    /**
     * @deprecated reason this method is deprecated </br>
     * android.os.Build.SERIAL was not reliable enough for keep our device uniqueness </br>
     * <p>
     * We should use getUniqueID() method
     */
    // warning: android.os.Build.SERIAL was not reliable enough for keep our device uniqueness
    @Deprecated
    private String getDeviceId() {
        return android.os.Build.SERIAL;
    }

    /**
     * Get unique device id with ANDROID_ID. It will replace `DeviceId` in old version.
     *
     * @return 64bit hex string.
     */
    private String getUniqueID() {
        String device_unique_id = Settings.Secure.getString(context.getContentResolver(),
                Settings.Secure.ANDROID_ID);
        return device_unique_id;
    }

    public String getClientVersion() {
        String userClientVersion = ChabokCrypto.decrypt(context,
                getSharedPreferences().getString("clientVersion", null));
        if (userClientVersion == null) {
            try {
                PackageInfo packageInfo = getApplicationContext().getPackageManager()
                        .getPackageInfo(context.getPackageName(), 0);
                userClientVersion = packageInfo.versionName;
            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return userClientVersion;
    }

    public void setClientVersion(String version) {
        getSharedPreferences().edit().putString("clientVersion", ChabokCrypto.encrypt(context, version)).apply();
    }

    public void incBadge() {
        if (AdpPushClient.get().isForeground()) {
            return;
        }

        int currentBadge = getSharedPreferences().getInt("androidBadge", 0);
        setBadge(++currentBadge);
    }

    boolean isBadgeEnabled() {
        try {
            if (context != null) {
                ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                Bundle bundle = ai.metaData;
                if (bundle != null) {
                    String badgeStatus = bundle.getString(USE_BADGE_COUNT);
                    if (badgeStatus != null && badgeStatus.toLowerCase().equals("disable")) {
                        return false;
                    }
                }
                if (!ShortcutBadger.isBadgeCounterSupported(context)) {
                    return false;
                }
            }
        } catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG, "isBadgeEnabled: NameNotFoundException -->", e);
        } catch (NullPointerException e) {
            Logger.e(TAG, "isBadgeEnabled: NullPointerException -->", e);
        }
        return true;
    }

    boolean isEnabledRealtime() {
        try {
            // check json config files
            if (config != null) {
                if (!config.realtime()) {
                    Logger.i(TAG, String.format(Locale.getDefault(),
                            "Chabok realtime is disabled. To enable set realtime in Chabok.%s.json file to true.",
                            config.environment()));
                    return false;
                }
                return true;
            }
            // check shared preferences
            if (getSharedPreferences().contains("CHK_DISABLE_REALTIME")) {
                return !getSharedPreferences().getBoolean("CHK_DISABLE_REALTIME", true);
            }
            // check AndroidManifest.xml meta tags
            if (context != null) {
                ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                Bundle bundle = ai.metaData;
                if (bundle != null && bundle.containsKey(DISABLE_REALTIME)) {
                    //return bundle.getBoolean(DISABLE_REALTIME);
                    Logger.i(Logger.TAG, DISABLE_REALTIME + " meta-data does not support anymore.");
                    if (config != null) {
                        Logger.i(Logger.TAG, String.format(Locale.getDefault(),
                                "For config realtime change it from Chabok.%s.json file.",
                                config.environment()));
                    }
                }
            }
        } catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG, "isEnabledRealtime: NameNotFoundException -->", e);
        } catch (NullPointerException e) {
            Logger.e(TAG, "isEnabledRealtime: NullPointerException -->", e);
        }
        return true;
    }

    boolean isEnabledPushNotification() {
        if (config == null || config.pushNotification()) {
            return true;
        }
        Logger.w(TAG, "Chabok push notification has been disabled in configuration.");
        return false;
    }

    /**
     * @deprecated As of release v3.0.0, because we added chabok gradle plugin use json configuration files instead.
     *             @see <a href="https://chabok.io">Chabok Initialization</a>
     */
    @Deprecated
    public void setEnableRealtime(boolean enableRealtime){
        getSharedPreferences()
                .edit()
                .putBoolean("CHK_DISABLE_REALTIME", !enableRealtime)
                .apply();
    }

    /**
     * To prevent show notification by your self
     *
     * @deprecated As of release v3.0.0, replaced by {@link ChabokFirebaseMessaging#isChabokPushNotification(Bundle)}
     *             @see <a href="https://chabok.io">Chabok Initialization</a>
     *
     * @param data is GCM push notification in onMessageReceived callback.
     * @return is chabok push notification or not
     */
    @Deprecated
    public boolean isChabokPushNotification(Bundle data){
        return data != null && data.containsKey("fromChabok");
    }

    /**
     * To prevent show notification by your self
     *
     * @deprecated As of release v3.0.0, replaced by {@link ChabokFirebaseMessaging#isChabokPushNotification(Map)}
     *             @see <a href="https://chabok.io">Chabok Initialization</a>
     *
     * @param data is FCM push notification in onMessageReceived callback.
     * @return is chabok push notification or not
     */
    @Deprecated
    public boolean isChabokPushNotification(Map<String, String> data){
        return data != null && data.containsKey("fromChabok");
    }

    /**
     * If user add <meta-data android:name="com.adpdigital.push.client.ADVERTISING_ID_ENABLED" android:value="DISABLE" /> to AndroidManifest.xml file
     * Chabok didn't get user advertingId from the google play services.
     *
     * @return Can get advertingId
     */
    boolean isAdvertisingIdEnabled() {
        try {
            if (context != null) {
                ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                Bundle bundle = ai.metaData;
                if (bundle != null) {
                    String advertisingIdStatus = bundle.getString(ADVERTISING_ID_ENABLED);
                    if (advertisingIdStatus != null && advertisingIdStatus.toLowerCase().equals("disable")) {
                        return false;
                    }
                }
            }
        } catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG, "isAdvertisingIdEnabled: NameNotFoundException -->", e);
        } catch (NullPointerException e) {
            Logger.e(TAG, "isAdvertisingIdEnabled: NullPointerException -->", e);
        }
        return true;
    }

    int getDefaultNotificationIconIdFromMetadata () {
        try {
            if (context != null) {
                ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                Bundle bundle = ai.metaData;
                if (bundle != null) {
                    int defaultIcon = -1;
                    if (bundle.containsKey(FB_DEFAULT_NOTIFICATION_ICON)){
                        defaultIcon = bundle.getInt(FB_DEFAULT_NOTIFICATION_ICON);
                        if (defaultIcon > -1) {
                            return defaultIcon;
                        }
                    }

                    if (bundle.containsKey(CHABOK_DEFAULT_NOTIFICATION_ICON)) {
                        defaultIcon = bundle.getInt(CHABOK_DEFAULT_NOTIFICATION_ICON);
                    }

                    return defaultIcon;
                }
            }
        } catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG, "getDefaultNotificationIconFromMetadata: NameNotFoundException -->", e);
        } catch (NullPointerException e) {
            Logger.e(TAG, "getDefaultNotificationIconFromMetadata: NullPointerException -->", e);
        }
        return -1;
    }


    int getDefaultNotificationColorFromMetadata () {
        try {
            if (context != null) {
                ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
                Bundle bundle = ai.metaData;
                if (bundle != null) {
                    int color = -1;
                    if (bundle.containsKey(FB_DEFAULT_NOTIFICATION_COLOR)){
                        color = bundle.getInt(FB_DEFAULT_NOTIFICATION_COLOR);
                        if (color > -1) {
                            return context.getResources().getColor(color);
                        }
                    }

                    if (bundle.containsKey(CHABOK_DEFAULT_NOTIFICATION_COLOR)) {
                        color = bundle.getInt(CHABOK_DEFAULT_NOTIFICATION_COLOR);
                    }

                    return context.getResources().getColor(color);
                }
            }
        } catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG, "getDefaultNotificationColorFromMetadata: NameNotFoundException -->", e);
        } catch (NullPointerException e) {
            Logger.e(TAG, "getDefaultNotificationColorFromMetadata: NullPointerException -->", e);
        } catch (Exception e){
            Logger.e(TAG, "getDefaultNotificationColorFromMetadata: Exception -->", e);
        }
        return -1;
    }

    private void updateLaunchStats() {
        this.lastLaunchTime = getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, -1);

        int count = getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
        getSharedPreferences().edit().putInt(APPLICATION_LAUNCH, ++count).apply();
        getSharedPreferences().edit().putLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis()).apply();
        isLaunched = true;
    }


    public int getAppLaunchCount() {
        return getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
    }


    public long getAppLaunchTime() {
        return getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, System.currentTimeMillis());
    }

    public long getLastAppLaunchTime() {
        return this.lastLaunchTime;
    }

    public SecureString getReregisteredFrom() {
        return ChabokLocalStorage.getReregisteredFrom(getApplicationContext());
    }


    public int getBadge() {
        return getSharedPreferences().getInt("androidBadge", 0);
    }

    AdpPushClient setBadge(int badgeNumber) {
        getSharedPreferences()
                .edit()
                .putInt("androidBadge", badgeNumber)
                .apply();
        eventBus.post(new BadgeUpdate(badgeNumber));
        if (isBadgeEnabled()) {
            boolean isAppliedBadge = ShortcutBadger.applyCount(getApplicationContext(), badgeNumber);
            if (!isAppliedBadge) {
                Logger.i(TAG, "Could not apply the badge " + badgeNumber);
            }
        }
        return this;
    }

    public AdpPushClient resetBadge() {
        // Cancel All notifications...
        NotificationManager mNotificationManager = (NotificationManager)
                getApplicationContext().getSystemService(Context.NOTIFICATION_SERVICE);
        mNotificationManager.cancelAll();
        SharedPreferences.Editor editor = getSharedPreferences().edit();
//        for (String key : getSharedPreferences().getAll().keySet()) {
//            if (key.startsWith("gcm_notif_to_uuid_")) {
//                editor.remove(key);
//            }
//        }
        editor.putInt("androidUnseenBadge", 0);
        editor.apply();
        return setBadge(0);
    }

//    private void unregister() {
//        unregister(false);
//    }

    private void unregister(boolean isReregister) {
        if (!isReregister) {
            deleteInstallation(new com.adpdigital.push.Callback<InstallationModel>() {
                @Override
                public void onSuccess(InstallationModel device) {
                    Logger.w(TAG, "Deleted " + device.getId() + ": " + device);
                }

                @Override
                public void onFailure(Throwable value) {
                    Logger.e(TAG, "Delete Error " + value);
                }
            });
        }

        ChabokLocalStorage.removeUserId(context);
        try {
            if ((getGuestUserId() == null || this.userId.asString() == null) ||
                    this.userId.asString().equalsIgnoreCase(getGuestUserId())) {
                getSharedPreferences().edit().remove("CHK_GUI").apply();
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        if (!isReregister) {
            getSharedPreferences().edit().remove(PROPERTY_DEVICE_TOKEN).apply();
            getSharedPreferences().edit().remove(PROPERTY_INSTALLATION_ID).apply();
        }

         //TODO: Not sure need to remove referrer data or not.

//        getSharedPreferences().edit().remove("CHK_INSTALL_REFERRER").apply();
//        getSharedPreferences().edit().remove("CHK_INSTALL_REF_CLICK_TS_L").apply();
//        getSharedPreferences().edit().remove("CHK_INSTALL_REF_BEGIN_TS_L").apply();
//        getSharedPreferences().edit().remove("CHK_RAW_INSTALL_REFERRER").apply();
//        getSharedPreferences().edit().remove("CHK_RAW_INSTALL_REF_CLICK_TS_L").apply();



        ChabokLocalStorage.removeTopicsFromStorage(getApplicationContext());

        getSharedPreferences().edit().remove("subscriptionDirty").apply();
        getSharedPreferences().edit().remove("offlineCache").apply();
        getSharedPreferences().edit().remove("pendingInAppMsgs").apply();
        getSharedPreferences().edit().remove("dataCache").apply();

        this.channels = new String[]{
                Constants.DEFAULT_CHANNEL
        };

        PushService.performAction(getApplicationContext(), "DISCONNECT");
    }

    public String getInstallationId() {
        String idJson = ChabokCrypto.decrypt(context,
                getSharedPreferences().getString(PROPERTY_INSTALLATION_ID, null));
        if (idJson != null) {
            try {
                return (String) (new JSONArray(idJson)).get(0);
            } catch (JSONException var5) {
                String currentVersionCode = "Cannot parse installation id \'" + idJson + "\'";
                Logger.e(TAG, currentVersionCode, var5);
            }
        }
        return null;
    }

    private void deleteInstallation(final com.adpdigital.push.Callback callback) {
        final InstallationModel installationModel = new InstallationModel(getApplicationContext());

        if (installationModel.getId() == null) {
            Logger.w(TAG, "------ Warning : Device was unregistered before!! -------");
            return;
        }

        RemoteRepository.deleteInstallation(installationModel, new Callback() {
            @Override
            public void onSuccess(Object value) {
                if (callback != null) {
                    callback.onSuccess(installationModel);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                if (callback != null) {
                    callback.onFailure(t);
                }
            }
        });
    }

    private void updateInstallation(Map<String, Object> properties) {
        updateInstallation(properties, new com.adpdigital.push.Callback<InstallationModel>() {
            @Override
            public void onSuccess(InstallationModel value) {
            }

            @Override
            public void onFailure(Throwable value) {
            }
        });
    }

    private void updateInstallation(Map<String, Object> properties,
                                    final com.adpdigital.push.Callback<InstallationModel> clbk) {
        eventBus.post(ChabokCommunicateStatus.UpdatingInstallation);

        final InstallationModel installationModel = new InstallationModel(getApplicationContext());
        installationModel.setAppId(getAppId());
        installationModel.setAppVersion(SDK_VERSION);
        installationModel.setUserId(getSecureUserId());
        installationModel.setSubscriptions(channels);
        properties.put("launched", isLaunched);
        properties.put("newInstall", isNewInstall);
        properties.put("launchTime", getAppLaunchTime());
        properties.put("realtime", isEnabledRealtime());

        if (getLastAppLaunchTime() > 0) {
            properties.put("lastLaunchTime", getLastAppLaunchTime());
        }
        String uniqueId = getUniqueID();
        if (uniqueId != null && !uniqueId.isEmpty()) {
            properties.put("uniqueId", uniqueId);
        }

        try {
            String appSignature = DeviceUtil.getAppSignature(context);
            if (appSignature != null) {
                properties.put("appSessionId", appSignature);
            } else {
                properties.put("appSessionId", "INVALID");
            }
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        properties.put("appTokenId", DeviceUtil.base64CreateFingerprint(context));

        properties.put("mobileOperator", DeviceUtil.getMobileOperator(context));

        JSONArray cachedData = communicateFallbackMachine.getReadyToSendEventData();
        if (cachedData != null) {
            properties.put("eventData", cachedData);
        }

        if (this.userInfo != null && !this.userInfo.isEmpty()) {
            properties.put("userInfo", this.userInfo);
        }

        updateInstallation(installationModel, properties, clbk);
    }

    private InstallationModel getInstallationModel() {
        final InstallationModel installationModel = new InstallationModel(getApplicationContext());
        installationModel.setAppId(getAppId());
        installationModel.setAppVersion(SDK_VERSION);
        installationModel.setUserId(getSecureUserId());
        installationModel.setSubscriptions(channels);
        return installationModel;
    }

    private void updateInstallation(final InstallationModel installationModel,
                                    final Map<String, Object> properties,
                                    final com.adpdigital.push.Callback<InstallationModel> clbk) {

        new AsyncTask<Void, Void, Boolean>() {
            @Override
            protected Boolean doInBackground(final Void... params) {

                RemoteRepository.updateInstallation(installationModel, properties, installationModel.getRequireParams(), new Callback() {
                    @Override
                    public void onSuccess(Object value) {
                        eventBus.post(ChabokCommunicateStatus.InstallationSuccessfullySent);

                        if (clbk != null) {
                            clbk.onSuccess(installationModel);
                        }
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        eventBus.post(ChabokCommunicateStatus.FailInstallationReq);

                        if (clbk != null) {
                            clbk.onFailure(t);
                        }
                    }
                });
                return true;
            }

            @Override
            protected void onPostExecute(final Boolean registered) {
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null, null, null);
    }

    public void requestVerificationCode(String userId, String media, final com.adpdigital.push.Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        RemoteRepository.requestCode(userId,appId,media,clbk);
    }

    private void requestCode(String userId, final com.adpdigital.push.Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (userId == null) {
            Logger.e(Logger.TAG, "userId is null. Please provide a userId for request code");
            return;
        }

        RemoteRepository.requestCode(SecureString.instance(userId).asString(),null,null,clbk);
    }


    public void requestVerificationCode(String userId, final com.adpdigital.push.Callback clbk) {
//        requestVerificationCode(userId, "sms", clbk);
        requestCode(userId, clbk);
    }

    public void verifyUserCode(String userId, String code, final com.adpdigital.push.Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        Map<String, Object> map = new HashMap<>();
        map.put("userId", userId);
        map.put("code", code);

        RemoteRepository.verifyUserCode(userId,code, clbk);
    }

    boolean isFreshStart() {
        return isFreshStart;
    }

    public boolean isForeground() {
        return getForegroundManager().isForeground();
    }

    public boolean isFocused() {
        return
                isForeground()
                        &&
                        getActivityClass(this.getApplicationContext()).getName().equals(getForegroundManager().getActiveActivityClassName());
    }

    public boolean isBackground() {
        return getForegroundManager().isBackground();
    }

    public AdpPushClient addAppListener(AppListener listener) {
        getForegroundManager().addListener(listener);
        return this;
    }

    private ForegroundManager getForegroundManager() {
        return this.foreground;
    }

    public Class getActivityClass() {
        return activityClass;
    }

    private Context getApplicationContext() {
        return context;
    }

//    public String getSenderId() {
//        return this.senderId;
//    }

    public String getUserId() {
        return this.getSecureUserId().asString();
    }

    private SecureString getSecureUserId() {
        return ChabokLocalStorage.getUserId(getApplicationContext());
    }

    public void setAutoResetBadge(boolean autoResetBadge) {
        getSharedPreferences().edit().putBoolean("CHK_AUTO_RESET_BADGE", autoResetBadge).apply();
    }

    public boolean isAutoResetBadge() {
        return getSharedPreferences().getBoolean("CHK_AUTO_RESET_BADGE", true);
    }

    public boolean isRegistered() {
        return getSharedPreferences().getString(PROPERTY_INSTALLATION_ID, null) != null;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getNotificationIcon() {
        if (notificationIcon == -1) {
            try {
                int appIcon = getDefaultNotificationIconIdFromMetadata();
                if (appIcon > -1){
                    return appIcon;
                }

                PackageInfo packageInfo = getApplicationContext()
                        .getPackageManager()
                        .getPackageInfo(getApplicationContext().getPackageName(), 0);
                ApplicationInfo appInfo = getApplicationContext()
                        .getPackageManager()
                        .getApplicationInfo(packageInfo.packageName, 0);
                return appInfo.icon;
            } catch (PackageManager.NameNotFoundException e) {
                return -1;
            }
        }
        return notificationIcon;
    }

    public void setNotificationIcon(int notificationIcon) {
        this.notificationIcon = notificationIcon;
    }

    public int getNotificationIconSilhouette() {
        if (notificationIconSilhouette == -1) {
            return getNotificationIcon();
        }
        return notificationIconSilhouette;
    }

    public void setNotificationIconSilhouette(int notificationIconSilhouette) {
        this.notificationIconSilhouette = notificationIconSilhouette;
    }

    private long getRegisterTs() {
        return getSharedPreferences().getLong("CHK_REGISTER_TS", 0);
    }

    private void setRegisterTs(long registerTs) {
        getSharedPreferences().edit().putLong("CHK_REGISTER_TS", registerTs).apply();
    }

    private boolean isGuestUser() {
        return getGuestUserId() != null;
    }

    public boolean isLoggedIn(){
        return !this.isGuestUser();
    }

    private void setGuestUserId(String guestUserId) {
        if (guestUserId == null) {
            getSharedPreferences().edit().remove("CHK_GUI").apply();
        } else {
            getSharedPreferences().edit().putString("CHK_GUI", ChabokCrypto.encrypt(context, guestUserId)).apply();
        }
    }

    private String getGuestUserId() {
        String guestUserId = getSharedPreferences().getString("CHK_GUI", null);
        if (guestUserId != null) {
            return ChabokCrypto.decrypt(context, guestUserId);
        }
        return null;
    }

    public void unsetUserAttribute(String attributeKey) {
        unsetUserAttributes(new String[]{attributeKey});
    }

    public void unsetUserAttributes(String[] attributeKeys) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (attributeKeys == null || attributeKeys.length == 0) {
            Logger.e(TAG, "attribute keys parameter should has a value.");
            return;
        }

        JSONObject metadata = new JSONObject();
        try {
            JSONObject keys = new JSONObject();
            for (String key : attributeKeys) {
                keys.put(key, new JSONObject().put("operation", "unset"));
            }
            metadata.put("keys", keys);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        setUserAttributesInternal(new HashMap<String, Object>(), metadata, null);
    }

    public void addToUserAttributeArray(String attributeKey, String attributeValue) {
        addToUserAttributeArrayInternal(attributeKey, new String[]{attributeValue}, null);
    }

    public void addToUserAttributeArray(String attributeKey, String[] attributeValues) {
        addToUserAttributeArrayInternal(attributeKey, attributeValues, null);
    }

    private void addToUserAttributeArray(String attributeKey, Integer attributeValue) {
        addToUserAttributeArrayInternal(attributeKey, new Integer[]{attributeValue}, null);
    }

    private void addToUserAttributeArray(String attributeKey, Integer[] attributeValues) {
        addToUserAttributeArrayInternal(attributeKey, attributeValues, null);
    }

    public void removeFromUserAttributeArray(String attributeKey, String attributeValue) {
        removeFromUserAttributeArrayInternal(attributeKey, new String[]{attributeValue}, null);
    }

    public void removeFromUserAttributeArray(String attributeKey, String[] attributeValues) {
        removeFromUserAttributeArrayInternal(attributeKey, attributeValues, null);
    }

    private void removeFromUserAttributeArray(String attributeKey, Integer attributeValue) {
        removeFromUserAttributeArrayInternal(attributeKey, new Integer[]{attributeValue}, null);
    }

    private void removeFromUserAttributeArray(String attributeKey, Integer[] attributeValues) {
        removeFromUserAttributeArrayInternal(attributeKey, attributeValues, null);
    }

    private void addToUserAttributeArrayInternal(String attributeKey,
                                                 Object[] attributeValues,
                                                 Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (attributeKey == null || attributeKey.isEmpty()) {
            Logger.e(TAG, "attribute key parameter should has a value.");
            return;
        }

        if (attributeValues == null || attributeValues.length <= 0) {
            Logger.e(TAG, "attribute values parameter should have a value.");
            return;
        }

        JSONObject metadata = new JSONObject();
        try {
            metadata.put("keys", new JSONObject()
                    .put(attributeKey, new JSONObject()
                            .put("operation", "addToArray")
                            .put("type", "array")
                            .put("value", DataConverter.toJSONArray(attributeValues))));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        setUserAttributesInternal(new HashMap<String, Object>(), metadata, callback);
    }

    private void removeFromUserAttributeArrayInternal(String attributeKey,
                                                      Object[] attributeValues,
                                                      Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (attributeKey == null || attributeKey.isEmpty()) {
            Logger.e(TAG, "attribute key parameter should has a value.");
            return;
        }

        if (attributeValues == null || attributeValues.length <= 0) {
            Logger.e(TAG, "attribute values parameter should have a value.");
            return;
        }

        JSONObject metadata = new JSONObject();
        try {
            metadata.put("keys", new JSONObject()
                    .put(attributeKey, new JSONObject()
                            .put("operation", "removeFromArray")
                            .put("type", "array")
                            .put("value", DataConverter.toJSONArray(attributeValues))));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        setUserAttributesInternal(new HashMap<String, Object>(), metadata, callback);
    }

    /**
     * This method is for getting user attributes such as first name, last name, age, gender and etc
     *
     * @return user attributes
     */
    public HashMap<String, Object> getUserAttributes() {
        try {
            try {
                String jsonStringEnc = getSharedPreferences().getString(Constants.CHK_USER_INFO, null);
                if (jsonStringEnc != null) {
                    JSONObject jsonObject = new JSONObject(ChabokCrypto.decrypt(context, jsonStringEnc));
                    return (HashMap<String, Object>) DataConverter.fromJson(jsonObject);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
            return null;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void setUserAttributesInternal(HashMap<String, Object> attributes,
                                           JSONObject metadata,
                                           final Callback callback) {
        if (isRegistered()) {
            RemoteRepository.userInfo(getInstallationId(), attributes, metadata, new Callback() {
                @Override
                public void onSuccess(Object value) {
                    Logger.d(TAG, "Successfully send attribute data.");

                    try {
                        JSONObject obj = new JSONObject(value.toString());
                        saveUserAttributes(MapUtils.jsonObjectToMap(obj));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                    if (callback != null) {
                        callback.onSuccess(value);
                    }
                }

                @Override
                public void onFailure(Throwable value) {
                    Logger.e(TAG, "Fail to send attribute data. ", value);
                    if (callback != null) {
                        callback.onFailure(value);
                    }
                }
            });
        }
    }

    private void saveUserAttributes(HashMap<String, Object> attributes) {
        if (attributes == null) {
            return;
        }

        this.userInfo = attributes;
        try {
            JSONObject json = new JSONObject(this.userInfo);
            getSharedPreferences().edit().putString(Constants.CHK_USER_INFO,
                    ChabokCrypto.encrypt(context, json.toString())).apply();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * This method is for gathering user attributes such as first name, last name, age, gender and etc
     *
     * @param attributes
     */
    public void setUserAttributes(Bundle attributes) {
        setUserAttributes(attributes, null);
    }

    /**
     * This method is for gathering user attributes such as first name, last name, age, gender and etc
     *
     * @param attributes
     */
    private void setUserAttributes(Bundle attributes, final Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (attributes == null) {
            Logger.e(TAG, "attributes parameter should have a value. " +
                    "To removing attributes data, provide an empty Bundle");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes parameter should have a value. " +
                        "To removing attributes data, provide an empty Bundle"));
            }
            return;
        }

        JSONObject metadata = prepareMetaData(attributes);
        HashMap<String, Object> userInfoMap = (HashMap<String, Object>) DataConverter.bundleToMap(attributes);

        if (userInfoMap == null) {
            Logger.e(TAG, "cannot convert attributes parameter to map.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("cannot convert attributes parameter to map."));
            }
            return;
        }

        // save user attributes in local storage
        saveUserAttributes(userInfoMap);

        // send user attributes to server
        setUserAttributesInternal(userInfoMap, metadata, callback);
    }

    /**
     * This method is for gathering user attributes such as first name, last name, age, gender and etc
     *
     * @param attribute
     */
    public void setUserAttributes(HashMap<String, Object> attribute) {
        setUserAttributes(attribute, null);
    }

    /**
     * This method is for gathering user attributes such as first name, last name, age, gender and etc
     *
     * @param attribute
     */
    private void setUserAttributes(HashMap<String, Object> attribute, final Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (attribute == null) {
            Logger.e(TAG, "attribute parameter should has a value. " +
                    "To removing attribute data, provide an empty HashMap");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attribute parameter should has a value. " +
                        "To removing attribute data, provide an empty HashMap"));
            }
            return;
        }

        // add metadata for datetime values
        JSONObject metadata = prepareMetaData(attribute);

        // save user attributes in local storage
        saveUserAttributes(attribute);

        // send user attributes to server
        setUserAttributesInternal(attribute, metadata, callback);
    }

    /**
     * Increment user attributes are useful for storing the number of times a given action or event has occurred without counting against your data cap.
     * for example : (Recording shoe size, waist size, number of times a user has viewed a certain product feature, or category.
     *
     * @param attributeName is name of attribute wants to increment.
     */
    public void incrementUserAttribute(String attributeName) {
        incrementUserAttribute(attributeName, 1, null);
    }

    /**
     * Increment user attributes are useful for storing the number of times a given action or event has occurred without counting against your data cap.
     * for example : (Recording shoe size, waist size, number of times a user has viewed a certain product feature, or category.
     *
     * @param attributeName is name of attribute wants to increment.
     */
    private void incrementUserAttribute(String attributeName, Callback callback) {
        incrementUserAttribute(attributeName, 1, callback);
    }

    /**
     * Increment user attributes are useful for storing the number of times a given action or event has occurred without counting against your data cap.
     * for example : (Recording shoe size, waist size, number of times a user has viewed a certain product feature, or category.
     *
     * @param attributeName is name of attribute wants to increment.
     * @param value         is double value by which you want to increment the attribute
     */
    public void incrementUserAttribute(final String attributeName, final double value) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (attributeName == null) {
            Logger.e(TAG, "attributeName is null. Please provide an attributeName");
            return;
        }

        HashMap<String, Double> attributesArray = new HashMap<>();

        attributesArray.put(attributeName, value);

        incrementUserAttribute(attributesArray, null);
    }

    /**
     * Increment user attributes are useful for storing the number of times a given action or event has occurred without counting against your data cap.
     * for example : (Recording shoe size, waist size, number of times a user has viewed a certain product feature, or category.
     *
     * @param attributeName is name of attribute wants to increment.
     * @param value         is double value by which you want to increment the attribute
     */
    private void incrementUserAttribute(final String attributeName, final double value, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (attributeName == null) {
            Logger.e(TAG, "attributeName is null. Please provide an attributeName");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributeName is null. Please provide an attributeName"));
            }
            return;
        }

        HashMap<String, Double> attributesArray = new HashMap<>();

        attributesArray.put(attributeName, value);

        incrementUserAttribute(attributesArray, callback);
    }

    public void incrementUserAttribute(ArrayList<String> attributes) {
        incrementUserAttribute(attributes, null);
    }

    private void incrementUserAttribute(ArrayList<String> attributes, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (attributes == null) {
            Logger.e(TAG, "attributes is null. Please provide an attribute");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes is null. Please provide an attribute"));
            }
            return;
        }

        HashMap<String, Double> attributesArray = new HashMap<>();

        for (String attribute : attributes) {
            attributesArray.put(attribute, 1.0);
        }

        incrementUserAttribute(attributesArray, callback);
    }

    public void incrementUserAttribute(final HashMap<String, Double> attributes) {
        incrementUserAttribute(attributes, null);
    }

    private void incrementUserAttribute(final HashMap<String, Double> attributes, final Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (attributes == null) {
            Logger.e(TAG, "attributes parameter is null. please, provide an attribute");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes parameter is null. please, provide an attribute"));
            }
            return;
        }

        JSONArray attributesArray = new JSONArray();

        Set<Map.Entry<String, Double>> set = attributes.entrySet();

        for (Map.Entry<String, Double> me : set) {
            JSONObject attribute = new JSONObject();
            try {
                attribute.put("attribute", me.getKey());
                attribute.put("value", me.getValue());

                attributesArray.put(attribute);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        if (isRegistered()) {
            RemoteRepository.incrementAttribute(getInstallationId(), attributesArray, new Callback() {
                @Override
                public void onSuccess(Object value) {
                    Logger.d(TAG, "Successfully increment attribute " + attributes.toString());
                    if (callback != null) {
                        callback.onSuccess(value);
                    }
                }

                @Override
                public void onFailure(Throwable value) {
                    Logger.e(TAG, "Fail to increment attribute " + attributes.toString(), value);
                    if (callback != null) {
                        callback.onFailure(value);
                    }
                }
            });

        } else {
            Logger.d(TAG, "User not registered yet, try to increment " +
                    "attributes (" + attributes.toString() + ") after send successfully installation request");
            eventBus.register(new Object() {
                public void onEvent(ChabokCommunicateStatus chabokCommunicateStatus) {
                    if (chabokCommunicateStatus == ChabokCommunicateStatus.InstallationSuccessfullySent) {
                        incrementUserAttribute(attributes);
                        Logger.d(TAG, "Installation successfully sent, " +
                                "Start incrementing attributes (" + attributes.toString() + ")");
                        eventBus.unregister(this);
                    }
                }
            });
        }
    }

    /**
     * Decrement user attributes are useful for storing the number of times a given action or event has occurred without counting against your data cap.
     * for example : (Recording shoe size, waist size, number of times a user has viewed a certain product feature, or category.
     *
     * @param attributeName is name of attribute wants to decrement.
     */
    public void decrementUserAttribute(String attributeName) {
        incrementUserAttribute(attributeName, -1, null);
    }

    /**
     * Decrement user attributes are useful for storing the number of times a given action or event has occurred without counting against your data cap.
     * for example : (Recording shoe size, waist size, number of times a user has viewed a certain product feature, or category.
     *
     * @param attributeName is name of attribute wants to increment.
     * @param value         is double value by which you want to decrement the attribute
     */
    public void decrementUserAttribute(final String attributeName, final double value) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (attributeName == null) {
            Logger.e(TAG, "attributeName is null. Please provide an attributeName");
            return;
        }

        HashMap<String, Double> attributesArray = new HashMap<>();

        attributesArray.put(attributeName, -value);

        incrementUserAttribute(attributesArray, null);
    }

    public void decrementUserAttribute(ArrayList<String> attributes) {
        decrementUserAttribute(attributes, null);
    }

    private void decrementUserAttribute(ArrayList<String> attributes, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (attributes == null) {
            Logger.e(TAG, "attributes is null. Please provide an attribute");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes is null. Please provide an attribute"));
            }
            return;
        }

        HashMap<String, Double> attributesArray = new HashMap<>();

        for (String attribute : attributes) {
            attributesArray.put(attribute, -1.0);
        }

        incrementUserAttribute(attributesArray, callback);
    }

    public void decrementUserAttribute(final HashMap<String, Double> attributes) {
        decrementUserAttribute(attributes, null);
    }

    private void decrementUserAttribute(final HashMap<String, Double> attributes, final Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (attributes == null) {
            Logger.e(TAG, "attributes parameter is null. please, provide an attribute");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("attributes parameter is null. please, provide an attribute"));
            }
            return;
        }

        JSONArray attributesArray = new JSONArray();

        Set<Map.Entry<String, Double>> set = attributes.entrySet();

        for (Map.Entry<String, Double> me : set) {
            JSONObject attribute = new JSONObject();
            try {
                attribute.put("attribute", me.getKey());
                attribute.put("value", -me.getValue());

                attributesArray.put(attribute);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        if (isRegistered()) {
            RemoteRepository.incrementAttribute(getInstallationId(), attributesArray, new Callback() {
                @Override
                public void onSuccess(Object value) {
                    Logger.d(TAG, "Successfully increment attribute " + attributes.toString());
                    if (callback != null) {
                        callback.onSuccess(value);
                    }
                }

                @Override
                public void onFailure(Throwable value) {
                    Logger.e(TAG, "Fail to increment attribute " + attributes.toString(), value);
                    if (callback != null) {
                        callback.onFailure(value);
                    }
                }
            });
        } else {
            Logger.d(TAG, "User not registered yet, try to increment " +
                    "attributes (" + attributes.toString() + ") after send successfully installation request");
            eventBus.register(new Object() {
                public void onEvent(ChabokCommunicateStatus chabokCommunicateStatus) {
                    if (chabokCommunicateStatus == ChabokCommunicateStatus.InstallationSuccessfullySent) {
                        incrementUserAttribute(attributes);
                        Logger.d(TAG, "Installation successfully sent, " +
                                "Start incrementing attributes (" + attributes.toString() + ")");
                        eventBus.unregister(this);
                    }
                }
            });
        }
    }

    private HashMap<String, Object> loadMap(String key) {
        HashMap<String, Object> outputMap = new HashMap<>();

        try {
            String jsonStringEnc = getSharedPreferences().getString(key, null);
            if (jsonStringEnc != null) {
                JSONObject jsonObject = new JSONObject(ChabokCrypto.decrypt(context, jsonStringEnc));
                Iterator<String> keysItr = jsonObject.keys();
                while (keysItr.hasNext()) {
                    String k = keysItr.next();
                    Object v = jsonObject.get(k);
                    outputMap.put(k, v);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return outputMap;
    }

    private JSONObject prepareMetaData(JSONObject data) {
        if (data == null) {
            return null;
        }

        try {
            JSONObject dateParams = new JSONObject();
            Iterator it = data.keys();
            while (it.hasNext()) {
                String key = (String) it.next();
                if (data.get(key) instanceof Datetime) {
                    // save key that have datetime format
                    dateParams.put(key, new JSONObject().put("type", "date"));
                    // update datetime object with timestamp
                    data.put(key, ((Datetime) data.get(key)).getTime());
                }
            }
            if (dateParams.length() > 0) {
                JSONObject metaData = new JSONObject();
                metaData.put("keys", dateParams);
                return metaData;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private JSONObject prepareMetaData(HashMap<String, Object> data) {
        if (data == null) {
            return null;
        }

        try {
            JSONObject dateParams = new JSONObject();
            Set<String> keys = data.keySet();
            for (String key : keys) {
                if (data.get(key) instanceof Datetime) {
                    // save key that have datetime format
                    dateParams.put(key, new JSONObject().put("type", "date"));
                    // update datetime object with timestamp
                    data.put(key, ((Datetime) data.get(key)).getTime());
                }
            }
            if (dateParams.length() > 0) {
                JSONObject metaData = new JSONObject();
                metaData.put("keys", dateParams);
                return metaData;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private JSONObject prepareMetaData(Bundle data) {
        if (data == null) {
            return null;
        }

        try {
            JSONObject dateParams = new JSONObject();
            Set<String> keys = data.keySet();
            for (String key : keys) {
                if (data.get(key) instanceof Datetime) {
                    // save key that have datetime format
                    dateParams.put(key, new JSONObject().put("type", "date"));
                }
            }
            if (dateParams.length() > 0) {
                JSONObject metaData = new JSONObject();
                metaData.put("keys", dateParams);
                return metaData;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * This method is for tracking third party app stores and pre-install campaigns
     *
     * @param defaultTracker Copy your track id here.
     */
    public static void setDefaultTracker(String defaultTracker){
        AdpPushClient.defaultTracker = defaultTracker;
    }

    /**
     * @deprecated As of release v3.0.0,
     *             Replaced by {@link #configureEnvironment(Environment)}
     *             @see <a href="https://chabok.io">Chabok Initialization</a>
     */
    @Deprecated
    public AdpPushClient setDevelopment(boolean isDev) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }

        useDev = isDev;
        getSharedPreferences().edit().putBoolean("useDev", useDev).apply();
        initializeAdapter();
        return this;
    }

    public static void setEnvironment(Environment environment) {
        chabokEnvironment = environment;
    }

    public void setDefaultNotificationChannel(String channelName) {
        String defaultChannelId = Constants.DEFAULT_CHANNEL;

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            createOrUpdateNotificationChannel(
                    defaultChannelId,
                    channelName);
        }
    }

    void createOrUpdateNotificationChannel(String channelId,
                                           String channelName) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            new ChabokNotificationChannel(channelId, getApplicationContext())
                    .setChannelName(channelName)
                    .build();
        }
    }

    void deleteNotificationChannel(String channelId) {
        NotificationManager notificationManager = (NotificationManager) getApplicationContext()
                .getSystemService(Context.NOTIFICATION_SERVICE);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            if (notificationManager != null) {
                notificationManager.deleteNotificationChannel(channelId);
            }
        } else {
            Logger.d(TAG, "Couldn't delete notification channel, because is require api level 26");
        }
    }

    boolean hasNotificationChannel(String channelId) {
        if (channelId == null) {
            return false;
        }
        NotificationManager notificationManager = (NotificationManager) getApplicationContext()
                .getSystemService(Context.NOTIFICATION_SERVICE);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            if (notificationManager != null) {
                return notificationManager.getNotificationChannel(channelId) != null;
            }
        }
        return false;
    }

    public AdpPushClient setSticky(boolean sticky) {
        FORCE_STICKY = sticky;
        return this;
    }

    public void subscribeEvent(String eventName, final com.adpdigital.push.Callback clbk) {
        subscribeEvent(eventName, "+", false, clbk);
    }

    public void subscribeEvent(String eventName, boolean live, final com.adpdigital.push.Callback clbk) {
        subscribeEvent(eventName, "+", live, clbk);
    }

    public void subscribeEvent(String eventName, String installationId, final com.adpdigital.push.Callback clbk) {
        subscribeEvent(eventName, installationId, false, clbk);
    }

    public void subscribeEvent(final String eventName, final String installationId, final boolean live, final com.adpdigital.push.Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (!isEnabledRealtime()) {
            return;
        }

        PushServiceManager.getInstance(getApplicationContext()).subscribeEvent(eventName, installationId, live, clbk);
    }

    public void unsubscribeEvent(String eventName, final com.adpdigital.push.Callback clbk) {
        unsubscribeEvent(eventName, "+", clbk);
    }


    public void unsubscribeEvent(final String eventName, final String installationId, final com.adpdigital.push.Callback clbk) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (!isEnabledRealtime()) {
            return;
        }

        PushServiceManager.getInstance(getApplicationContext()).unsubscribeEvent(eventName, installationId, clbk);
    }

    public void track(final String eventName) {
        track(eventName, (Bundle) null);
    }

    public void track(final String eventName, Bundle data) {
        track(eventName, data, null);
    }

    private void track(final String eventName, Bundle data, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (eventName == null) {
            Logger.e(TAG, "eventName is null, please provide an eventName.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("eventName is null, please provide an eventName."));
            }
            return;
        }
        if (eventName.isEmpty()) {
            Logger.e(TAG, "eventName is empty, please provide an eventName.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("eventName is null, please provide an eventName."));
            }
            return;
        }

        // add metadata for datetime values
        JSONObject metadata = prepareMetaData(data);
        JSONObject convertedData = DataConverter.bundleToJson(data);

        // track event
        trackInternal(eventName, convertedData, metadata);
    }

    public void track(final String eventName, JSONObject data) {
        track(eventName, data, null);
    }

    private void track(final String eventName, JSONObject data, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (eventName == null) {
            Logger.e(TAG, "eventName is null, please provide an eventName.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("eventName is null, please provide an eventName."));
            }
            return;
        }
        if (eventName.isEmpty()) {
            Logger.e(TAG, "eventName is empty, please provide an eventName.");
            if (callback != null) {
                callback.onFailure(new IllegalArgumentException("eventName is null, please provide an eventName."));
            }
            return;
        }

        // add metadata for datetime values
        JSONObject metadata = prepareMetaData(data);

        // track event
        trackInternal(eventName, data, metadata);
    }

    private void trackInternal(final String eventName, JSONObject data, JSONObject metadata) {
        JSONObject trackData = new JSONObject();

        try {
            trackData.put("id", UUID.randomUUID().toString());
            trackData.put("createdAt", System.currentTimeMillis());

            if (data != null) {
                if (metadata != null) {
                    trackData.put(META_DATA, metadata);
                }
                trackData.put("data", data);
            }

            JSONObject influenceData = ChabokEventDataStorage.getLastNotificationOpenedInfluence();
            if (influenceData != null) {
                if (ChabokEventDataStorage.isDirectInfluenced()) {
                    influenceData.put("direct", ChabokEventDataStorage.isDirectInfluenced());
                }
                trackData.put("influence", influenceData);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (this.getInstallationId() == null) {
            final JSONObject finalTrackData = trackData;
            eventBus.register(new Object() {
                public void onEvent(ConnectionStatus state) {
                    if (state == ConnectionStatus.CONNECTED) {
                        emit(TopicType.track,
                                eventName,
                                getInstallationId(),
                                finalTrackData,
                                true,
                                false);
                        eventBus.unregister(this);
                    }
                }
            });

            // FIXME - should call callback before return from method

            return;
        }

        Logger.d(TAG, "Track event: " + eventName);
        emit(TopicType.track, eventName, this.getInstallationId(), trackData, true, false);

        // FIXME - should call callback before return from method
    }

    public void trackPurchase(final String eventName, final ChabokEvent chabokEvent) {
        if (chabokEvent == null) {
            Logger.e(TAG, "chabokEvent is null, please provide a revenue");
            return;
        }

        if (chabokEvent.revenue < 0.0) {
            Logger.e(TAG, "Could not track event, Invalid amount");
        }

        JSONObject trackData = new JSONObject();
        try {
            JSONObject data = new JSONObject();
            if (chabokEvent.data != null) {
                data = chabokEvent.data;
            }

            data.put("isRevenue", true);
            data.put("value", chabokEvent.revenue);

            if (chabokEvent.currency != null) {
                data.put("currency", chabokEvent.currency);
            }

            // add metadata for datetime values
            JSONObject metadata = prepareMetaData(data);

            // track event
            trackInternal(eventName, data, metadata);

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void trackRevenue(final double revenue){
        trackPurchase("Purchase", new ChabokEvent(revenue));
    }

    void publishClientEvents(String id, final JSONArray data) {
        final String eventName = "clientEvent";
        final JSONObject trackData = new JSONObject();
        try {

            trackData.put("id", id);
            trackData.put("createdAt", System.currentTimeMillis());

            if (data != null) {
                trackData.put("eventData", data);
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (this.getInstallationId() == null) {
            final JSONObject finalEventData = trackData;
            eventBus.register(new Object() {
                public void onEvent(ConnectionStatus state) {
                    if (state == ConnectionStatus.CONNECTED) {
                        emit(TopicType.event, eventName, getInstallationId(), finalEventData, true, false);
                        eventBus.unregister(this);
                    }
                }
            });
            return;
        }

        Logger.d(TAG, "-- Publish cached data " + data);

        emit(TopicType.event, eventName, this.getInstallationId(), trackData, true, false);
    }

    public AdpPushClient enableDeliveryTopic() {
        getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", true).apply();
        return this;
    }

    public AdpPushClient disableDeliveryTopic() {
        getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", false).apply();
        return this;
    }

    public boolean deliveryTopicEnabled() {
        return getSharedPreferences().getBoolean("deliveryTopicEnabled", false);
    }

    private AdpPushClient setSecure(boolean isSecure) {
        useSecure = isSecure;
        initializeAdapter();
        return this;
    }

    public String[] getSubscriptions() {
        List<String> newChannels = new ArrayList<>();

        for (String ch : this.channels) {
            String chName = convertChannelName2newConvention(ch);
            newChannels.add(chName);
        }


        return newChannels.toArray(new String[newChannels.size()]);
    }

    private String convertChannelName2newConvention(String channel) {
        if (channel.startsWith("private/")) {
            return channel;
        } else if (channel.startsWith("public/")) {
            return channel.substring(channel.indexOf("/") + 1);
        } else {
            return "private/" + channel;
        }

    }

    SharedPreferences getSharedPreferences() {
        return ChabokLocalStorage.getSharedPreferences(getApplicationContext());
    }

    public AdpPushClient setCurrentActivity(Activity currentActivity) {
        AdpPushClient.get().currentActivity = new WeakReference<>(currentActivity);
        return this;
    }

    public static void setActivityClass(Class activityClass){
        AdpPushClient.activityClass = activityClass;
    }

    void notifyNewMessage(PushMessage message) {
        //TODO this hook should be put inside sendNotification to be called for GCM notifs!
        Class clazz = activityClass;

        if (hasNotified(message.getId())) {
            return;
        }

        for (NotificationHandler h : handlers) {
            ChabokNotification notif = new ChabokNotification(message, 0);
            Class theirs = h.getActivityClass(notif);
            if (theirs != null) {
                clazz = theirs;
            }
        }

        final Class finalClazz = clazz;
        final PushMessage finalMessage = message;

        new AsyncTask<Void, Void, Boolean>() {
            @Override
            protected Boolean doInBackground(Void... voids) {
                Logger.d(Logger.TAG, "~~> Start showing notification in background");
                ChabokFirebaseMessaging.sendNotification(
                        getApplicationContext(),
                        finalClazz,
                        new ChabokNotification(finalMessage, 0)
                );
                return true;
            }

            @Override
            protected void onPostExecute(Boolean aBoolean) {
                Logger.d(Logger.TAG, "~~> Finish showing notification in background");
                super.onPostExecute(aBoolean);
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null, null, null);
    }

    boolean addNotifiedMessage(String id) {
        boolean val = notifs.add(id);
        getSharedPreferences().edit().putStringSet(
                "notifs",
                new HashSet<>(Arrays.asList(notifs.toArray(new String[notifs.size()])))
        ).apply();
        return val;
    }

    Class getNotifActivityClass(Bundle data) throws ClassNotFoundException {
        Class clazz = activityClass;
        String title = data.getString("title");
        if (title == null) {
            title = data.getString("messageFrom");
        }
        for (NotificationHandler h : handlers) {
            ChabokNotification gcmNotif = new ChabokNotification(
                    data.getString("messageId"),
                    title,
                    data.getString("message"),
                    Integer.valueOf(data.getString("androidBadge", "0")),
                    data
            );
            Class theirs = h.getActivityClass(gcmNotif);
            if (theirs != null) {
                clazz = theirs;
            }
        }
        return clazz;
    }

    boolean notificationOpened(Bundle data, ChabokNotificationAction notificationAction) {
        this.lastNotificationAction = notificationAction;

        String title = data.getString("title");
        boolean shouldLaunchActivity = true;
        if (title == null) {
            title = data.getString("messageFrom");
        }

        ChabokNotification chabokNotif = new ChabokNotification(
                data.getString("messageId"),
                title,
                data.getString("message"),
                Integer.valueOf(data.getString("androidBadge", "0")),
                data
        );

        this.lastNotificationData = chabokNotif;

        for (NotificationHandler h : handlers) {
            shouldLaunchActivity = h.notificationOpened(chabokNotif, notificationAction);
        }
        return shouldLaunchActivity;
    }

    public ChabokNotificationAction getLastNotificationAction() {
        return this.lastNotificationAction;
    }

    public ChabokNotification getLastNotificationData() {
        return this.lastNotificationData;
    }

    public boolean prepareNotification(ChabokNotification notif, NotificationCompat.Builder builder) {
        boolean showNotification = true;
        for (NotificationHandler h : handlers) {
            showNotification &= h.buildNotification(notif, builder);
        }
        return showNotification;
    }

    public void addNotificationHandler(NotificationHandler handler) {
        handlers.add(handler);
    }

    void launchSingleTaskUri(String uri, String logMessage) {
        try {

            String url = uri;
            if (!url.contains("://"))
                url = "http://" + url;

            Intent i = new Intent(Intent.ACTION_VIEW);
            i.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);

            i.setData(Uri.parse(url));

            Logger.d(Logger.TAG, logMessage + " " + url);
            context.startActivity(i);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Set listener for deferred deep link
     *
     * @deprecated As of release v3.1.0, replaced by {@link AdpPushClient#setDeferredDataListener(DeferredDataListener)}
     *
     * @param deeplinkResponseListener listener for deferred deep link
    */
    @Deprecated
    public void setOnDeeplinkResponseListener(OnDeeplinkResponseListener deeplinkResponseListener) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        this.onDeeplinkResponseListener = deeplinkResponseListener;
    }

    /**
     * Set listener for deferred deep link and referral string
     *
     * @param deferredDataListener listener for deferred deep link and referral string
     */
    public void setDeferredDataListener(DeferredDataListener deferredDataListener) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        this.deferredDataListener = deferredDataListener;
    }

    private void getDeferredDeepLink() {
        RemoteRepository.deferredDeepLink(getInstallationId(), new Callback<DeferredData>() {
            @Override
            public void onSuccess(DeferredData value) {
                try {
                    if (value != null && value.getDeepLink() != null) {
                        Logger.d(TAG, "Get deferred deep-link (" + value.getDeepLink() + ")");
                        boolean launchDeeplink = false;
                        // check deprecated deep link listener first
                        if (onDeeplinkResponseListener != null) {
                            launchDeeplink = onDeeplinkResponseListener.launchReceivedDeeplink(value.getDeepLink());
                            if (launchDeeplink) {
                                launchSingleTaskUri(value.getDeepLink().toString(), "Open deferred deep link");
                            }
                        }
                        // make sure launch deep link is not set before
                        if (deferredDataListener != null && !launchDeeplink) {
                            launchDeeplink = deferredDataListener.launchReceivedDeeplink(value.getDeepLink());
                            if (launchDeeplink) {
                                launchSingleTaskUri(value.getDeepLink().toString(), "Open deferred deep link");
                            }
                        }
                    }
                    if (value != null && value.getLabel() != null && deferredDataListener != null) {
                        Logger.d(TAG, "Get referral (" + value.getLabel() + ")");
                        deferredDataListener.onReferralReceived(value.getLabel());
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFailure(Throwable value) {
                Logger.e(TAG, "unable to get deferred data. error = ", value);
            }
        });
    }

    public void appWillOpenUrl(Uri url) {
        if (url == null || url.toString().trim().isEmpty()) {
            Logger.d(TAG, "Deeplink url is not vaild!!");
            return;
        }

        long clickTime = System.currentTimeMillis();

        JSONObject json = new JSONObject();

        try {
            json.put("type", 0);
            json.put("deepLinkClickTs", clickTime);
            json.put("deepLinkUrl", url.toString());

            ChabokCommunicateEvent communicateEvent = new ChabokCommunicateEvent(
                    json,
                    ChabokCommunicateStatus.GotDeepLink
            );
            eventBus.post(communicateEvent);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean hasProtectedAppSupport() {

        String deviceManufacturer = getDeviceManufacturer().toLowerCase();
        return (!TextUtils.isEmpty(deviceManufacturer) && (deviceManufacturer.contains("huawei") ||
                deviceManufacturer.contains("xiaomi")));
    }

    private String getDeviceManufacturer() {
        String deviceMan = android.os.Build.MANUFACTURER;
        Logger.d("deviceMan", "" + deviceMan);
        return deviceMan;
    }

    public void showProtectedAppSettings(Activity ctx, String app_name, String title, String msg) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        title = title != null && !title.isEmpty() ? title : "برنامه‌های محافظت شده";
        msg = msg != null && !msg.isEmpty() ? msg : String.format("برنامه %s برای کارکرد درست می‌بایست در لیست برنامه‌های محافظت شده فعال شود.%n", app_name);

        showGuide(ctx, title, msg);
    }


    private void showGuide(Activity ctx, String title, String message) {
        final SharedPreferences settings = ctx
                .getSharedPreferences("ProtectedApps", getApplicationContext().MODE_PRIVATE);
        final String saveIfSkip = "skipProtectedAppsMessage";
        boolean skipMessage = settings.getBoolean(saveIfSkip, false);
        if (!skipMessage) {
            final SharedPreferences.Editor editor = settings.edit();
            Intent intent = new Intent();
            intent.setClassName("com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity");
            if (isCallable(intent)) {
                final CheckBox dontShowAgain = new CheckBox(getApplicationContext());
                dontShowAgain.setTextColor(Color.BLACK);
                dontShowAgain.setText("     دیگر این پیام را نشان نده");
                dontShowAgain.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                    @Override
                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        editor.putBoolean(saveIfSkip, isChecked);
                        editor.apply();
                    }
                });

                new AlertDialog.Builder(ctx)
                        .setIcon(android.R.drawable.ic_dialog_alert)
                        .setTitle(title)
                        .setMessage(message)
                        .setView(dontShowAgain)
                        .setPositiveButton("برو به برنامه‌های محافظت شده", new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int which) {
                                huaweiProtectedApps();
                            }
                        })
                        .setNegativeButton("لغو", null)
                        .show();
            } else {
                editor.putBoolean(saveIfSkip, true);
                editor.apply();
            }
        }
    }

    private boolean isCallable(Intent intent) {
        List<ResolveInfo> list = getApplicationContext()
                .getPackageManager()
                .queryIntentActivities(
                        intent,
                        PackageManager.MATCH_DEFAULT_ONLY
                );
        return list.size() > 0;
    }

    private void huaweiProtectedApps() {
        try {
            String cmd = "am start -n com.huawei.systemmanager/.optimize.process.ProtectActivity";
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                cmd += " --user " + getUserSerial();
            }
            Runtime.getRuntime().exec(cmd);
        } catch (IOException ignored) {
        }
    }

    private String getUserSerial() {
        //noinspection ResourceType
        Object userManager = getApplicationContext().getSystemService(Context.USER_SERVICE);
        if (null == userManager) return "";

        try {
            Method myUserHandleMethod = android.os.Process.class.getMethod("myUserHandle", (Class<?>[]) null);
            Object myUserHandle = myUserHandleMethod.invoke(android.os.Process.class, (Object[]) null);
            Method getSerialNumberForUser = userManager.getClass().getMethod("getSerialNumberForUser", myUserHandle.getClass());
            Long userSerial = (Long) getSerialNumberForUser.invoke(userManager, myUserHandle);
            if (userSerial != null) {
                return String.valueOf(userSerial);
            } else {
                return "";
            }
        } catch (NoSuchMethodException | IllegalArgumentException | InvocationTargetException | IllegalAccessException ignored) {
        }
        return "";
    }


    boolean shouldBeSticky() {
        if (FORCE_STICKY) {
            return true;
        }
        return !isPlayServicesSupported();
    }

    public boolean isPlayServicesSupported() {
        return !ChabokLocalStorage.isSupportPlayServices(getApplicationContext());
    }

    private synchronized void updateDeviceToken(DeviceToken token) {
        updateDeviceToken(token, null);
    }

    private synchronized void updateDeviceToken(DeviceToken token, @Nullable Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (userId.asString() == null) {
            String msg = "userId not initialized yet";
            Logger.e(TAG, msg);
            if (callback != null) {
                callback.onFailure(new Throwable(msg));
            }
            return;
        }

        if (token == null || TextUtils.isEmpty(token.getToken().asString())) {
            String msg = "updateDeviceToken: token is empty";
            Logger.e(TAG, msg);
            if (callback != null) {
                callback.onFailure(new Throwable(msg));
            }
            return;
        }

        if (AdpPushClient.get().getInstallationId() == null) {
            String msg = "Not initialized yet to update device token...";
            Logger.e(TAG, msg);
            if (callback != null) {
                callback.onFailure(new Throwable(msg));
            }
            return;
        }

        Map<String, Object> data = new HashMap<>();

        long ts = System.currentTimeMillis();
        String userId = this.getUserId();
        String installationId = this.getInstallationId();
        HashMap<String, Object> tokenError = null;
        if (token.getTokenErr() != null) {
            tokenError = new HashMap<>();
            tokenError.put("code", token.getTokenErrCode());
            tokenError.put("message", token.getTokenErr());
        }

        data.put("createdAt", ts);
        data.put("userId", userId);
        data.put("installationId", installationId);
        data.put("deviceType", InstallationModel.DEVICE_TYPE_ANDROID);
        data.put("deviceToken", token.getToken().asString());
        if (tokenError != null) {
            data.put("tokenError", tokenError);
        }
        if (token.getTokenStatus() != null) {
            data.put("tokenStatus", token.getTokenStatus());
        }

        RemoteRepository.updateDeviceToken(data, callback);
    }

    public void addTag(String tagName, com.adpdigital.push.Callback callback) {
        if (userId.asString() == null) {
            String msg = "userId not initialized yet";
            Logger.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (TextUtils.isEmpty(tagName)) {
            String msg = "addTag: tag is empty";
            Logger.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        String[] tagsName = new String[]{tagName};
        addTag(tagsName, callback);
    }

    public void addTag(String[] tagsName, com.adpdigital.push.Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (userId.asString() == null) {
            String msg = "userId not initialized yet";
            Logger.e(TAG, msg);
            if (callback != null) {
                callback.onFailure(new Throwable(msg));
            }
            return;
        }
        for (String tag : tagsName) {
            if (TextUtils.isEmpty(tag)) {
                String msg = "addTags: tag is empty";
                Logger.e(TAG, msg);
                if (callback != null) {
                    callback.onFailure(new Throwable(msg));
                }
                return;
            }
        }

        RemoteRepository.addTags(userId,tagsName, callback);
    }

    public void removeTag(String tagName, com.adpdigital.push.Callback callback) {
        if (userId.asString() == null) {
            String msg = "userId not initialized yet";
            Logger.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        if (TextUtils.isEmpty(tagName)) {
            String msg = "removeTag: tag is empty";
            Logger.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        String[] tagsName = new String[]{tagName};
        removeTag(tagsName, callback);
    }

    public void removeTag(String[] tagsName, com.adpdigital.push.Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }

        if (userId.asString() == null) {
            String msg = "userId not initialized yet";
            Logger.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }
        for (String tag : tagsName) {
            if (TextUtils.isEmpty(tag)) {
                String msg = "removeTag: tag is empty";
                Logger.e(TAG, msg);
                callback.onFailure(new Throwable(msg));
                return;
            }
        }

        RemoteRepository.removeTags(userId,tagsName, callback);
    }

    void sendEventData(JSONArray data, com.adpdigital.push.Callback callback) {
        if (data == null) {
            String msg = "Please provide a data parameter";
            Logger.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }

        if (AdpPushClient.get().getInstallationId() == null) {
            String msg = "Not initialized yet to send fallback event...";
            Logger.e(TAG, msg);
            callback.onFailure(new Throwable(msg));
            return;
        }

        Logger.d(TAG, "-- Sending eventData");

        RemoteRepository.events(getSecureUserId(),getInstallationId(), data, callback);
    }

    boolean hasInstallReferrerData() {
        //Install Referrer
        return getSharedPreferences().contains("CHK_INSTALL_REFERRER")
                && getSharedPreferences().contains("CHK_INSTALL_REF_CLICK_TS_L")
                && getSharedPreferences().contains("CHK_INSTALL_REF_BEGIN_TS_L");
    }

    String getInstallReferrer() {
        String encryptInstallReferrer = getSharedPreferences().getString("CHK_INSTALL_REFERRER", null);
        if (encryptInstallReferrer == null) {
            return null;
        }

        return ChabokCrypto.decrypt(context, encryptInstallReferrer);
    }

    long getInstallReferrerClickTs() {
        try {
            return getSharedPreferences().getLong("CHK_INSTALL_REF_CLICK_TS_L", 0);
        } catch (NumberFormatException ex) {
            Logger.e(Constants.TAG,
                    "Exception happen to get ReferrerClickTimestampSeconds",
                    ex);
        }
        return 0;
    }

    long getInstallReferrerInstallBeginTs() {
        try {
            return getSharedPreferences().getLong("CHK_INSTALL_REF_BEGIN_TS_L", 0);
        } catch (NumberFormatException ex) {
            Logger.e(Constants.TAG,
                    "Exception happen to get InstallBeginTimestampSeconds",
                    ex);
        }
        return 0;
    }

    void getApplicationInstallReferrer() {
        InstallReferrer referrer = new InstallReferrer(context, new InstallReferrerReadListener() {
            @Override
            public void onInstallReferrerRead(String installReferrer, long referrerClickTimestampSeconds, long installBeginTimestampSeconds) {
                if (installReferrer == null) {
                    return;
                }

                if (hasInstallReferrerData()
                        && referrerClickTimestampSeconds == getInstallReferrerClickTs()
                        && installBeginTimestampSeconds == getInstallReferrerInstallBeginTs()
                        && installReferrer.equals(getInstallReferrer())) {
                    // Same click already sent before, nothing to be done.
                    return;
                }

                getSharedPreferences().edit().putString("CHK_INSTALL_REFERRER", ChabokCrypto.encrypt(context, installReferrer)).apply();
                getSharedPreferences().edit().putLong("CHK_INSTALL_REF_CLICK_TS_L", referrerClickTimestampSeconds).apply();
                getSharedPreferences().edit().putLong("CHK_INSTALL_REF_BEGIN_TS_L", installBeginTimestampSeconds).apply();

                //TODO: If has plan to change calling getApplicationInstallReferrer function in other function instead of register method Uncomment this co to send referrer data's immediately
//                if (userId != null) {
//                    HashMap<String, Object> props = new HashMap();
//                    props.put("referrer", installReferrer);
//                    props.put("refClickTs", referrerClickTimestampSeconds);
//                    props.put("refBeginTs", installBeginTimestampSeconds);
//
//                    updateInstallation(props);
//                }
            }
        });
    }

    /**
     * Called to process referrer information sent with INSTALL_REFERRER intent.
     *
     * @param rawReferrer Raw referrer content
     * @param context     Application context
     */
    void sendInstallReferrer(final String rawReferrer, final Context context) {
        long clickTime = System.currentTimeMillis();

        // Check for referrer validity. If invalid, return.
        if (rawReferrer == null || rawReferrer.length() == 0) {
            return;
        }

        this.context = context;

        getSharedPreferences().edit().putString("CHK_RAW_INSTALL_REFERRER", ChabokCrypto.encrypt(context, rawReferrer)).apply();
        getSharedPreferences().edit().putLong("CHK_RAW_INSTALL_REF_CLICK_TS_L", clickTime).apply();
//        if (userId != null){
//            HashMap<String, Object> props = new HashMap();
//            props.put("rawReferrer", rawReferrer);
//            props.put("rawRefClickTs", clickTime);
//            props.put("rawReferrerParams", getRawInstallReferrerParams());
//
//            updateInstallation(props);
//        }
    }

    private String getRawInstallReferrer() {
        String encryptRawInstallReferrer = getSharedPreferences().getString("CHK_RAW_INSTALL_REFERRER", null);
        if (encryptRawInstallReferrer == null) {
            return null;
        }

        return ChabokCrypto.decrypt(context, encryptRawInstallReferrer);
    }

    private long getRawInstallReferrerClickTs() {
        try {
            return getSharedPreferences().getLong("CHK_RAW_INSTALL_REF_CLICK_TS_L", 0);
        } catch (NumberFormatException ex) {
            Logger.e(Constants.TAG,
                    "Exception happen to get RawInstallRefClickTs",
                    ex);
        }

        return 0;
    }

    private Map<String, String> getRawInstallReferrerParams() {
        String referrer = getRawInstallReferrer();

        try {
            referrer = URLDecoder.decode(referrer, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            referrer = MALFORMED;
            Logger.d(Logger.TAG, "Referrer decoding failed due to UnsupportedEncodingException. Message: (" + e.getMessage() + ")");
        } catch (IllegalArgumentException e) {
            referrer = MALFORMED;
            Logger.d(Logger.TAG, "Referrer decoding failed due to IllegalArgumentException. Message: (" + e.getMessage() + ")");
        } catch (Exception e) {
            referrer = MALFORMED;
            Logger.d(Logger.TAG, "Referrer decoding failed. Message: (" + e.getMessage() + ")");
        }

        Logger.v(Logger.TAG, "Referrer to parse (" + referrer + ")");

        UrlQuerySanitizer querySanitizer = new UrlQuerySanitizer();
        querySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
        querySanitizer.setAllowUnregisteredParamaters(true);
        querySanitizer.parseQuery(referrer);

        HashMap<String, String> extraParameters = new HashMap();

        for (UrlQuerySanitizer.ParameterValuePair params : querySanitizer.getParameterList()) {
            extraParameters.put(params.mParameter, params.mValue);
        }

        return extraParameters;
    }

    public static void configureEnvironment(Environment environment) {
        AdpPushClient.configureEnvironment(environment, null);
    }

    public static void configureEnvironment(Environment environment, String guestId) {
        if (AdpPushClient.context == null) {
            throw new IllegalStateException("AdpPushClient is not initialized in this process " +
                    ProcessUtils.getMyProcessName() +
                    ". Make sure to call AdpPushClient.setApplicationContext(Context) first.");
        }

        Configuration config = ConfigurationFactory.getConfiguration(environment);
        if (config == null) {
            throw new IllegalStateException("AdpPushClient not initialized, " +
                    "Make sure to configure correct environment. Please see http://bit.ly/32x1Tsn");
        }

        AdpPushClient.init(
                config.appId(),
                config.apiKey(),
                config.username(),
                config.password()
        );

        chabokEnvironment = environment;

        // [sandbox, development] => setDevelopment(true)
        if (environment == null){
            AdpPushClient.get().setDevelopment(true);
        } else {
            AdpPushClient.get().setDevelopment(environment != Environment.PRODUCTION);
        }
        AdpPushClient.get().setEnableRealtime(config.realtime());
        AdpPushClient.get().setConfiguration(config);

        String userId = AdpPushClient.get().getUserId();
        if (userId != null) {
            AdpPushClient.get().register(userId);
        } else {
            AdpPushClient.get().registerAsGuest(guestId);
        }
    }

    private void setConfiguration(Configuration config) {
        this.config = config;
    }

    public void login(String userId) {
        register(userId);
    }

    public void login(String userId, @Nullable Callback<String> loginCallback) {
        register(userId, loginCallback);
    }

    public void login(String userId, final String[] tagsName) {
        login(userId, tagsName, null);
    }

    private void login(String userId, final String[] tagsName, @Nullable final Callback<String> loginCallback) {
        register(userId, new Callback<String>() {
            @Override
            public void onSuccess(String value) {
                addTag(tagsName, loginCallback);
            }

            @Override
            public void onFailure(Throwable value) {
                if (loginCallback != null) {
                    loginCallback.onFailure(value);
                }
            }
        });
    }

    public void login(String userId, HashMap<String, Object> attributes) {
        login(userId, attributes, null);
    }

    private void login(String userId,
                      final HashMap<String, Object> attributes,
                      @Nullable final Callback<String> loginCallback) {
        register(userId, new Callback<String>() {
            @Override
            public void onSuccess(String value) {

                setUserAttributes(attributes, loginCallback);
            }

            @Override
            public void onFailure(Throwable value) {
                if (loginCallback != null) {
                    loginCallback.onFailure(value);
                }
            }
        });
    }

    public void login(String userId, String eventName, JSONObject data) {
        login(userId, eventName, data, null);
    }

    private void login(String userId, final String eventName,
                       final JSONObject data,
                       @Nullable final Callback<String> loginCallback) {
        register(userId, new Callback<String>() {
            @Override
            public void onSuccess(String value) {
                track(eventName, data, loginCallback);
            }

            @Override
            public void onFailure(Throwable value) {
                if (loginCallback != null) {
                    loginCallback.onFailure(value);
                }
            }
        });
    }

    public void login(String userId, String userHash) {
        this.userHash = userHash;
        register(userId);
    }

    private void login(String userId, String userHash, @Nullable final Callback loginCallback) {
        this.userHash = userHash;
        register(userId, new Callback<String>() {
            @Override
            public void onSuccess(String value) {
                if (loginCallback != null) {
                    loginCallback.onSuccess(value);
                }
            }

            @Override
            public void onFailure(Throwable value) {
                if (loginCallback != null) {
                    loginCallback.onFailure(value);
                }
            }
        });
    }

    public void logout() {
        logout(null);
    }

    private void logout(@Nullable Callback<String> logoutCallback) {
        registerAsGuest(logoutCallback);
    }
}