package com.network;

import com.adpdigital.push.MapUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.net.URL;
import java.util.Map;

class NetworkUtils {

    static URL urlGenerator(String url) {

        try {
            return new URL(url);
        } catch (Throwable ignored) {}
        return null;

    }

    static String getUrlBuilder(String api, String params) {
        StringBuilder appendedUrl = new StringBuilder(api);
        int position = 0;
        try {
            for(Map.Entry<String, Object> entry : MapUtils.jsonObjectToMap(new JSONObject(params)).entrySet()) {
                appendedUrl.append((position == 0) ? "?" : "&").append(entry.getKey()).append("=").append(entry.getValue());
                position++;
            }
            return appendedUrl.toString();
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return api;
    }

}
