/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import com.adpdigital.push.AppListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ForegroundManager
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = ForegroundManager.class.getName();
    private static String currentActivity = null;
    private static final long CHECK_DELAY = 500L;
    private static ForegroundManager instance;
    private boolean foreground = false;
    private boolean paused = true;
    private Handler handler;
    private List<AppListener> listeners;
    private Runnable check;

    public ForegroundManager() {
        CopyOnWriteArrayList copyOnWriteArrayList;
        Handler handler;
        Object object = handler;
        handler = new Handler();
        v1.handler = object;
        object = copyOnWriteArrayList;
        copyOnWriteArrayList = new CopyOnWriteArrayList();
        v1.listeners = object;
    }

    public static ForegroundManager init(Application object) {
        if (instance == null) {
            ForegroundManager foregroundManager;
            Application application = object;
            object = foregroundManager;
            instance = new ForegroundManager();
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)object);
        }
        return instance;
    }

    public static ForegroundManager get(Application application) {
        if (instance == null) {
            ForegroundManager.init(application);
        }
        return instance;
    }

    public static ForegroundManager get(Context context) {
        ForegroundManager foregroundManager = instance;
        if (foregroundManager == null) {
            if ((context = context.getApplicationContext()) instanceof Application) {
                return ForegroundManager.init((Application)context);
            }
            throw new IllegalStateException("ForegroundManager is not initialised and cannot obtain the Application object");
        }
        return foregroundManager;
    }

    public static ForegroundManager get() {
        ForegroundManager foregroundManager = instance;
        if (foregroundManager != null) {
            return foregroundManager;
        }
        throw new IllegalStateException("ForegroundManager is not initialised - invoke at least once with parameterised init/get");
    }

    static /* synthetic */ boolean access$002(ForegroundManager foregroundManager, boolean bl) {
        foregroundManager.foreground = bl;
        return bl;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public boolean isBackground() {
        return this.foreground ^ true;
    }

    public void addListener(AppListener appListener) {
        this.listeners.add(appListener);
    }

    public void removeListener(AppListener appListener) {
        this.listeners.remove(appListener);
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    public String getActiveActivityClassName() {
        return currentActivity;
    }

    public void onActivityResumed(Activity activity) {
        ForegroundManager foregroundManager = iterator;
        foregroundManager.paused = false;
        boolean bl = foregroundManager.foreground ^ true;
        foregroundManager.foreground = true;
        Runnable runnable = foregroundManager.check;
        if (runnable != null) {
            ((ForegroundManager)((Object)iterator)).handler.removeCallbacks(runnable);
        }
        if (bl) {
            Log.d((String)TAG, (String)"app foreground");
            Iterator<AppListener> iterator = ((ForegroundManager)((Object)iterator)).listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((AppListener)iterator.next()).onBecameForeground(activity.getClass());
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)"AppListener threw exception!", (Throwable)exception);
                }
            }
        } else {
            Log.d((String)TAG, (String)"still foreground");
        }
        currentActivity = activity.getClass().getName();
    }

    public void onActivityPaused(Activity object) {
        Runnable runnable;
        this.paused = true;
        object = this.check;
        if (object != null) {
            this.handler.removeCallbacks((Runnable)object);
        }
        object = runnable;
        this.check = new Runnable(){

            @Override
            public void run() {
                if (iterator.ForegroundManager.this.foreground && iterator.ForegroundManager.this.paused) {
                    NZV nZV = iterator;
                    ForegroundManager.access$002(nZV.ForegroundManager.this, false);
                    Log.d((String)TAG, (String)"app background");
                    Iterator iterator = nZV.ForegroundManager.this.listeners.iterator();
                    while (iterator.hasNext()) {
                        try {
                            ((AppListener)iterator.next()).onBecameBackground();
                        }
                        catch (Exception exception) {
                            Log.e((String)TAG, (String)"AppListener threw exception!", (Throwable)exception);
                        }
                    }
                } else {
                    Log.d((String)TAG, (String)"still foreground");
                }
            }
        };
        this.handler.postDelayed((Runnable)object, 500L);
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

