package com.network;

import android.content.pm.PackageManager;
import android.net.Uri;

import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.Callback;
import com.adpdigital.push.ChabokUtils;
import com.adpdigital.push.DeferredData;
import com.adpdigital.push.DeviceEvents;
import com.adpdigital.push.DeviceUtil;
import com.adpdigital.push.JsonUtils;
import com.adpdigital.push.Logger;
import com.adpdigital.push.MapUtils;
import com.adpdigital.push.SecureString;

import org.apache.http.client.HttpResponseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

import de.greenrobot.event.EventBus;

public class RemoteRepository {

    public static void installation(final InstallationModel installationModel,final Map<String, Object> properties, final Map<String, Object> requireParams, final com.adpdigital.push.Callback callback) {

        updateInstallation(installationModel, properties, requireParams, new com.adpdigital.push.Callback() {
            @Override
            public void onSuccess(Object value) {
                installationModel.saveInstallationId();
                if (callback != null) {
                    callback.onSuccess(value);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                if (t instanceof HttpResponseException) {
                    HttpResponseException ex = (HttpResponseException) t;
                    if (ex.getStatusCode() == 404 && installationModel.getId() != null) {
                        // Our Installation ID is no longer valid.
                        // Try to create a new installation instead.
                        installationModel.setAdId(null);
                        EventBus.getDefault().post(DeviceEvents.DeviceIdChange);
                        installation(installationModel,properties,requireParams,callback);
                        return;
                    }
                }
                if (callback != null) {
                    callback.onFailure(t);
                }
            }
        });

    }

    public static void updateInstallation(final InstallationModel installationModel,final Map<String, Object> properties, Map<String, Object> requireParams, final com.adpdigital.push.Callback callback) {

        Object id = installationModel.getId();

        Map<String, Object> map = new HashMap<>();
//        map.putAll(beforeSend);
        map.putAll(requireParams);
        map.putAll(properties);

        AdpPushClient.beforeSend(map);

        String params = (new JSONObject(map)).toString();

        String restApi = NetworkPreferences.getInstance().getRestApi() + NetworkKeys.installations;

        Logger.v("************* New API Call ************* ~~~> ", "Installation Called!!!");

        HttpRequestType requestType = (id == null) ? HttpRequestType.POST : HttpRequestType.PUT;
        HttpRequestHandler httpRequestHandler = new HttpRequestHandler();
        httpRequestHandler.sendHttpRequest(requestType, params, NetworkProperties.getPublicHeaders(), restApi, new Callback() {
            @Override
            public void onSuccess(Object value) {
                try {
                    JSONObject obj = new JSONObject(value.toString());
                    Object id = obj.opt("id");
                    if (id != null) {
                        installationModel.setId(id);
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                callback.onSuccess(value);
            }

            @Override
            public void onFailure(Throwable value) {

            }
        });

    }

    public static void deleteInstallation(final InstallationModel installationModel, final com.adpdigital.push.Callback callback) {

        Object id = installationModel.getId();

        Map<String, Object> map = new HashMap<>();
        map.put(NetworkKeys.id,id);

        String params = (new JSONObject(map)).toString();

        String restApi = NetworkPreferences.getInstance().getRestApi() + NetworkKeys.installations;

        Logger.v("************* New API Call ************* ~~~> ", "Delete Installation Called!!!");

        HttpRequestHandler httpRequestHandler = new HttpRequestHandler();
        httpRequestHandler.sendHttpRequest(HttpRequestType.DELETE, params, NetworkProperties.getPublicHeaders(), restApi, new Callback() {
            @Override
            public void onSuccess(Object value) {
                try {
                    JSONObject obj = new JSONObject(value.toString());
                    Object id = obj.opt("id");
                    if (id != null) {
                        installationModel.setId(id);
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                callback.onSuccess(value);
            }

            @Override
            public void onFailure(Throwable value) {

            }
        });

    }

    public static void addTags(SecureString userId, String[] tags, com.adpdigital.push.Callback callback) {
        Map<String, Object> map = new HashMap<>();
        map.put(NetworkKeys.userId, userId.asString());
        map.put(NetworkKeys.tags, tags);
        String params = (new JSONObject(map)).toString();

        String restApi = NetworkPreferences.getInstance().getRestApi() + NetworkKeys.addTagsRoot;

        Logger.v("************* New API Call ************* ~~~> ", "Add Tag Called!!!");

        HttpRequestHandler httpRequestHandler = new HttpRequestHandler();
        httpRequestHandler.sendHttpRequest(HttpRequestType.POST,params,NetworkProperties.getPublicHeaders(),restApi,callback);

    }

    public static void removeTags(SecureString userId, String[] tags, com.adpdigital.push.Callback callback) {
        Map<String, Object> map = new HashMap<>();
        map.put(NetworkKeys.userId, userId.asString());
        map.put(NetworkKeys.tags, tags);
        String params = (new JSONObject(map)).toString();

        String restApi = NetworkPreferences.getInstance().getRestApi() + NetworkKeys.removeTagsRoot;

        Logger.v("************* New API Call ************* ~~~> ", "Remove Tag Called!!!");

        HttpRequestHandler httpRequestHandler = new HttpRequestHandler();
        httpRequestHandler.sendHttpRequest(HttpRequestType.POST,params,NetworkProperties.getPublicHeaders(),restApi,callback);

    }

    public static void userInfo(String installationId, Map<String, Object> data,JSONObject metadata
            , com.adpdigital.push.Callback callback) {
        Map<String, Object> map = new HashMap<>();
        map.put(NetworkKeys.installationId, installationId);
        map.put(NetworkKeys.data, data);
        map.put(NetworkKeys.__meta, metadata);
        String params = (new JSONObject(map)).toString();

        String restApi = NetworkPreferences.getInstance().getRestApi() + NetworkKeys.userInfoRoot;

        Logger.v("************* New API Call ************* ~~~> ", "User Info Called!!!");

        HttpRequestHandler httpRequestHandler = new HttpRequestHandler();
        httpRequestHandler.sendHttpRequest(HttpRequestType.POST,params,NetworkProperties.getPublicHeaders(),restApi,callback);

    }

    public static void incrementAttribute(String installationId, JSONArray attributes, com.adpdigital.push.Callback callback) {
        Map<String, Object> map = new HashMap<>();
        map.put(NetworkKeys.installationId, installationId);
        map.put(NetworkKeys.attributes, attributes);
        String params = (new JSONObject(map)).toString();

        String restApi = NetworkPreferences.getInstance().getRestApi() + NetworkKeys.incrementAttributeRoot;

        Logger.v("************* New API Call ************* ~~~> ", "Increment Attribute Called!!!");

        HttpRequestHandler httpRequestHandler = new HttpRequestHandler();
        httpRequestHandler.sendHttpRequest(HttpRequestType.POST,params,NetworkProperties.getPublicHeaders(),restApi,callback);

    }

    public static void events(SecureString userId, String installationId, JSONArray data, com.adpdigital.push.Callback callback) {

        Map<String, Object> body = new HashMap<>();

        long ts = System.currentTimeMillis();

        body.put(NetworkKeys.createdAt, ts);
        body.put(NetworkKeys.userId, userId.asString());
        body.put(NetworkKeys.installationId, installationId);
        body.put(NetworkKeys.deviceType, installationId);

        try {
            String appSignature = DeviceUtil.getAppSignature(AdpPushClient.getContext());
            if (appSignature != null) {
                body.put(NetworkKeys.appSessionId, appSignature);
            } else {
                body.put(NetworkKeys.appSessionId, "INVALID");
            }
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        body.put(NetworkKeys.appTokenId, DeviceUtil.base64CreateFingerprint(AdpPushClient.getContext()));

        body.put(NetworkKeys.eventData, data);

        try {
            Integer l = String.valueOf(JsonUtils.mapToJson(body))
                    .replaceAll("(\\\\.)", "/")
                    .length();

            String type = body.get(NetworkKeys.deviceType).toString();

            String manId = ChabokUtils.getManufacturerId(userId, installationId, type, ts, l);
            if (manId != null) {
                body.put(NetworkKeys.sessionId, manId);
            }

        } catch (JSONException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }

        String params = (new JSONObject(body)).toString();

        String restApi = NetworkPreferences.getInstance().getRestApi() + NetworkKeys.eventsRoot;

        Logger.v("************* New API Call ************* ~~~> ", "Event Called!!!");

        HttpRequestHandler httpRequestHandler = new HttpRequestHandler();
        httpRequestHandler.sendHttpRequest(HttpRequestType.POST,params,NetworkProperties.getPublicHeaders(),restApi,callback);

    }

    public static void deferredDeepLink(String installationId, final com.adpdigital.push.Callback callback) {
        Map<String, Object> map = new HashMap<>();
        map.put(NetworkKeys.id, installationId);
        String params = (new JSONObject(map)).toString();

        String restApi = NetworkPreferences.getInstance().getRestApi() + NetworkKeys.installations + "/"+ installationId + NetworkKeys.deferredDeepLinkRoot;

        Logger.v("************* New APi Call ************* ~~~> ", "Deferred DeepLink Called!!!");

        HttpRequestHandler httpRequestHandler = new HttpRequestHandler();
        httpRequestHandler.sendHttpRequest(HttpRequestType.GET, params, NetworkProperties.getPublicHeaders(), restApi, new Callback() {
            @Override
            public void onSuccess(Object value) {
                Uri deeplink = null;
                String label = null;
                if (value != null) {
                    Map resMap = MapUtils.objectToMap(value);
                    if (resMap != null && resMap.containsKey(NetworkKeys.deepLink)) {
                        if (resMap.get(NetworkKeys.deepLink) != null) {
                            String deepLinkString = resMap.get(NetworkKeys.deepLink).toString();
                            deeplink = Uri.parse(deepLinkString);
                        }
                    }
                    if (resMap != null && resMap.containsKey(NetworkKeys.label)){
                        if (resMap.get(NetworkKeys.label) != null) {
                            label = resMap.get(NetworkKeys.label).toString();
                        }
                    }
                }
                if (callback != null) {
                    callback.onSuccess(new DeferredData(deeplink, label));
                }
            }

            @Override
            public void onFailure(Throwable t) {
                if (callback != null) {
                    callback.onFailure(t);
                }
            }
        });

    }

    public static void requestCode(String userId, String appId, String media, com.adpdigital.push.Callback callback) {
        Map<String, Object> map = new HashMap<>();
        map.put(NetworkKeys.userId, userId);
        if(appId != null) map.put(NetworkKeys.appId, appId);
        if(media != null) map.put(NetworkKeys.media, media);
        String params = (new JSONObject(map)).toString();

        String restApi = NetworkPreferences.getInstance().getRestApi() + NetworkKeys.requestCodeRoot;

        Logger.v("************* New APi Call ************* ~~~> ", "Request Code Called!!!");

        HttpRequestHandler httpRequestHandler = new HttpRequestHandler();
        httpRequestHandler.sendHttpRequest(HttpRequestType.POST,params,NetworkProperties.getPublicHeaders(),restApi,callback);

    }

    public static void verifyUserCode(String userId,String code,com.adpdigital.push.Callback callback) {
        Map<String, Object> map = new HashMap<>();
        map.put(NetworkKeys.userId, userId);
        map.put(NetworkKeys.code, code);
        String params = (new JSONObject(map)).toString();

        String restApi = NetworkPreferences.getInstance().getRestApi() + NetworkKeys.verifyCodeRoot;

        Logger.v("************* New APi Call ************* ~~~> ", "Verify User Code Called!!!");

        HttpRequestHandler httpRequestHandler = new HttpRequestHandler();
        httpRequestHandler.sendHttpRequest(HttpRequestType.POST,params,NetworkProperties.getPublicHeaders(),restApi,callback);

    }

    public static void updateDeviceToken(Map<String, Object> data, com.adpdigital.push.Callback callback) {
        String params = (new JSONObject(data)).toString();

        String restApi = NetworkPreferences.getInstance().getRestApi() + NetworkKeys.updateDeviceTokenRoot;

        HttpRequestHandler httpRequestHandler = new HttpRequestHandler();
        httpRequestHandler.sendHttpRequest(HttpRequestType.POST,params,NetworkProperties.getPublicHeaders(),restApi,callback);

    }
}
