package com.adpdigital.push.config;

import com.adpdigital.push.AdpPushClient;

class SandboxConfig extends Configuration {

    @Override
    public void init() {
        apiKey = Configuration.decrypt(ResUtils.getResourceValue(AdpPushClient.getContext(), "S_S_AY"));
        appId = Configuration.decrypt(ResUtils.getResourceValue(AdpPushClient.getContext(), "S_S_AD"));
        username = Configuration.decrypt(ResUtils.getResourceValue(AdpPushClient.getContext(), "S_S_UE"));
        password = Configuration.decrypt(ResUtils.getResourceValue(AdpPushClient.getContext(), "S_S_PD"));
        realtime = Boolean.parseBoolean(ResUtils.getResourceValue(AdpPushClient.getContext(), "S_N_RE"));
        pushNotification = Boolean.parseBoolean(ResUtils.getResourceValue(AdpPushClient.getContext(), "S_N_PN"));
    }

    @Override
    public String environment() {
        return "sandbox";
    }
}
