package com.adpdigital.push;

import android.os.Bundle;

import org.json.JSONException;
import org.json.JSONObject;

public class ChabokEvent {
    protected Double revenue;
    protected JSONObject data;
    protected String currency;

    public ChabokEvent(double revenue) {
        setRevenue(revenue);
    }

    public ChabokEvent(double revenue, String currency) {
        setRevenue(revenue, currency);
    }

    public void setRevenue(double revenue) {
        if (!checkRevenue(revenue)) return;

        this.revenue = revenue;
    }

    public void setRevenue(double revenue, String currency) {
        if (!checkRevenue(revenue)) return;
        if (!checkCurrency(currency)) return;

        this.revenue = revenue;
        this.currency = currency;
    }

    public void setData(JSONObject data) {
        this.data = data;
    }

    public void setData(Bundle data) {
        if (data == null) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        for (String key : data.keySet()) {
            try {
                jsonObject.put(key, DataConverter.wrapWithDatetime(data.get(key)));
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.data = jsonObject;
    }

    private boolean checkRevenue(Double revenue) {
        if (revenue == null) {
            Logger.e(Logger.TAG, "Amount is null");
            return false;
        }
        if (revenue < 0.0) {
            Logger.e(Logger.TAG, "Invalid amount " + revenue);
            return false;
        }


        return true;
    }

    private boolean checkCurrency(String currency) {
        if (currency == null) {
            Logger.e(Logger.TAG, "Currency must be set with revenue");
            return false;
        }
        if (currency.equals("")) {
            Logger.e(Logger.TAG, "Currency is empty");
            return false;
        }
        return true;
    }
}
